/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.validators;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.promptset.Prompt;
import org.squashtest.tm.plugin.rest.admin.jackson.model.PromptDto;
import org.squashtest.tm.plugin.rest.admin.validators.HelpValidator;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.service.internal.repository.PromptDao;
import org.squashtest.tm.service.internal.repository.PromptSetDao;

@Component
public class PromptValidator
implements Validator {
    private static final String PATCH_PROMPT = "patch-prompt";
    private static final String POST_PROMPT = "post-prompt";
    private final PromptDao promptDao;
    private final PromptSetDao promptSetDao;
    private final HelpValidator helpValidator;

    public PromptValidator(PromptDao promptDao, PromptSetDao promptSetDao, HelpValidator helpValidator) {
        this.promptDao = promptDao;
        this.promptSetDao = promptSetDao;
        this.helpValidator = helpValidator;
    }

    public boolean supports(Class<?> aClass) {
        return PromptDto.class.equals(aClass);
    }

    public void validate(Object target, Errors errors) {
    }

    public void promptPostValidator(PromptDto promptDto) throws BindException {
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)promptDto, POST_PROMPT);
        if (promptDto.getId() != null) {
            validation.rejectValue("id", "generated value", "This attribute is generated by database. ");
        }
        this.validatePromptSetExists((Errors)validation, promptDto.getPromptSetId());
        this.validateName((Errors)validation, promptDto.getName(), promptDto.getPromptSetId());
        this.validateSystemPromptTemplate((Errors)validation, promptDto);
        this.validateUserPromptTemplate((Errors)validation, promptDto);
        if (validation.hasErrors()) {
            errors.add(validation);
        }
        ErrorHandlerHelper.throwIfError((Object)promptDto, errors, (String)POST_PROMPT);
    }

    public void promptPatchValidator(Long promptId, PromptDto promptDto) throws BindException {
        Optional prompt;
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)promptDto, PATCH_PROMPT);
        this.validatePromptExists(promptId, (BindingResult)validation);
        if (promptDto.getName() != null && (prompt = this.promptDao.findById((Object)promptId)).isPresent() && !((Prompt)prompt.get()).getName().equals(promptDto.getName())) {
            this.validateName((Errors)validation, promptDto.getName(), ((Prompt)prompt.get()).getPromptSet().getId());
        }
        if (promptDto.getSystemPromptTemplate() != null) {
            this.validateSystemPromptTemplate((Errors)validation, promptDto);
        }
        if (promptDto.getUserPromptTemplate() != null) {
            this.validateUserPromptTemplate((Errors)validation, promptDto);
        }
        if (validation.hasErrors()) {
            errors.add(validation);
        }
        ErrorHandlerHelper.throwIfError((Object)promptDto, errors, (String)PATCH_PROMPT);
    }

    private void validatePromptExists(Long promptId, BindingResult validation) {
        if (this.promptDao.findById((Object)promptId).isEmpty()) {
            String message = String.format("No entity known for type Prompt and id %d", promptId);
            validation.rejectValue("id", "invalid id", message);
        }
    }

    private void validateName(Errors errors, String name, Long promptSetId) {
        if (StringUtils.isBlank((CharSequence)name)) {
            this.helpValidator.validateAttributes("name", errors);
        } else {
            Prompt existingPrompt = this.promptDao.findByNameAndPromptSetId(name, promptSetId);
            if (Objects.nonNull(existingPrompt)) {
                errors.rejectValue("name", "invalid value", "The name is already used by another prompt inside the prompt set. ");
            }
        }
    }

    private void validateSystemPromptTemplate(Errors errors, PromptDto promptDto) {
        if (StringUtils.isBlank((CharSequence)promptDto.getSystemPromptTemplate())) {
            this.helpValidator.validateAttributes("systemPromptTemplate", errors);
        } else {
            this.helpValidator.validateHandlebarsTemplate(errors, "systemPromptTemplate", promptDto.getSystemPromptTemplate());
        }
    }

    private void validateUserPromptTemplate(Errors errors, PromptDto promptDto) {
        if (StringUtils.isBlank((CharSequence)promptDto.getUserPromptTemplate())) {
            this.helpValidator.validateAttributes("userPromptTemplate", errors);
        } else {
            this.helpValidator.validateHandlebarsTemplate(errors, "userPromptTemplate", promptDto.getUserPromptTemplate());
        }
    }

    private void validatePromptSetExists(Errors errors, Long promptSetId) {
        if (promptSetId == null) {
            this.helpValidator.validateAttributes("promptSetId", errors);
        } else if (this.promptSetDao.findById((Object)promptSetId).isEmpty()) {
            String message = String.format("No entity known for type PromptSet and id %d", promptSetId);
            errors.rejectValue("promptSetId", "invalid id", message);
        }
    }
}

