/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.validators;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.PersistenceContext;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.squashtest.tm.core.foundation.exception.ActionException;
import org.squashtest.tm.domain.aiserver.AiProvider;
import org.squashtest.tm.domain.aiserver.AiServer;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.plugin.rest.admin.jackson.model.AiUsageDto;
import org.squashtest.tm.plugin.rest.admin.jackson.model.ProjectAiConfigurationDto;
import org.squashtest.tm.plugin.rest.admin.validators.HelpValidator;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.plugin.rest.jackson.model.GenericProjectDto;
import org.squashtest.tm.service.internal.repository.AiServerDao;
import org.squashtest.tm.service.internal.repository.PromptSetDao;

@Component
public class ProjectValidator
implements Validator {
    public static final String BIND_TEST_AUTOMATION_SERVER_TO_PROJECT = "bind-test-automation-server-to-project";
    public static final String UNBIND_TEST_AUTOMATION_SERVER_FROM_PROJECT = "unbind-test-automation-server-from-project";
    private static final String POST_PROJECT_AI_CONFIGURATION = "post-project-ai-configuration";
    private static final String PATCH_PROJECT_AI_CONFIGURATION = "patch-project-ai-configuration";
    private static final String DELETE_PROJECT_AI_CONFIGURATION = "delete-project-ai-configuration";
    private static final String INVALID_ID = "Invalid id";
    private static final String AI_SERVER_ID = "aiServerId";
    private static final String PROJECT = "project";
    private final AiServerDao aiServerDao;
    private final PromptSetDao promptSetDao;
    private final HelpValidator helpValidator;
    @PersistenceContext
    protected EntityManager entityManager;

    public ProjectValidator(PromptSetDao promptSetDao, AiServerDao aiServerDao, HelpValidator helpValidator) {
        this.promptSetDao = promptSetDao;
        this.aiServerDao = aiServerDao;
        this.helpValidator = helpValidator;
    }

    public boolean supports(Class<?> clazz) {
        return GenericProjectDto.class.equals(clazz);
    }

    public void validate(Object target, Errors errors) {
    }

    public void validateBindTestAutomationServerToProject(long projectId, long serverId) throws BindException {
        TestAutomationServer bindTestAutomationServerToProject = new TestAutomationServer();
        BeanPropertyBindingResult validationBean = new BeanPropertyBindingResult((Object)bindTestAutomationServerToProject, BIND_TEST_AUTOMATION_SERVER_TO_PROJECT);
        GenericProject project = (GenericProject)this.entityManager.find(GenericProject.class, (Object)projectId);
        this.checkEntityExists(projectId, project, PROJECT, (BindingResult)validationBean);
        TestAutomationServer testAutomationServer = (TestAutomationServer)this.entityManager.find(TestAutomationServer.class, (Object)serverId);
        this.checkEntityExists(serverId, testAutomationServer, "test-automation-server", (BindingResult)validationBean);
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        if (validationBean.hasErrors()) {
            errors.add(validationBean);
        }
        ErrorHandlerHelper.throwIfError((Object)bindTestAutomationServerToProject, errors, (String)BIND_TEST_AUTOMATION_SERVER_TO_PROJECT);
    }

    private void validateProjectExists(BindingResult validation, long projectId) {
        GenericProject project = (GenericProject)this.entityManager.find(GenericProject.class, (Object)projectId);
        this.checkEntityExists(projectId, project, PROJECT, validation);
    }

    private void checkEntityExists(long entityId, Object entity, String entityType, BindingResult validationBean) {
        if (Objects.isNull(entity)) {
            String message = String.format("No entity known for type %s and id %d", entityType, entityId);
            validationBean.rejectValue("id", INVALID_ID, message);
        }
    }

    public void validateUnbindTestAutomationServerFromProject(long projectId) throws BindException {
        TestAutomationServer unbindTestAutomationServerFromProject = new TestAutomationServer();
        BeanPropertyBindingResult validationBean = new BeanPropertyBindingResult((Object)unbindTestAutomationServerFromProject, UNBIND_TEST_AUTOMATION_SERVER_FROM_PROJECT);
        this.validateProjectExists((BindingResult)validationBean, projectId);
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        if (validationBean.hasErrors()) {
            errors.add(validationBean);
        }
        ErrorHandlerHelper.throwIfError((Object)unbindTestAutomationServerFromProject, errors, (String)BIND_TEST_AUTOMATION_SERVER_TO_PROJECT);
    }

    public void validateGetProjectAiConfigurations(Long projectId) {
        this.checkProjectExists(projectId);
        this.verifyCurrentBoundAiServerIsNotLegacy(projectId, "GET");
    }

    public void validatePostAiConfiguration(Long projectId, ProjectAiConfigurationDto projectAiConfigurationDto) throws BindException {
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)projectAiConfigurationDto, POST_PROJECT_AI_CONFIGURATION);
        if (projectAiConfigurationDto.getId() != null) {
            validation.rejectValue("id", "generated value", "This attribute is generated by database. ");
        }
        this.validateProjectExists((BindingResult)validation, projectId);
        this.helpValidator.validateAiUsage((BindingResult)validation, projectAiConfigurationDto.getAiUsage());
        this.validateAiServerExists((BindingResult)validation, projectAiConfigurationDto.getAiServerId());
        this.validateAiServerToBindIsNotLegacy((BindingResult)validation, projectAiConfigurationDto.getAiServerId());
        this.validatePromptSetExists((BindingResult)validation, projectAiConfigurationDto.getPromptSetId());
        if (validation.hasErrors()) {
            errors.add(validation);
        }
        ErrorHandlerHelper.throwIfError((Object)projectAiConfigurationDto, errors, (String)POST_PROJECT_AI_CONFIGURATION);
    }

    public void validatePatchProjectAiConfiguration(long projectId, ProjectAiConfigurationDto projectAiConfigurationDto) throws BindException {
        this.verifyCurrentBoundAiServerIsNotLegacy(projectId, "PATCH");
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)projectAiConfigurationDto, PATCH_PROJECT_AI_CONFIGURATION);
        this.validateProjectExists((BindingResult)validation, projectId);
        this.helpValidator.validateAiUsage((BindingResult)validation, projectAiConfigurationDto.getAiUsage());
        if (projectAiConfigurationDto.getAiServerId() != null) {
            this.validateAiServerExists((BindingResult)validation, projectAiConfigurationDto.getAiServerId());
            this.validateAiServerToBindIsNotLegacy((BindingResult)validation, projectAiConfigurationDto.getAiServerId());
        }
        if (projectAiConfigurationDto.getPromptSetId() != null) {
            this.validatePromptSetExists((BindingResult)validation, projectAiConfigurationDto.getPromptSetId());
        }
        if (validation.hasErrors()) {
            errors.add(validation);
        }
        ErrorHandlerHelper.throwIfError((Object)projectAiConfigurationDto, errors, (String)PATCH_PROJECT_AI_CONFIGURATION);
    }

    public void validateDeleteProjectAiConfiguration(Long projectId, AiUsageDto aiUsageDto) throws BindException {
        this.verifyCurrentBoundAiServerIsNotLegacy(projectId, "DELETE");
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)aiUsageDto, DELETE_PROJECT_AI_CONFIGURATION);
        this.helpValidator.validateAiUsage((BindingResult)validation, aiUsageDto.getAiUsage());
        if (validation.hasErrors()) {
            errors.add(validation);
        }
        ErrorHandlerHelper.throwIfError((Object)projectId, errors, (String)DELETE_PROJECT_AI_CONFIGURATION);
    }

    private void validateAiServerExists(BindingResult validation, Long aiServerId) {
        if (aiServerId == null) {
            this.helpValidator.validateAttributes(AI_SERVER_ID, (Errors)validation);
        } else if (this.aiServerDao.findById((Object)aiServerId).isEmpty()) {
            String message = String.format("No entity known for type AiServer and id %d", aiServerId);
            validation.rejectValue(AI_SERVER_ID, INVALID_ID, message);
        }
    }

    private void validateAiServerToBindIsNotLegacy(BindingResult validation, Long aiServerId) {
        Optional aiServer;
        if (aiServerId != null && (aiServer = this.aiServerDao.findById((Object)aiServerId)).isPresent() && AiProvider.NONE.equals((Object)((AiServer)aiServer.get()).getProvider())) {
            String message = String.format("AiServer with id %d is legacy and can not be bound to the project", aiServerId);
            validation.rejectValue(AI_SERVER_ID, "invalid value", message);
        }
    }

    private void validatePromptSetExists(BindingResult validation, Long promptSetId) {
        if (promptSetId == null) {
            this.helpValidator.validateAttributes("promptSetId", (Errors)validation);
        } else if (this.promptSetDao.findById((Object)promptSetId).isEmpty()) {
            String message = String.format("No entity known for type PromptSet and id %d", promptSetId);
            validation.rejectValue("promptSetId", INVALID_ID, message);
        }
    }

    private void verifyCurrentBoundAiServerIsNotLegacy(long projectId, String httpMethodName) {
        GenericProject project = (GenericProject)this.entityManager.find(GenericProject.class, (Object)projectId);
        if (Objects.nonNull(project) && Objects.nonNull(project.getAiServer()) && AiProvider.NONE.equals((Object)project.getAiServer().getProvider())) {
            String message = String.format("The AI server currently bound to the project is a legacy AI server. %s is not allowed.", httpMethodName);
            throw new ActionException(message);
        }
    }

    private void checkProjectExists(long projectId) {
        GenericProject project = (GenericProject)this.entityManager.find(GenericProject.class, (Object)projectId);
        if (Objects.isNull(project)) {
            String message = String.format("No entity known for type %s and id %d", PROJECT, projectId);
            throw new EntityNotFoundException(message);
        }
    }
}

