/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.controller;

import jakarta.inject.Inject;
import jakarta.servlet.ServletContext;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.plugin.rest.admin.jackson.model.MilestoneDto;
import org.squashtest.tm.plugin.rest.admin.service.RestMilestoneAdminService;
import org.squashtest.tm.plugin.rest.admin.validators.MilestoneValidator;
import org.squashtest.tm.plugin.rest.controller.RestCampaignController;
import org.squashtest.tm.plugin.rest.controller.RestProjectController;
import org.squashtest.tm.plugin.rest.controller.RestRequirementVersionController;
import org.squashtest.tm.plugin.rest.controller.RestTestCaseController;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.service.feature.FeatureManager;

@RestApiController(value=Milestone.class)
@UseDefaultRestApiConfiguration
public class RestMilestoneAdminController
extends BaseRestController {
    private static final String ENABLED = "enabled";
    public static final String MILESTONE_FEATURE_ENABLED_CONTEXT_ATTR = "milestoneFeatureEnabled";
    private final Object monitor = new Object();
    @Inject
    private ServletContext applicationScope;
    @Inject
    private FeatureManager featureManager;
    @Inject
    private RestMilestoneAdminService restMilestoneAdminService;
    @Inject
    private MilestoneValidator milestoneValidator;

    @GetMapping(value={"/milestones"})
    @ResponseBody
    @DynamicFilterExpression(value="*, -created_by, -created_on , -last_modified_by, -last_modified_on")
    public ResponseEntity<PagedModel<EntityModel<Milestone>>> findAllReadableMilestones(Pageable pageable) {
        Page<Milestone> pagedMilestones = this.restMilestoneAdminService.findAllMilestone(pageable);
        PagedModel res = this.toPagedModel(pagedMilestones);
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/milestones/{id}"})
    @ResponseBody
    @EntityGetter
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<Milestone>> findMilestoneById(@PathVariable(value="id") Long milestoneId) {
        Milestone milestone = this.restMilestoneAdminService.findMilestoneById(milestoneId);
        EntityModel res = this.toEntityModel((Identified)milestone);
        res.add(this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo((Object)((RestProjectController)WebMvcLinkBuilder.methodOn(RestProjectController.class, (Object[])new Object[0])).findAllReadableProjects(null, null, milestoneId, null))).withRel("projects"));
        res.add(this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo((Object)((RestTestCaseController)WebMvcLinkBuilder.methodOn(RestTestCaseController.class, (Object[])new Object[0])).getAllReadableTestCases(null, null, milestoneId, null))).withRel("test-cases"));
        res.add(this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo((Object)((RestCampaignController)WebMvcLinkBuilder.methodOn(RestCampaignController.class, (Object[])new Object[0])).findCampaigns(null, milestoneId, null, null))).withRel("campaigns"));
        res.add(this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo((Object)((RestRequirementVersionController)WebMvcLinkBuilder.methodOn(RestRequirementVersionController.class, (Object[])new Object[0])).findRequirementVersions(milestoneId, null, null))).withRel("requirement-versions"));
        return ResponseEntity.ok((Object)res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/milestones/activate"}, params={"enabled"})
    @ResponseBody
    @Secured(value={"ROLE_ADMIN"})
    public ResponseEntity<Void> activateMilestoneMode(@RequestParam(value="enabled") boolean enabled) {
        Object object = this.monitor;
        synchronized (object) {
            Object prevState = this.applicationScope.getAttribute(MILESTONE_FEATURE_ENABLED_CONTEXT_ATTR);
            this.applicationScope.setAttribute(MILESTONE_FEATURE_ENABLED_CONTEXT_ATTR, (Object)false);
            try {
                this.featureManager.setEnabled(FeatureManager.Feature.MILESTONE, enabled);
                this.applicationScope.setAttribute(MILESTONE_FEATURE_ENABLED_CONTEXT_ATTR, (Object)enabled);
            }
            catch (RuntimeException ex) {
                this.applicationScope.setAttribute(MILESTONE_FEATURE_ENABLED_CONTEXT_ATTR, prevState);
                throw ex;
            }
        }
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"/milestones"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<EntityModel<Milestone>> addMilestones(@RequestBody MilestoneDto milestoneDto) {
        Milestone milestone = this.restMilestoneAdminService.addMilestone(milestoneDto);
        EntityModel res = this.toEntityModel((Identified)milestone);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)res);
    }

    @PatchMapping(value={"/milestones/{id}"})
    @ResponseBody
    @DynamicFilterExpression
    public ResponseEntity<EntityModel<Milestone>> patchMilestone(@PathVariable(value="id") Long milestoneId, @RequestBody MilestoneDto milestoneDto) throws BindException {
        this.milestoneValidator.milestonePatchValidator(milestoneId, milestoneDto);
        Milestone milestone = this.restMilestoneAdminService.updateMilestone(milestoneId, milestoneDto);
        EntityModel res = this.toEntityModel((Identified)milestone);
        return ResponseEntity.ok((Object)res);
    }

    @ResponseBody
    @DeleteMapping(value={"/milestones/{ids}"})
    public ResponseEntity<Void> removeMilestones(@PathVariable(value="ids") List<Long> milestoneIds) {
        this.restMilestoneAdminService.deleteMilestone(milestoneIds);
        return ResponseEntity.noContent().build();
    }
}

