/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.validators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.plugin.rest.admin.jackson.model.ReportingFieldDto;
import org.squashtest.tm.plugin.rest.admin.validators.RestJiraSyncApiValidator;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;

@Component
public class ReportingFieldValidator
extends RestJiraSyncApiValidator {
    private static final String PATCH_REPORTING_FIELD_VALIDATION = "patch-reporting-field-validation";
    private static final Set<String> REPORTING_FIELDS_SET;

    static {
        HashSet<String> initialSet = new HashSet<String>();
        initialSet.addAll(Arrays.asList("testingStatus", "redactionProgress", "verificationProgress", "validationProgress", "redactionRatio", "verificationRatio", "validationRatio"));
        REPORTING_FIELDS_SET = Collections.unmodifiableSet(initialSet);
    }

    public boolean supports(Class<?> clazz) {
        return ReportingFieldDto.class.equals(clazz);
    }

    public void validatePatchReportingField(Long projectId, String squashField, ReportingFieldDto reportingFieldDto) throws BindException {
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        BeanPropertyBindingResult validationBean = new BeanPropertyBindingResult((Object)reportingFieldDto, PATCH_REPORTING_FIELD_VALIDATION);
        this.checkEntityExist((Errors)validationBean, Project.class, projectId);
        if (!REPORTING_FIELDS_SET.contains(squashField)) {
            validationBean.rejectValue("squashField", "invalid SquashTM field", "SquashTM field with name '" + squashField + "' does not exist");
        }
        if (Objects.nonNull(reportingFieldDto.getSquashField())) {
            validationBean.rejectValue("squashField", "invalid SquashTM field", "SquashTM field cannot be modified");
        }
        if (Objects.isNull(reportingFieldDto.getJiraField())) {
            validationBean.rejectValue("jiraField", "invalid jira field", "jira field cannot be null");
        }
        if (validationBean.hasErrors()) {
            errors.add(validationBean);
        }
        ErrorHandlerHelper.throwIfError((Object)reportingFieldDto, errors, (String)PATCH_REPORTING_FIELD_VALIDATION);
    }
}

