/*
 * Decompiled with CFR 0.152.
 */
package jirasync.com.atlassian.jira.rest.client.internal.json;

import java.net.URI;
import jirasync.com.atlassian.jira.rest.client.api.domain.RoleActor;
import jirasync.com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import jirasync.com.sun.ws.rs.core.UriBuilder;
import jirasync.org.codehaus.jettison.json.JSONException;
import jirasync.org.codehaus.jettison.json.JSONObject;

public class RoleActorJsonParser
implements JsonObjectParser<RoleActor> {
    private final URI baseJiraUri;

    public RoleActorJsonParser(URI baseJiraUri) {
        this.baseJiraUri = baseJiraUri;
    }

    @Override
    public RoleActor parse(JSONObject json) throws JSONException {
        Long id = JsonParseUtil.getOptionalLong(json, "id");
        String displayName = json.getString("displayName");
        String type = json.getString("type");
        String name = json.getString("name");
        return new RoleActor(id, displayName, type, name, this.parseAvatarUrl(json));
    }

    private URI parseAvatarUrl(JSONObject json) {
        String pathToAvatar = JsonParseUtil.getOptionalString(json, "avatarUrl");
        if (pathToAvatar != null) {
            URI avatarUri = UriBuilder.fromUri(pathToAvatar).build(new Object[0]);
            return avatarUri.isAbsolute() ? avatarUri : this.baseJiraUri.resolve(pathToAvatar);
        }
        return null;
    }
}

