/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import jakarta.inject.Inject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.campaign.ExploratorySessionOverview;
import org.squashtest.tm.domain.execution.ExploratoryExecution;
import org.squashtest.tm.plugin.rest.repository.RestExploratorySessionRepository;
import org.squashtest.tm.plugin.rest.service.RestExploratorySessionService;

@Service
@Transactional
public class RestExploratorySessionServiceImpl
implements RestExploratorySessionService {
    @Inject
    private RestExploratorySessionRepository exploratorySessionRepository;

    @Override
    @PreAuthorize(value="hasPermission(#sessionId, 'org.squashtest.tm.domain.campaign.ExploratorySessionOverview', 'READ') or hasRole('ROLE_ADMIN')")
    @Transactional(readOnly=true)
    public ExploratorySessionOverview getOne(long sessionId) {
        return (ExploratorySessionOverview)this.exploratorySessionRepository.getReferenceById(sessionId);
    }

    @Override
    public Page<ExploratoryExecution> findExploratoryExecutionsByTpiId(long tpiId, Pageable pageable) {
        return this.exploratorySessionRepository.findAllExploratoryExecutionsByTpiId(tpiId, pageable);
    }
}

