/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.jiracloud.internal.operations;

import java.util.Iterator;
import jiracloud.com.atlassian.jira.rest.client.api.GetCreateIssueMetadataOptions;
import jiracloud.com.atlassian.jira.rest.client.api.GetCreateIssueMetadataOptionsBuilder;
import jiracloud.com.atlassian.jira.rest.client.api.domain.CimProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.exceptions.JiraProjectNotFound;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.extension.ExtendedJiraRestClient;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.operations.JiraRestClientOperation;

public class GetProjectForCreateByKey
extends JiraRestClientOperation<CimProject> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetProjectForCreateByKey.class);
    private String projectKey;

    public GetProjectForCreateByKey(ExtendedJiraRestClient client, String projectKey) {
        super(client);
        this.projectKey = projectKey;
    }

    @Override
    public CimProject doIt() {
        LOGGER.debug("calling rest client : fetch issue create metadata for project '{}'", (Object)this.projectKey);
        GetCreateIssueMetadataOptions options = new GetCreateIssueMetadataOptionsBuilder().withProjectKeys(this.projectKey).withExpandedIssueTypesFields().build();
        Iterable<CimProject> cimProjects = this.client.getIssueClient().getCreateIssueMetadata(options).claim();
        Iterator<CimProject> iterator = cimProjects.iterator();
        if (iterator.hasNext()) {
            LOGGER.debug("metadata found");
            return iterator.next();
        }
        LOGGER.debug("Attempted to retrieve issue creation metadata for project '{}', which resulted in a status 200 yet empty response. Most of the time this signals that a project could not be found but other possible (and unknown) factors should not be excluded either.", (Object)this.projectKey);
        throw new JiraProjectNotFound(this.projectKey);
    }
}

