/*
 * Decompiled with CFR 0.152.
 */
package jiracloud.org.apache.http.impl.nio.client;

import java.io.Closeable;
import java.net.URI;
import java.util.concurrent.Future;
import jiracloud.org.apache.http.HttpHost;
import jiracloud.org.apache.http.HttpRequest;
import jiracloud.org.apache.http.HttpResponse;
import jiracloud.org.apache.http.annotation.Contract;
import jiracloud.org.apache.http.annotation.ThreadingBehavior;
import jiracloud.org.apache.http.client.ClientProtocolException;
import jiracloud.org.apache.http.client.methods.HttpUriRequest;
import jiracloud.org.apache.http.client.protocol.HttpClientContext;
import jiracloud.org.apache.http.client.utils.URIUtils;
import jiracloud.org.apache.http.concurrent.BasicFuture;
import jiracloud.org.apache.http.concurrent.FutureCallback;
import jiracloud.org.apache.http.nio.client.HttpAsyncClient;
import jiracloud.org.apache.http.nio.client.methods.HttpAsyncMethods;
import jiracloud.org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import jiracloud.org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import jiracloud.org.apache.http.protocol.HttpContext;
import jiracloud.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public abstract class CloseableHttpAsyncClient
implements HttpAsyncClient,
Closeable {
    public abstract boolean isRunning();

    public abstract void start();

    @Override
    public <T> Future<T> execute(HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, FutureCallback<T> callback) {
        return this.execute(requestProducer, responseConsumer, (HttpContext)HttpClientContext.create(), callback);
    }

    @Override
    public Future<HttpResponse> execute(HttpHost target, HttpRequest request, HttpContext context, FutureCallback<HttpResponse> callback) {
        return this.execute(HttpAsyncMethods.create(target, request), HttpAsyncMethods.createConsumer(), context, callback);
    }

    @Override
    public Future<HttpResponse> execute(HttpHost target, HttpRequest request, FutureCallback<HttpResponse> callback) {
        return this.execute(target, request, (HttpContext)HttpClientContext.create(), callback);
    }

    @Override
    public Future<HttpResponse> execute(HttpUriRequest request, FutureCallback<HttpResponse> callback) {
        return this.execute(request, HttpClientContext.create(), callback);
    }

    @Override
    public Future<HttpResponse> execute(HttpUriRequest request, HttpContext context, FutureCallback<HttpResponse> callback) {
        HttpHost target;
        try {
            target = this.determineTarget(request);
        }
        catch (ClientProtocolException ex) {
            BasicFuture<HttpResponse> future = new BasicFuture<HttpResponse>(callback);
            future.failed(ex);
            return future;
        }
        return this.execute(target, request, context, callback);
    }

    private HttpHost determineTarget(HttpUriRequest request) throws ClientProtocolException {
        Args.notNull(request, "HTTP request");
        HttpHost target = null;
        URI requestURI = request.getURI();
        if (requestURI.isAbsolute() && (target = URIUtils.extractHost(requestURI)) == null) {
            throw new ClientProtocolException("URI does not specify a valid host name: " + requestURI);
        }
        return target;
    }
}

