/*
 * Decompiled with CFR 0.152.
 */
package jiracloud.com.atlassian.jira.rest.client.api;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import jiracloud.com.atlassian.jira.rest.client.api.domain.util.ErrorCollection;

public class RestClientException
extends RuntimeException {
    private final Optional<Integer> statusCode;
    private final Collection<ErrorCollection> errorCollections;

    public RestClientException(RestClientException exception) {
        super(exception.getMessage(), exception);
        this.statusCode = exception.getStatusCode();
        this.errorCollections = exception.errorCollections;
    }

    public RestClientException(Throwable cause) {
        super(cause);
        this.errorCollections = Collections.emptyList();
        this.statusCode = Optional.absent();
    }

    public RestClientException(Throwable cause, int statusCode) {
        super(cause);
        this.errorCollections = Collections.emptyList();
        this.statusCode = Optional.of((Object)statusCode);
    }

    public RestClientException(String errorMessage, Throwable cause) {
        super(errorMessage, cause);
        this.errorCollections = ImmutableList.of((Object)new ErrorCollection(errorMessage));
        this.statusCode = Optional.absent();
    }

    public RestClientException(Collection<ErrorCollection> errorCollections, int statusCode) {
        super(errorCollections.toString());
        this.errorCollections = ImmutableList.copyOf(errorCollections);
        this.statusCode = Optional.of((Object)statusCode);
    }

    public RestClientException(Collection<ErrorCollection> errorCollections, Throwable cause, int statusCode) {
        super(errorCollections.toString(), cause);
        this.errorCollections = ImmutableList.copyOf(errorCollections);
        this.statusCode = Optional.of((Object)statusCode);
    }

    public Collection<ErrorCollection> getErrorCollections() {
        return this.errorCollections;
    }

    public Optional<Integer> getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String toString() {
        return "RestClientException{statusCode=" + this.statusCode + ", errorCollections=" + this.errorCollections + '}';
    }
}

