/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.saml.properties;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.IDPEntry;
import org.opensaml.saml.saml2.core.IDPList;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml.saml2.core.RequesterID;
import org.opensaml.saml.saml2.core.Scoping;
import org.opensaml.saml.saml2.core.impl.AuthnContextClassRefBuilder;
import org.opensaml.saml.saml2.core.impl.IDPEntryBuilder;
import org.opensaml.saml.saml2.core.impl.IDPListBuilder;
import org.opensaml.saml.saml2.core.impl.NameIDPolicyBuilder;
import org.opensaml.saml.saml2.core.impl.RequestedAuthnContextBuilder;
import org.opensaml.saml.saml2.core.impl.RequesterIDBuilder;
import org.opensaml.saml.saml2.core.impl.ScopingBuilder;
import org.springframework.util.CollectionUtils;

public class DefaultWebSSOProfileOptions {
    private Boolean passive = false;
    private Boolean forceAuthn = false;
    private String binding;
    private String providerName;
    private String nameID;
    private Boolean allowCreate;
    private Collection<String> authnContexts;
    private AuthnContextComparisonTypeEnumeration authnContextComparison;
    private Set<String> allowedIDPs;
    private boolean includeScoping = false;
    private Integer proxyCount = 2;
    private Set<String> requesterIds;
    private String relayState;

    public void configureAuthnRequest(AuthnRequest request) {
        request.setIsPassive(this.passive);
        request.setForceAuthn(this.forceAuthn);
        if (this.binding != null) {
            request.setProtocolBinding(this.binding);
        }
        if (this.providerName != null) {
            request.setProviderName(this.providerName);
        }
        this.buildScoping(request);
        this.buildNameIDPolicy(request);
        this.buildAuthnContext(request);
    }

    private void buildNameIDPolicy(AuthnRequest request) {
        if (this.nameID == null) {
            return;
        }
        NameIDPolicy nameIDPolicy = new NameIDPolicyBuilder().buildObject();
        nameIDPolicy.setAllowCreate(this.allowCreate);
        nameIDPolicy.setFormat(this.nameID);
        request.setNameIDPolicy(nameIDPolicy);
    }

    private void buildAuthnContext(AuthnRequest request) {
        if (this.authnContexts == null || this.authnContexts.isEmpty()) {
            return;
        }
        RequestedAuthnContext requestedAuthnContext = new RequestedAuthnContextBuilder().buildObject();
        requestedAuthnContext.setComparison(this.authnContextComparison);
        List contextClassRefs = requestedAuthnContext.getAuthnContextClassRefs();
        for (String context : this.authnContexts) {
            AuthnContextClassRef authnContextClassRef = new AuthnContextClassRefBuilder().buildObject();
            authnContextClassRef.setURI(context);
            contextClassRefs.add(authnContextClassRef);
        }
        request.setRequestedAuthnContext(requestedAuthnContext);
    }

    private void buildScoping(AuthnRequest request) {
        if (!this.includeScoping) {
            return;
        }
        IDPList idpList = this.buildIDPList();
        Scoping scoping = new ScopingBuilder().buildObject();
        scoping.setProxyCount(this.proxyCount);
        scoping.setIDPList(idpList);
        if (!CollectionUtils.isEmpty(this.requesterIds)) {
            RequesterIDBuilder requesterIDBuilder = new RequesterIDBuilder();
            List ids = scoping.getRequesterIDs();
            for (String id : this.requesterIds) {
                RequesterID requesterID = requesterIDBuilder.buildObject();
                requesterID.setURI(id);
                ids.add(requesterID);
            }
        }
        request.setScoping(scoping);
    }

    private IDPList buildIDPList() {
        if (this.allowedIDPs == null || this.allowedIDPs.isEmpty()) {
            return null;
        }
        IDPList idpList = new IDPListBuilder().buildObject();
        List entries = idpList.getIDPEntrys();
        for (String idp : this.allowedIDPs) {
            IDPEntry entry = new IDPEntryBuilder().buildObject();
            entry.setProviderID(idp);
            entries.add(entry);
        }
        return idpList;
    }

    public String getRelayState() {
        return this.relayState;
    }

    public boolean containRelayState() {
        return this.relayState != null && !this.relayState.isEmpty();
    }

    public void setPassive(Boolean passive) {
        this.passive = passive;
    }

    public void setForceAuthn(Boolean forceAuthn) {
        this.forceAuthn = forceAuthn;
    }

    public void setBinding(String binding) {
        this.binding = binding;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public void setAuthnContexts(Collection<String> authnContexts) {
        this.authnContexts = authnContexts;
    }

    public void setNameID(String nameID) {
        this.nameID = nameID;
    }

    public void setAllowCreate(Boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    public void setAllowedIDPs(Set<String> allowedIDPs) {
        this.allowedIDPs = allowedIDPs;
    }

    public void setAuthnContextComparison(AuthnContextComparisonTypeEnumeration authnContextComparison) {
        this.authnContextComparison = authnContextComparison;
    }

    public void setIncludeScoping(boolean includeScoping) {
        this.includeScoping = includeScoping;
    }

    public void setProxyCount(Integer proxyCount) {
        this.proxyCount = proxyCount;
    }

    public void setRequesterIds(Set<String> requesterIds) {
        this.requesterIds = requesterIds;
    }

    public void setRelayState(String relayState) {
        this.relayState = relayState;
    }
}

