--  Lock Database
UPDATE DATABASECHANGELOGLOCK SET `LOCKED` = 1, LOCKEDBY = 'runner-yfpexrfv8-project-33554404-concurrent-0-w3zx56dl (100.64.5.128)', LOCKGRANTED = NOW() WHERE ID = 1 AND `LOCKED` = 0;

--  *********************************************************************
--  Update Database Script
--  *********************************************************************
--  Change Log: upgrade.changelog-up-to-12.0.0.xml
--  Ran at: 07/11/2025 16:08
--  Against: root@jdbc:mariadb://mariadb/squashtest
--  Liquibase version: 4.31.1
--  *********************************************************************

--  Changeset tm/tm.changelog-12.0.0.xml::tm-12.0.0-add-provider-column-to-ai-server-table::dclaerhout
--  Add new PROVIDER column to AI_SERVER table
ALTER TABLE AI_SERVER ADD PROVIDER VARCHAR(50) DEFAULT 'NONE' NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-12.0.0-add-provider-column-to-ai-server-table', 'dclaerhout', 'tm/tm.changelog-12.0.0.xml', NOW(), 1, '9:5f1ab6c7d733f0af783d662095a2d7c3', 'addColumn tableName=AI_SERVER', 'Add new PROVIDER column to AI_SERVER table', 'EXECUTED', NULL, NULL, '4.31.1', '2528086623');

--  Changeset tm/tm.changelog-12.0.0.xml::tm-12.0.0-add-model-name-column-to-ai-server-table::dclaerhout
--  Add new MODEL_NAME column to AI_SERVER table
ALTER TABLE AI_SERVER ADD MODEL_NAME VARCHAR(100) NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-12.0.0-add-model-name-column-to-ai-server-table', 'dclaerhout', 'tm/tm.changelog-12.0.0.xml', NOW(), 2, '9:603b92acf22060d4cc16498d79fbbb80', 'addColumn tableName=AI_SERVER', 'Add new MODEL_NAME column to AI_SERVER table', 'EXECUTED', NULL, NULL, '4.31.1', '2528086623');

--  Changeset tm/tm.changelog-12.0.0.xml::tm-12.0.0-add-options-column-to-ai-server-table::dclaerhout
--  Add new OPTIONS column to AI_SERVER table
ALTER TABLE AI_SERVER ADD OPTIONS LONGTEXT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-12.0.0-add-options-column-to-ai-server-table', 'dclaerhout', 'tm/tm.changelog-12.0.0.xml', NOW(), 3, '9:28203d84cb1883eaf7ea8ac2edcffae0', 'addColumn tableName=AI_SERVER', 'Add new OPTIONS column to AI_SERVER table', 'EXECUTED', NULL, NULL, '4.31.1', '2528086623');

--  Changeset tm/tm.changelog-12.0.0.xml::tm-12.0.0-add-foreign-key-in-api-token-table-for-user-id-column::mbrugniere
--  Add foreign key constraint to API_TOKEN.USER_ID referencing CORE_USER.PARTY_ID
DELETE FROM API_TOKEN
      WHERE USER_ID NOT IN (SELECT PARTY_ID FROM CORE_USER);

ALTER TABLE API_TOKEN ADD CONSTRAINT fk_api_token_core_user FOREIGN KEY (USER_ID) REFERENCES CORE_USER (PARTY_ID) ON DELETE CASCADE;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-12.0.0-add-foreign-key-in-api-token-table-for-user-id-column', 'mbrugniere', 'tm/tm.changelog-12.0.0.xml', NOW(), 4, '9:a355dbbb5a332b2103d8df20ebb3310c', 'sql; addForeignKeyConstraint baseTableName=API_TOKEN, constraintName=fk_api_token_core_user, referencedTableName=CORE_USER', 'Add foreign key constraint to API_TOKEN.USER_ID referencing CORE_USER.PARTY_ID', 'EXECUTED', NULL, NULL, '4.31.1', '2528086623');

--  Changeset tm/tm.changelog-12.0.0.xml::tm-12.0.0-add-sprint-count-subquery-to-query-tables::lmurat
--  Add new subquery counting sprints to test case search
INSERT INTO QUERY_MODEL (NAME, STRATEGY, JOIN_STYLE)
      VALUES ('TEST_CASE_SPRINTCOUNT_SUBQUERY', 'SUBQUERY', 'LEFT_JOIN');

INSERT INTO QUERY_COLUMN_PROTOTYPE(COLUMN_TYPE, BUSINESS, LABEL, ENTITY_TYPE, ENTITY_ROLE,
                                         DATA_TYPE, ATTRIBUTE_NAME, SUBQUERY_ID)
      VALUES ('CALCULATED', FALSE, 'TEST_CASE_SPRINTCOUNT', 'TEST_CASE', null, 'NUMERIC',
              'count(sprints)', (select max(QUERY_MODEL_ID) from QUERY_MODEL));

INSERT INTO QUERY_PROJECTION_COLUMN(QUERY_COLUMN_ID, QUERY_MODEL_ID, LABEL, PROJECTION_OPERATION, PROJECTION_RANK, CUF_ID)
      VALUES (
        (select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'SPRINT_ID'),
        (select max(QUERY_MODEL_ID) from QUERY_MODEL),
        null, 'COUNT', 0, null
      );

INSERT INTO QUERY_AGGREGATION_COLUMN(QUERY_MODEL_ID, QUERY_COLUMN_ID, LABEL, AGGREGATION_OPERATION, AGGREGATION_RANK, CUF_ID)
      VALUES (
                 (select max(QUERY_MODEL_ID) from QUERY_MODEL),
                 (select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'TEST_CASE_SPRINTCOUNT'),
                 null, 'NONE', 0, null
             );

INSERT INTO QUERY_ORDERING_COLUMN(QUERY_MODEL_ID, QUERY_COLUMN_ID, ORDER_OPERATION, ORDER_RANK, ORDER_DIR, CUF_ID)
      VALUES (
        (select max(QUERY_MODEL_ID) from QUERY_MODEL),
        (select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'TEST_CASE_ID'),
        'NONE', 0, 'ASC', null
      );

INSERT INTO QUERY_ORDERING_COLUMN(QUERY_MODEL_ID, QUERY_COLUMN_ID, ORDER_OPERATION, ORDER_RANK, ORDER_DIR, CUF_ID)
      VALUES (
        (select max(QUERY_MODEL_ID) from QUERY_MODEL),
        (select QUERY_COLUMN_ID from QUERY_COLUMN_PROTOTYPE where label = 'SPRINT_ID'),
        'COUNT', 1, 'ASC', null
      );

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-12.0.0-add-sprint-count-subquery-to-query-tables', 'lmurat', 'tm/tm.changelog-12.0.0.xml', NOW(), 5, '9:f6cb3b2b3e3d8516e934776c5fc7bf71', 'sql; sql; sql; sql; sql; sql', 'Add new subquery counting sprints to test case search', 'EXECUTED', NULL, NULL, '4.31.1', '2528086623');

--  Changeset tm/tm.changelog-12.0.0.xml::tm-12.0.0-add-sequence-for-ai-usage-mariadb::mbrugniere
CREATE SEQUENCE IF NOT EXISTS ai_usage_ai_usage_id_seq START WITH 1 INCREMENT BY 1 CACHE 1;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-12.0.0-add-sequence-for-ai-usage-mariadb', 'mbrugniere', 'tm/tm.changelog-12.0.0.xml', NOW(), 6, '9:c9d82fa67579271616b591179bd5fda9', 'sql', '', 'EXECUTED', NULL, NULL, '4.31.1', '2528086623');

--  Changeset tm/tm.changelog-12.0.0.xml::tm-12.0.0-create-table-ai-usage-h2-mariadb::mbrugniere
CREATE TABLE AI_USAGE (AI_USAGE_ID BIGINT DEFAULT NEXT VALUE FOR ai_usage_ai_usage_id_seq NOT NULL, `USAGE` VARCHAR(100) NOT NULL, CONSTRAINT pk_ai_usage PRIMARY KEY (AI_USAGE_ID), CONSTRAINT uq_ai_usage_usage UNIQUE (`USAGE`));

INSERT INTO AI_USAGE (`USAGE`) VALUES ('CLASSIC_TEST_CASE_GENERATION');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-12.0.0-create-table-ai-usage-h2-mariadb', 'mbrugniere', 'tm/tm.changelog-12.0.0.xml', NOW(), 7, '9:007045b2e7a3f6e12c034b10550dca18', 'createTable tableName=AI_USAGE; insert tableName=AI_USAGE', '', 'EXECUTED', NULL, NULL, '4.31.1', '2528086623');

--  Changeset tm/tm.changelog-12.0.0.xml::tm-12.0.0-add-sequence-for-prompt-set-mariadb::dclaerhout
CREATE SEQUENCE IF NOT EXISTS prompt_set_prompt_set_id_seq START WITH 1 INCREMENT BY 1 CACHE 1;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-12.0.0-add-sequence-for-prompt-set-mariadb', 'dclaerhout', 'tm/tm.changelog-12.0.0.xml', NOW(), 8, '9:6a29058ce1b72fde3da3020b0f6bba85', 'sql', '', 'EXECUTED', NULL, NULL, '4.31.1', '2528086623');

--  Changeset tm/tm.changelog-12.0.0.xml::tm-12.0.0-create-prompt-set-table-h2-mariadb::dclaerhout
--  Create prompt set table
CREATE TABLE PROMPT_SET (PROMPT_SET_ID BIGINT DEFAULT NEXT VALUE FOR prompt_set_prompt_set_id_seq NOT NULL, NAME VARCHAR(255) NOT NULL, AI_USAGE_ID BIGINT NOT NULL, `DESCRIPTION` LONGTEXT NULL, CREATED_BY VARCHAR(100) NOT NULL, CREATED_ON datetime NOT NULL, LAST_MODIFIED_BY VARCHAR(100) DEFAULT null NULL, LAST_MODIFIED_ON datetime DEFAULT null NULL, CONSTRAINT pk_prompt_set PRIMARY KEY (PROMPT_SET_ID));

ALTER TABLE PROMPT_SET ADD CONSTRAINT fk_prompt_set_ai_usage FOREIGN KEY (AI_USAGE_ID) REFERENCES AI_USAGE (AI_USAGE_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-12.0.0-create-prompt-set-table-h2-mariadb', 'dclaerhout', 'tm/tm.changelog-12.0.0.xml', NOW(), 9, '9:4f9c200fa4aaba74acf19b4ba59bb010', 'createTable tableName=PROMPT_SET; addForeignKeyConstraint baseTableName=PROMPT_SET, constraintName=fk_prompt_set_ai_usage, referencedTableName=AI_USAGE', 'Create prompt set table', 'EXECUTED', NULL, NULL, '4.31.1', '2528086623');

--  Changeset tm/tm.changelog-12.0.0.xml::tm-12.0.0-create-index-for-prompt-set-table-h2-mariadb::mbrugniere
CREATE INDEX idx_prompt_set_ai_usage_id ON PROMPT_SET(AI_USAGE_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-12.0.0-create-index-for-prompt-set-table-h2-mariadb', 'mbrugniere', 'tm/tm.changelog-12.0.0.xml', NOW(), 10, '9:5592c87625e564aeb2a8e5f75579e507', 'createIndex indexName=idx_prompt_set_ai_usage_id, tableName=PROMPT_SET', '', 'EXECUTED', NULL, NULL, '4.31.1', '2528086623');

--  Changeset tm/tm.changelog-12.0.0.xml::tm-12.0.0-add-sequence-for-prompt-mariadb::dclaerhout
CREATE SEQUENCE IF NOT EXISTS prompt_prompt_id_seq START WITH 1 INCREMENT BY 1 CACHE 1;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-12.0.0-add-sequence-for-prompt-mariadb', 'dclaerhout', 'tm/tm.changelog-12.0.0.xml', NOW(), 11, '9:42cd59d901c8c783c76d767fe3738b7a', 'sql', '', 'EXECUTED', NULL, NULL, '4.31.1', '2528086623');

--  Changeset tm/tm.changelog-12.0.0.xml::tm-12.0.0-create-prompt-table-h2-mariadb::dclaerhout
--  Create prompt table
CREATE TABLE PROMPT (PROMPT_ID BIGINT DEFAULT NEXT VALUE FOR prompt_prompt_id_seq NOT NULL, PROMPT_SET_ID BIGINT NOT NULL COMMENT 'fk to the parent prompt set', NAME VARCHAR(255) NOT NULL, SYSTEM_PROMPT_TEMPLATE LONGTEXT DEFAULT '' NOT NULL, USER_PROMPT_TEMPLATE LONGTEXT DEFAULT '' NOT NULL, CONSTRAINT pk_prompt PRIMARY KEY (PROMPT_ID), CONSTRAINT fk_prompt_prompt_set FOREIGN KEY (PROMPT_SET_ID) REFERENCES PROMPT_SET(PROMPT_SET_ID));

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-12.0.0-create-prompt-table-h2-mariadb', 'dclaerhout', 'tm/tm.changelog-12.0.0.xml', NOW(), 12, '9:df33d60450acd33183c6753f45132f03', 'createTable tableName=PROMPT', 'Create prompt table', 'EXECUTED', NULL, NULL, '4.31.1', '2528086623');

--  Changeset tm/tm.changelog-12.0.0.xml::tm-12.0.0-modify-accepted-attachment-extensions-for-automated-test-suite-import::ssviridov
UPDATE CORE_CONFIG SET VALUE = 'txt, html, xml, log' WHERE STR_KEY = 'uploadfilter.fileExtensions.resultImport.whitelist';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-12.0.0-modify-accepted-attachment-extensions-for-automated-test-suite-import', 'ssviridov', 'tm/tm.changelog-12.0.0.xml', NOW(), 13, '9:3fb237bf4f4732c797e375fa293c54f4', 'update tableName=CORE_CONFIG', '', 'EXECUTED', NULL, NULL, '4.31.1', '2528086623');

--  Changeset tm/tm.changelog-12.0.0.xml::tm-12.0.0-add-sequence-for-project-ai-configuration-mariadb::mbrugniere
CREATE SEQUENCE IF NOT EXISTS project_ai_configuration_project_ai_configuration_id_seq START WITH 1 INCREMENT BY 1 CACHE 1;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-12.0.0-add-sequence-for-project-ai-configuration-mariadb', 'mbrugniere', 'tm/tm.changelog-12.0.0.xml', NOW(), 14, '9:85e48dde18c975f913f753b5a95e551b', 'sql', '', 'EXECUTED', NULL, NULL, '4.31.1', '2528086623');

--  Changeset tm/tm.changelog-12.0.0.xml::tm-12.0.0-create-table-project-ai-configuration-h2-mariadb::mbrugniere
CREATE TABLE PROJECT_AI_CONFIGURATION (PROJECT_AI_CONFIGURATION_ID BIGINT DEFAULT NEXT VALUE FOR project_ai_configuration_project_ai_configuration_id_seq NOT NULL, PROJECT_ID BIGINT NOT NULL, AI_USAGE_ID BIGINT NOT NULL, AI_SERVER_ID BIGINT NULL, PROMPT_SET_ID BIGINT NULL, CONSTRAINT pk_project_ai_configuration PRIMARY KEY (PROJECT_AI_CONFIGURATION_ID));

ALTER TABLE PROJECT_AI_CONFIGURATION ADD CONSTRAINT fk_project_ai_configuration_project FOREIGN KEY (PROJECT_ID) REFERENCES PROJECT (PROJECT_ID);

ALTER TABLE PROJECT_AI_CONFIGURATION ADD CONSTRAINT fk_project_ai_configuration_ai_usage FOREIGN KEY (AI_USAGE_ID) REFERENCES AI_USAGE (AI_USAGE_ID);

ALTER TABLE PROJECT_AI_CONFIGURATION ADD CONSTRAINT fk_project_ai_configuration_ai_server FOREIGN KEY (AI_SERVER_ID) REFERENCES AI_SERVER (SERVER_ID);

ALTER TABLE PROJECT_AI_CONFIGURATION ADD CONSTRAINT fk_project_ai_configuration_prompt_set FOREIGN KEY (PROMPT_SET_ID) REFERENCES PROMPT_SET (PROMPT_SET_ID);

ALTER TABLE PROJECT_AI_CONFIGURATION ADD CONSTRAINT uq_project_ai_configuration_project_id_ai_usage_id UNIQUE (PROJECT_ID, AI_USAGE_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-12.0.0-create-table-project-ai-configuration-h2-mariadb', 'mbrugniere', 'tm/tm.changelog-12.0.0.xml', NOW(), 15, '9:6f8ff5541e35612425d72c5309abc5c7', 'createTable tableName=PROJECT_AI_CONFIGURATION; addForeignKeyConstraint baseTableName=PROJECT_AI_CONFIGURATION, constraintName=fk_project_ai_configuration_project, referencedTableName=PROJECT; addForeignKeyConstraint baseTableName=PROJECT_AI_CONFI...', '', 'EXECUTED', NULL, NULL, '4.31.1', '2528086623');

--  Changeset tm/tm.changelog-12.0.0.xml::tm-12.0.0-create-indexes-for-project-ai-configuration-table::mbrugniere
CREATE INDEX idx_project_ai_configuration_project_id ON PROJECT_AI_CONFIGURATION(PROJECT_ID);

CREATE INDEX idx_project_ai_configuration_ai_usage_id ON PROJECT_AI_CONFIGURATION(AI_USAGE_ID);

CREATE INDEX idx_project_ai_configuration_ai_server_id ON PROJECT_AI_CONFIGURATION(AI_SERVER_ID);

CREATE INDEX idx_project_ai_configuration_prompt_set_id ON PROJECT_AI_CONFIGURATION(PROMPT_SET_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-12.0.0-create-indexes-for-project-ai-configuration-table', 'mbrugniere', 'tm/tm.changelog-12.0.0.xml', NOW(), 16, '9:47f079fe0d0775f86bceec62f4f961ed', 'createIndex indexName=idx_project_ai_configuration_project_id, tableName=PROJECT_AI_CONFIGURATION; createIndex indexName=idx_project_ai_configuration_ai_usage_id, tableName=PROJECT_AI_CONFIGURATION; createIndex indexName=idx_project_ai_configurati...', '', 'EXECUTED', NULL, NULL, '4.31.1', '2528086623');

--  Changeset tm/tm.changelog-12.0.0.xml::tm-12.0.0-add-modified-on-and-modified-by-columns-to-failure-details::ssviridov
ALTER TABLE FAILURE_DETAIL ADD LAST_MODIFIED_BY VARCHAR(50) DEFAULT null NULL;

ALTER TABLE FAILURE_DETAIL ADD LAST_MODIFIED_ON datetime DEFAULT null NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-12.0.0-add-modified-on-and-modified-by-columns-to-failure-details', 'ssviridov', 'tm/tm.changelog-12.0.0.xml', NOW(), 17, '9:aef31d7fa1fc4eeb2dd4e3b72da208a1', 'addColumn tableName=FAILURE_DETAIL; addColumn tableName=FAILURE_DETAIL', '', 'EXECUTED', NULL, NULL, '4.31.1', '2528086623');

--  Changeset tm/tm.changelog-12.0.0.xml::tm-12.0.0-change-business-value-in-query_column_prototype-table::bmarejus
--  Change business value to false for item-test-plan-tester query column prototype and to true for item-test-plan-lastexecby
UPDATE QUERY_COLUMN_PROTOTYPE
      SET BUSINESS = FALSE
      WHERE LABEL = 'ITEM_TEST_PLAN_TESTER';

UPDATE QUERY_COLUMN_PROTOTYPE
      SET BUSINESS = TRUE
      WHERE LABEL = 'ITEM_TEST_PLAN_LASTEXECBY';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-12.0.0-change-business-value-in-query_column_prototype-table', 'bmarejus', 'tm/tm.changelog-12.0.0.xml', NOW(), 18, '9:2e46aa3a84acd70c4b80284ed1365903', 'sql; sql', 'Change business value to false for item-test-plan-tester query column prototype and to true for item-test-plan-lastexecby', 'EXECUTED', NULL, NULL, '4.31.1', '2528086623');

--  Changeset tm/tm.changelog-12.0.0.xml::tm-12.0.0::lmurat
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '12.0.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-12.0.0', 'lmurat', 'tm/tm.changelog-12.0.0.xml', NOW(), 19, '9:c53f13fbc283d6aed143ef24fd9ba515', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, NULL, '4.31.1', '2528086623');

--  Release Database Lock
UPDATE DATABASECHANGELOGLOCK SET `LOCKED` = 0, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;

