/*
 *     This file is part of the Campaign Assistant for Squash TM (henix-tm-wizard-campaignassistant) project.
 *     Copyright (C) 2017 Henix - All Rights Reserved
 *
 *     Unauthorized copying of this file, via any medium is strictly prohibited
 *     Proprietary and confidential
 *
 * 	 (C)Henix. Tous droits réservés.
 *
 * 	Avertissement : ce programme est protégé par la loi relative au droit d'auteur et par les conventions internationales. Toute reproduction ou distribution partielle ou totale du logiciel, par quelque moyen que ce soit, est strictement interdite.
 */
define(["jquery", "workspace.routing", "backbone", "underscore", "handlebars", "./abstractStepView", 'squash.configmanager', "is", "jquery.cookie"],
	function($, router, backbone, _, Handlebars, AbstractStepView, confman, is) {
	"use strict";

	var targetIterationStepView = AbstractStepView.extend({

		initialize : function(data, wizrouter) {
			this.tmpl = "#target-iteration-step-tpl";
			this.model = data;
			data.name = "targetIterationStep";
			this._initialize(data, wizrouter);
			this.initializeReference();
		},

        prepareUI: function() {
            var self = this;
            self.$el.addClass("not-displayed");
            self._loadRichText(function() {
                self.$el.removeClass("not-displayed");
            });
        },

		_loadRichText: function(callback) {
			var conf = confman.getStdCkeditor();
            $("#new-it-description").ckeditor(callback, conf);
		},

		reloadDataInView: function() {

			var emptyIteration = {
				name: "",
				reference: "",
				description : ""
			};
			var newIteration = this.model.get("newIteration") || emptyIteration;

			$("#new-it-name").val(newIteration.name);
			$("#new-it-reference").val(newIteration.reference);
			$("#new-it-description").val(newIteration.description);

			this._hideErrorMessage();

		},

		updateModel: function() {

			var name = $("#new-it-name").val();
			var reference = $("#new-it-reference").val();
			var description = $("#new-it-description").val();

			var newIteration = {
				name: name,
				reference: reference,
				description: description
			};

			this.model.set({
				newIteration: newIteration
			});

		},

        initializeReference: function() {
            if ($("#new-it-reference").val() === "") {
                var iterationId = this.model.get("replicationParameters").iterationId;
                $.ajax({
                    method: "GET",
                    contentType: "application/json",
                    url: squashtm.app.contextRoot + "campaign-assistant/iteration-replication/count-iterations",
                    data: {
                        iterationId: iterationId
                    }
                }).success(function(nbIterations) {
                    $("#new-it-reference").val(nbIterations + 1);
                });
            }
        },

        createIteration: function() {

            var self = this;
            this.updateModel();
            self._hideErrorMessage();

            var newIteration = this.model.get("newIteration");
            var iterationName = newIteration.name;

            if(_.isEmpty(iterationName)) {
                this._showErrorMessage("no-name");
            } else if(self._isNameAlreadyInUse(iterationName)) {
                this._showErrorMessage("existing-name");
            } else {
                // Preventing double click.
                $("#create").prop('disabled', true);
                this._doCreateIteration();
            }
        },

        _isNameAlreadyInUse: function(name) {
            var availableIterations = this.model.get("availableIterations");
            var availableIterationsNames = _.pluck(availableIterations, "name");
            return _.contains(availableIterationsNames, name);
        },

        _showErrorMessage: function(errorCode) {
            switch(errorCode) {
                case "no-name":
                    $("#no-name-error-message").removeClass("not-displayed");
                    break;
                case "existing-name":
                    $("#existing-name-error-message").removeClass("not-displayed");
                    break;
            }
        },

        _hideErrorMessage: function() {

            $(".error-message").addClass("not-displayed");
        },

        _doCreateIteration: function() {
            var self = this;
            $.ajax({
                method: "POST",
                contentType: "application/json",
                url: squashtm.app.contextRoot + "campaign-assistant/iteration-replication/create",
                data: this.model.replicationModelToJson()
            }).success(function(iterationId) {

                var nodeToSelect = "Iteration-" + iterationId;
                var path = self._getCookiePath();
                $.cookie("jstree_select", nodeToSelect, { path: path });

                var redirectUrl = router.buildURL("campaigns.workspace");
                document.location.href = redirectUrl;
            }).always(function() {
                // Show the previously disabled button
                $("#create").prop('disabled', false);
            });
        },

        /**
        * IE and FF add a trailing / to cookies...
        * Chrome don't...
        * So we need to put the good path to avoid two jstree_select cookies with differents path.
        */
        _getCookiePath : function () {
            var path = "/squash/campaign-workspace";
        	if(is.ie()||is.firefox()){
        	    path = path + "/";
        	}
        	return path;
        }
	});

	return targetIterationStepView;

});
