/*
 *     This file is part of the Campaign Assistant for Squash TM (henix-tm-wizard-campaignassistant) project.
 *     Copyright (C) 2017 Henix - All Rights Reserved
 *
 *     Unauthorized copying of this file, via any medium is strictly prohibited
 *     Proprietary and confidential
 *
 * 	 (C)Henix. Tous droits réservés.
 *
 * 	Avertissement : ce programme est protégé par la loi relative au droit d'auteur et par les conventions internationales. Toute reproduction ou distribution partielle ou totale du logiciel, par quelque moyen que ce soit, est strictement interdite.
 */
define(["jquery", "backbone", "underscore", "handlebars", "./abstractStepView"],
	function($, backbone, _, Handlebars, AbstractStepView) {
	"use strict";

	var actionChoiceStepView = AbstractStepView.extend({

        disabledActions: {
            "CAMPAIGN_LIBRARY": ["iterationReplication", "iterationCreation"],
            "CAMPAIGN_FOLDER": ["iterationReplication", "iterationCreation"],
            "CAMPAIGN": [],
            "ITERATION": ["campaignCreation"]
        },

		initialize : function(data, wizrouter) {
			this.tmpl = "#action-choice-step-tpl";
			this.model = data;
			data.name = "actionChoiceStep";
			this._initialize(data, wizrouter);
		},

        reloadDataInView : function() {

            var selectedNode = this.model.get("selectedNode");
            var selectedAction = this.model.get("action");
            if(!selectedAction) {
                selectedAction = this._determineDefaultAction(selectedNode.type);
            }
            this._disableForbiddenOptions(selectedNode.type);
            this._doReselectAction(selectedAction);

            /* Displays message if no action is available for the selected tree node. */
            if(selectedNode.type === "CAMPAIGN_LIBRARY" || selectedNode.type === "CAMPAIGN_FOLDER") {
                this._displayNotSupportedActionsMessage();
                this._disableAllButtons();
            }
        },

        updateModel : function() {
            var selectedAction = this.$("input:radio:checked").val();
            this.model.set({
                action: selectedAction
            });
        },

        _displayNotSupportedActionsMessage: function() {
            var message = this.$el.find("#warning-message");
            message.removeClass("not-displayed");
        },

		_determineDefaultAction: function(nodeType) {
		    var action = "";
		    switch(nodeType) {
		        case "CAMPAIGN_LIBRARY":
		        case "CAMPAIGN_FOLDER":
		            action = "campaignCreation";
		            break;
		        case "CAMPAIGN":
		            // action = "iterationCreation";
		            action = "iterationReplication";
		            break;
		        case "ITERATION":
		            action = "iterationReplication";
		            break;
		    }
		    return action;
		},

        _doReselectAction: function(selectedAction) {
            var $radio = this.$("input:radio[name=actionChoice][value='" + selectedAction + "']");
            $radio.prop("checked", true);
        },

        _doDisableOption: function(action) {
            var $radio = this.$("input:radio[name=actionChoice][value='" + action + "']");
            $radio.attr("disabled", true);
            this.$("label[for='" + $radio.attr("id") + "']").addClass("ui-state-disabled");
        },

        _disableForbiddenOptions: function(nodeType) {
            var self = this;
            var disabledActions = self.disabledActions[nodeType];
            $(disabledActions).each(function(index, action) {
                self._doDisableOption(action);
            });
        }

	});

	return actionChoiceStepView;

});
