/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.redminereq;

import org.springframework.context.i18n.LocaleContextHolder;
import org.squashtest.tm.api.plugin.EntityReference;
import org.squashtest.tm.api.plugin.PluginValidationException;
import org.squashtest.tm.api.wizard.InternationalizedWorkspaceWizard;
import org.squashtest.tm.plugin.redminereq.domain.Configuration;
import org.squashtest.tm.plugin.redminereq.service.PluginDao;
import org.squashtest.tm.web.i18n.InternationalizationHelper;

public class RedmineReqPlugin
extends InternationalizedWorkspaceWizard {
    private static final String URL_TEMPLATE = "plugin/redminereq/project/{projectId}/configuration";
    public static final String PLUGIN_ID = "squash.tm.plugin.redminereq";
    public static final String SERVER_ID = "serverId";
    public static final String FILTER_BINDING = "filterBinding";
    public static final String FIELD_MAPPING = "attributeMappings";
    public static final String FIELD_LINK = "attributeLinks";
    public static final String VALUES_MAPPING = "valuesMapping";
    public static final String OPTIONS = "allowToDeleteReq";
    private PluginDao dao;
    private InternationalizationHelper langHelper;

    public void setDao(PluginDao dao) {
        this.dao = dao;
    }

    public void setLangHelper(InternationalizationHelper langHelper) {
        this.langHelper = langHelper;
    }

    public void validate(EntityReference reference) {
        Configuration conf = this.dao.getConfigurationForProject(reference.getId());
        if (!conf.hasServer()) {
            throw new PluginValidationException(this.langHelper.getMessage("henix.redminereq.configuration.validation.noserver", null, "No requirements manager server was configured", LocaleContextHolder.getLocale()));
        }
    }

    public String getConfigurationPath(EntityReference context) {
        Long id = context.getId();
        return URL_TEMPLATE.replace("{projectId}", id.toString());
    }
}

