/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.jirarest.internal.conversion;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jirarest.com.atlassian.jira.rest.client.api.domain.BasicUser;
import jirarest.com.atlassian.jira.rest.client.api.domain.Version;
import jirarest.com.atlassian.jira.rest.client.api.domain.input.AttachmentInput;
import jirarest.com.atlassian.jira.rest.client.api.domain.input.ComplexIssueInputFieldValue;
import jirarest.com.atlassian.jira.rest.client.api.domain.input.FieldInput;
import jirarest.com.atlassian.jira.rest.client.api.domain.input.IssueInput;
import jirarest.com.atlassian.jira.rest.client.api.domain.input.IssueInputBuilder;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Scope;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.squashtest.csp.core.bugtracker.core.BugTrackerLocalException;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedIssue;
import org.squashtest.tm.bugtracker.advanceddomain.Field;
import org.squashtest.tm.bugtracker.advanceddomain.FieldValue;
import org.squashtest.tm.bugtracker.advanceddomain.InputType;
import org.squashtest.tm.bugtracker.definition.Attachment;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.conversion.EntityMapping;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.exceptions.NumberConversionException;

@Component
@Scope(value="prototype")
public class SquashToJiraEntityConverter {
    public static final Logger LOGGER = LoggerFactory.getLogger(SquashToJiraEntityConverter.class);
    private static final String I18N_KEY_ISSUE_DEFAULT_DESCRIPTION_DESCRIPTION = "issue.default.description.description";
    private static final String I18N_KEY_ISSUE_DEFAULT_ADDITIONAL_INFORMATION_ACTION = "issue.default.additionalInformation.action";
    private static final String I18N_KEY_ISSUE_DEFAULT_ADDITIONAL_INFORMATION_EXPECTED_RESULT = "issue.default.additionalInformation.expectedResult";
    private static final String I18N_KEY_BUGTRACKER_JIRAREST_ISSUE_DEFAULT_ADDITIONAL_INFORMATION_SCRIPT = "issue.default.additionalInformation.script";
    @Inject
    @Named(value="jiraRestConnectorMessageSource")
    private MessageSource messageSource;

    IssueInput squash2jiraIssue(AdvancedIssue issue, long issueTypeId) throws NumberConversionException {
        String projectKey = issue.getProject().getId();
        IssueInputBuilder builder = new IssueInputBuilder(projectKey, issueTypeId);
        for (String key : issue.getFieldValues().keySet()) {
            FieldInput input;
            Map<String, Object> map;
            FieldValue value = issue.getFieldValue(key);
            if ("-1".equals(value.getId())) continue;
            if ("versions".equals(key) && value.hasCompositeValue()) {
                builder.setAffectedVersionsNames(this.extractStringListFromFieldValue(value));
                continue;
            }
            if ("assignee".equals(key)) {
                String name = value.getScalar();
                if (name == null || name.trim().equals("")) {
                    name = "-1";
                }
                builder.setAssigneeName(name);
                continue;
            }
            if ("components".equals(key) && value.hasCompositeValue()) {
                builder.setComponentsNames(this.extractStringListFromFieldValue(value));
                continue;
            }
            if ("description".equals(key) && value.hasScalarValue()) {
                Locale locale = LocaleContextHolder.getLocale();
                Object resultDescription = value.getScalar();
                String formatHeaderRegex = "(\\A)\\s*(.*)";
                Matcher m = this.getMatcher((String)resultDescription, formatHeaderRegex);
                resultDescription = m.replaceAll("{panel:title= $2}");
                String stepFormatRegex = "(^\\s*=+\\s*$)\n(.*)\n(=+)";
                m = this.getMatcher((String)resultDescription, stepFormatRegex);
                resultDescription = m.replaceAll("{panel}{panel:title= $2} \n");
                String issueDescriptionToFormat = this.messageSource.getMessage(I18N_KEY_ISSUE_DEFAULT_DESCRIPTION_DESCRIPTION, null, locale);
                m = this.getMatcher((String)resultDescription, issueDescriptionToFormat);
                resultDescription = m.replaceAll("_$0_");
                String titleEnhancementRegexForAction = "(-{19}+)\\s*([\\w\u00e9\u00e8\u00ea\u00e0\u00f3&%]+[ ]*[\\w\u00e9\u00e8\u00ea\u00e0\u00f3&%]*)\\s*(-+)";
                String actionLabel = this.messageSource.getMessage(I18N_KEY_ISSUE_DEFAULT_ADDITIONAL_INFORMATION_ACTION, null, locale);
                m = this.getMatcher((String)resultDescription, titleEnhancementRegexForAction);
                resultDescription = m.replaceAll("*" + actionLabel + "*");
                String titleEnhancementRegexForExpectedResult = "(-{16}+)\\s*([\\w\u00e9\u00e8\u00ea\u00e0&%]+[ ]*[\\w\u00e9\u00e8\u00ea\u00e0&%]*)\\s*(-+)";
                String expectedResultLabel = this.messageSource.getMessage(I18N_KEY_ISSUE_DEFAULT_ADDITIONAL_INFORMATION_EXPECTED_RESULT, null, locale);
                m = this.getMatcher((String)resultDescription, titleEnhancementRegexForExpectedResult);
                resultDescription = m.replaceAll("---------- \n *" + expectedResultLabel + "*");
                String titleEnhancementRegexForScript = "(-{15}+)\\s*([\\w\u00e9\u00e8\u00ea\u00e0&%]+[ ]*[\\w\u00e9\u00e8\u00ea\u00e0&%]*)\\s*(-+)";
                String scriptLabel = this.messageSource.getMessage(I18N_KEY_BUGTRACKER_JIRAREST_ISSUE_DEFAULT_ADDITIONAL_INFORMATION_SCRIPT, null, locale);
                m = this.getMatcher((String)resultDescription, titleEnhancementRegexForScript);
                resultDescription = m.replaceAll("*" + scriptLabel + "*");
                resultDescription = (String)resultDescription + "\n {panel}";
                builder.setDescription((String)resultDescription);
                continue;
            }
            if ("duedate".equals(key) && value.hasScalarValue()) {
                DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
                builder.setDueDate(formatter.parseDateTime(value.getScalar()));
                continue;
            }
            if ("fixVersions".equals(key) && value.hasCompositeValue()) {
                builder.setFixVersionsNames(this.extractStringListFromFieldValue(value));
                continue;
            }
            if ("issuetype".equals(key)) {
                builder.setIssueTypeId((long)Long.valueOf(value.getId()));
                continue;
            }
            if ("priority".equals(key)) {
                builder.setPriorityId((long)Long.valueOf(value.getId()));
                continue;
            }
            if ("project".equals(key) && value.hasScalarValue()) {
                builder.setProjectKey(value.getScalar());
                continue;
            }
            if ("reporter".equals(key) && value.hasScalarValue()) {
                builder.setReporterName(value.getScalar());
                continue;
            }
            if ("summary".equals(key) && value.hasScalarValue()) {
                builder.setSummary(value.getScalar());
                continue;
            }
            if ("timetracking".equals(key)) {
                if (!this.hasTimetrackerValue(value)) continue;
                builder.setFieldInput(new FieldInput("timetracking", (Object)new ComplexIssueInputFieldValue(this.createMapForTimetracker(value))));
                continue;
            }
            if ("labels".equals(key) && value.hasCompositeValue()) {
                builder.setFieldInput(new FieldInput("labels", this.extractStringListFromFieldValue(value)));
                continue;
            }
            if ("environment".equals(key) && value.hasScalarValue()) {
                builder.setFieldInput(new FieldInput("environment", (Object)value.getScalar()));
                continue;
            }
            if ("security".equals(key) && value.hasScalarValue()) {
                builder.setFieldInput(new FieldInput("security", (Object)ComplexIssueInputFieldValue.with("name", value.getScalar())));
                continue;
            }
            if ("project".equals(value.getTypename()) && value.hasScalarValue()) {
                builder.setFieldInput(new FieldInput(key, (Object)ComplexIssueInputFieldValue.with("key", value.getId())));
                continue;
            }
            if ("version".equals(value.getTypename()) && value.hasScalarValue()) {
                map = this.mapScalarValueToValueOrNameAttribute(value);
                builder.setFieldInput(new FieldInput(key, (Object)new ComplexIssueInputFieldValue(map)));
                continue;
            }
            if ("date".equals(value.getTypename()) && value.hasScalarValue()) {
                builder.setFieldInput(new FieldInput(key, (Object)value.getScalar()));
                continue;
            }
            if ("datetime".equals(value.getTypename()) && value.hasScalarValue()) {
                builder.setFieldInput(new FieldInput(key, (Object)this.convertDateToISOFormat(value)));
                continue;
            }
            if ("user".equals(value.getTypename()) && value.hasScalarValue()) {
                map = this.mapScalarValueToNameAttribute(value);
                builder.setFieldInput(new FieldInput(key, (Object)new ComplexIssueInputFieldValue(map)));
                continue;
            }
            if ("group".equals(value.getTypename()) && value.hasScalarValue()) {
                map = this.mapScalarValueToNameAttribute(value);
                builder.setFieldInput(new FieldInput(key, (Object)new ComplexIssueInputFieldValue(map)));
                continue;
            }
            if ("user-array".equals(value.getTypename()) && value.hasScalarValue()) {
                builder.setFieldInput(new FieldInput(key, this.mapScalarValueToNameAttributeInAList(value)));
                continue;
            }
            if ("group-array".equals(value.getTypename()) && value.hasScalarValue()) {
                builder.setFieldInput(new FieldInput(key, this.mapScalarValueToNameAttributeInAList(value)));
                continue;
            }
            if ("version-array".equals(value.getTypename()) && value.hasScalarValue()) {
                builder.setFieldInput(new FieldInput(key, this.mapScalarValueToNameAttributeInAList(value)));
                continue;
            }
            if ("number".equals(value.getTypename()) && value.hasScalarValue()) {
                try {
                    builder.setFieldInput(new FieldInput(key, (Object)Double.parseDouble(value.getScalar())));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new NumberConversionException(value.getScalar());
                }
            }
            if ("string-array".equals(value.getTypename()) && value.hasScalarValue()) {
                builder.setFieldInput(new FieldInput(key, this.mapScalarValueToStringList(value)));
                continue;
            }
            if ("multi_select".equals(value.getTypename()) && value.hasCompositeValue()) {
                builder.setFieldInput(new FieldInput(key, this.mapCompositeValueToValueAttributeList(value)));
                continue;
            }
            if ("option-array".equals(value.getTypename())) {
                if (value.hasCompositeValue()) {
                    builder.setFieldInput(new FieldInput(key, this.mapCompositeValueToValueAttributeList(value)));
                    continue;
                }
                builder.setFieldInput(new FieldInput(key, this.mapScalarValueToValueAttributeList(value)));
                continue;
            }
            if ("checkbox_list".equals(value.getTypename()) && value.hasScalarValue()) {
                builder.setFieldInput(new FieldInput(key, this.mapScalarValueToValueAttributeList(value)));
                continue;
            }
            if (("cascading_select".equals(value.getTypename()) || "option-with-child".equals(value.getTypename())) && value.hasScalarValue()) {
                builder.setFieldInput(new FieldInput(key, (Object)this.mapScalarValueToAttributeHierarchy(value)));
                continue;
            }
            if ("composite".equals(value.getTypename()) && value.hasCompositeValue()) {
                builder.setFieldInput(new FieldInput(key, this.mapCompositeValue(value)));
                continue;
            }
            if ("select_option".equals(value.getTypename()) && value.hasScalarValue()) {
                map = this.mapScalarValueToIdAttribute(value);
                builder.setFieldInput(new FieldInput(key, (Object)new ComplexIssueInputFieldValue(map)));
                continue;
            }
            if ("issuelink".equals(value.getTypename()) && value.hasScalarValue()) {
                builder.setFieldValue(key, ComplexIssueInputFieldValue.with("key", value.getScalar()));
                continue;
            }
            if ("string".equals(value.getTypename()) && value.hasScalarValue()) {
                builder.setFieldInput(new FieldInput(key, (Object)value.getScalar()));
                continue;
            }
            if ("text_field".equals(value.getTypename()) && value.hasScalarValue()) {
                builder.setFieldInput(new FieldInput(key, (Object)value.getScalar()));
                continue;
            }
            if ("dropdown_list".equals(value.getTypename()) && value.hasScalarValue()) {
                builder.setFieldInput(new FieldInput(key, this.castAsId(value.getId())));
                continue;
            }
            if (!"any".equals(value.getTypename()) || (input = this.createAnyInputOrNull(issue, key, value)) == null) continue;
            builder.setFieldInput(input);
        }
        return builder.build();
    }

    private Object castAsId(Object value) {
        if (value == null) {
            return value;
        }
        String strVal = value.toString();
        try {
            Long id = Long.valueOf(strVal);
            if (id.equals(EntityMapping.NULL_ID)) {
                id = null;
            }
            return id;
        }
        catch (NumberFormatException numberFormatException) {
            return strVal;
        }
    }

    private Matcher getMatcher(String sourceText, String regex) {
        Pattern p = Pattern.compile(regex, 8);
        Matcher m = p.matcher(sourceText);
        m.find();
        return m;
    }

    private String convertDateToISOFormat(FieldValue value) {
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm");
        DateTime dt = formatter.parseDateTime(value.getScalar());
        DateTimeFormatter fmt = ISODateTimeFormat.dateTime();
        String date = fmt.print((ReadableInstant)dt);
        String first = date.substring(0, date.lastIndexOf(":"));
        String second = date.substring(date.lastIndexOf(":") + 1);
        return first + second;
    }

    private Object mapCompositeValue(FieldValue value) {
        ArrayList<ComplexIssueInputFieldValue> result = null;
        if ("version".equals(value.getComposite()[0].getTypename())) {
            ArrayList<ComplexIssueInputFieldValue> valueList = new ArrayList<ComplexIssueInputFieldValue>();
            FieldValue[] fieldValueArray = value.getComposite();
            int n = fieldValueArray.length;
            int n2 = 0;
            while (n2 < n) {
                FieldValue element = fieldValueArray[n2];
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("name", element.getScalar());
                valueList.add(new ComplexIssueInputFieldValue(map));
                ++n2;
            }
            result = valueList;
        } else {
            ArrayList<String> valueList = new ArrayList<String>();
            FieldValue[] fieldValueArray = value.getComposite();
            int n = fieldValueArray.length;
            int n3 = 0;
            while (n3 < n) {
                FieldValue element = fieldValueArray[n3];
                valueList.add(element.getScalar());
                result = valueList;
                ++n3;
            }
        }
        return result;
    }

    private Map<String, Object> createMapForTimetracker(FieldValue value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        FieldValue[] fieldValueArray = value.getComposite();
        int n = fieldValueArray.length;
        int n2 = 0;
        while (n2 < n) {
            FieldValue estimate = fieldValueArray[n2];
            map.put(estimate.getId(), estimate.getScalar());
            ++n2;
        }
        return map;
    }

    private List<String> mapScalarValueToStringList(FieldValue value) {
        ArrayList<String> valueList = new ArrayList<String>();
        String[] values = value.getScalar().split(",");
        int i = 0;
        while (i < values.length) {
            String valueName = values[i].trim();
            if (!valueName.equals("")) {
                valueList.add(valueName);
            }
            ++i;
        }
        return valueList;
    }

    private List<ComplexIssueInputFieldValue> mapCompositeValueToValueAttributeList(FieldValue value) {
        ArrayList<ComplexIssueInputFieldValue> valueList = new ArrayList<ComplexIssueInputFieldValue>();
        FieldValue[] selectedValues = value.getComposite();
        int i = 0;
        while (i < selectedValues.length) {
            FieldValue v = selectedValues[i];
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", v.getId());
            valueList.add(new ComplexIssueInputFieldValue(map));
            ++i;
        }
        return valueList;
    }

    private List<ComplexIssueInputFieldValue> mapScalarValueToValueAttributeList(FieldValue value) {
        ArrayList<ComplexIssueInputFieldValue> valueList = new ArrayList<ComplexIssueInputFieldValue>();
        String[] values = value.getScalar().split(",");
        int i = 0;
        while (i < values.length) {
            String valueName = values[i].trim();
            if (!valueName.equals("")) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("value", valueName);
                valueList.add(new ComplexIssueInputFieldValue(map));
            }
            ++i;
        }
        return valueList;
    }

    private ComplexIssueInputFieldValue mapScalarValueToAttributeHierarchy(FieldValue value) {
        String[] values = value.getScalar().split(",");
        ArrayList<String> valueList = new ArrayList<String>();
        int i = 0;
        while (i < values.length) {
            String valueName = values[i].trim();
            if (!valueName.equals("")) {
                valueList.add(valueName);
            }
            ++i;
        }
        return this.buildHierarchy(valueList, 0);
    }

    private ComplexIssueInputFieldValue buildHierarchy(List<String> valueList, int currentIndex) {
        HashMap<String, Object> element = new HashMap<String, Object>();
        if (currentIndex == valueList.size() - 1) {
            element.put("value", valueList.get(currentIndex));
        } else {
            element.put("value", valueList.get(currentIndex));
            element.put("child", this.buildHierarchy(valueList, currentIndex + 1));
        }
        return new ComplexIssueInputFieldValue(element);
    }

    private List<ComplexIssueInputFieldValue> mapScalarValueToNameAttributeInAList(FieldValue value) {
        ArrayList<ComplexIssueInputFieldValue> valueList = new ArrayList<ComplexIssueInputFieldValue>();
        String[] values = value.getScalar().split(",");
        int i = 0;
        while (i < values.length) {
            String valueName = values[i].trim();
            if (!valueName.equals("")) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("name", valueName);
                valueList.add(new ComplexIssueInputFieldValue(map));
            }
            ++i;
        }
        return valueList;
    }

    private Map<String, Object> mapScalarValueToValueOrNameAttribute(FieldValue value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (value.getId().equals("-1")) {
            map.put("value", value.getId());
        } else {
            map.put("name", value.getScalar());
        }
        return map;
    }

    private Map<String, Object> mapScalarValueToIdAttribute(FieldValue value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", value.getId());
        return map;
    }

    private Map<String, Object> mapScalarValueToNameAttribute(FieldValue value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", value.getScalar());
        return map;
    }

    Collection<AttachmentInput> convertToJiraAttachments(Collection<Attachment> sqAttachments) {
        ArrayList<AttachmentInput> jiraAttachments = new ArrayList<AttachmentInput>(sqAttachments.size());
        for (Attachment attach : sqAttachments) {
            AttachmentInput input = new AttachmentInput(attach.getName(), attach.getStreamContent());
            jiraAttachments.add(input);
        }
        return jiraAttachments;
    }

    private List<String> extractStringListFromFieldValue(FieldValue value) {
        ArrayList<String> stringList = new ArrayList<String>();
        int i = 0;
        while (i < value.getComposite().length) {
            stringList.add(value.getComposite()[i].getScalar());
            ++i;
        }
        return stringList;
    }

    Version convert2Version(FieldValue value) {
        return null;
    }

    BasicUser convert2BasicUser(FieldValue value) {
        return null;
    }

    private boolean hasTimetrackerValue(FieldValue value) {
        FieldValue[] fieldValueArray = value.getComposite();
        int n = fieldValueArray.length;
        int n2 = 0;
        while (n2 < n) {
            FieldValue subvalue = fieldValueArray[n2];
            if (!StringUtils.isBlank((String)subvalue.getScalar())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private FieldInput createAnyInputOrNull(AdvancedIssue issue, String key, FieldValue value) {
        String currentScheme = issue.getCurrentScheme();
        Field theField = null;
        for (Field f : issue.getProject().getFieldScheme(currentScheme)) {
            if (!f.getId().equals(key)) continue;
            theField = f;
            break;
        }
        if (theField == null) {
            throw new BugTrackerLocalException("could not locate field with id '" + key + "' in scheme '" + issue.getCurrentScheme() + "'", null);
        }
        String original = theField.getRendering().getInputType().getOriginal();
        FieldInput input = null;
        if (original.equals(InputType.formatName((String)"com.pyxis.greenhopper.jira:gh-epic-link"))) {
            String scalval = value.getScalar();
            if (!StringUtils.isBlank((String)scalval)) {
                input = new FieldInput(key, (Object)value.getScalar());
            }
        } else {
            LOGGER.info("could not process value of type 'any', for field id '" + key + "'");
        }
        return input;
    }
}

