/*
 * Decompiled with CFR 0.152.
 */
package xsquash4gitlab.okio;

import java.io.IOException;
import javax.crypto.Cipher;
import xsquash4gitlab.kotlin.Metadata;
import xsquash4gitlab.kotlin.jvm.internal.Intrinsics;
import xsquash4gitlab.okio.-Util;
import xsquash4gitlab.okio.Buffer;
import xsquash4gitlab.okio.BufferedSink;
import xsquash4gitlab.okio.Segment;
import xsquash4gitlab.okio.SegmentPool;
import xsquash4gitlab.okio.Sink;
import xsquash4gitlab.okio.Timeout;
import xsquash4gitlab.org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0018H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lxsquash4gitlab/okio/CipherSink;", "Lxsquash4gitlab/okio/Sink;", "sink", "Lxsquash4gitlab/okio/BufferedSink;", "cipher", "Ljavax/crypto/Cipher;", "(Lokio/BufferedSink;Ljavax/crypto/Cipher;)V", "blockSize", "", "getCipher", "()Ljavax/crypto/Cipher;", "closed", "", "close", "", "doFinal", "", "flush", "timeout", "Lxsquash4gitlab/okio/Timeout;", "update", "source", "Lxsquash4gitlab/okio/Buffer;", "remaining", "", "write", "byteCount", "xsquash4gitlab.okio"})
public final class CipherSink
implements Sink {
    private final int blockSize;
    private boolean closed;
    private final BufferedSink sink;
    @NotNull
    private final Cipher cipher;

    @Override
    public void write(@NotNull Buffer source2, long byteCount) throws IOException {
        int size;
        Intrinsics.checkNotNullParameter(source2, "source");
        -Util.checkOffsetAndCount(source2.size(), 0L, byteCount);
        boolean bl = !this.closed;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "closed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        for (long remaining = byteCount; remaining > 0L; remaining -= (long)size) {
            size = this.update(source2, remaining);
        }
    }

    private final int update(Buffer source2, long remaining) {
        Segment segment = source2.head;
        Intrinsics.checkNotNull(segment);
        Segment head = segment;
        int b$iv = head.limit - head.pos;
        boolean $i$f$minOf = false;
        long l = b$iv;
        boolean bl = false;
        int size = (int)Math.min(remaining, l);
        Buffer buffer = this.sink.getBuffer();
        Segment s = buffer.writableSegment$okio(size);
        int ciphered = this.cipher.update(head.data, head.pos, size, s.data, s.limit);
        s.limit += ciphered;
        Buffer buffer2 = buffer;
        buffer2.setSize$okio(buffer2.size() + (long)ciphered);
        if (s.pos == s.limit) {
            buffer.head = s.pop();
            SegmentPool.recycle(s);
        }
        Buffer buffer3 = source2;
        buffer3.setSize$okio(buffer3.size() - (long)size);
        head.pos += size;
        if (head.pos == head.limit) {
            source2.head = head.pop();
            SegmentPool.recycle(head);
        }
        return size;
    }

    @Override
    public void flush() {
        this.sink.flush();
    }

    @Override
    @NotNull
    public Timeout timeout() {
        return this.sink.timeout();
    }

    @Override
    public void close() throws IOException {
        Throwable thrown;
        block4: {
            if (this.closed) {
                return;
            }
            this.closed = true;
            thrown = this.doFinal();
            try {
                this.sink.close();
            }
            catch (Throwable e) {
                if (thrown != null) break block4;
                thrown = e;
            }
        }
        if (thrown != null) {
            throw thrown;
        }
    }

    private final Throwable doFinal() {
        int outputSize = this.cipher.getOutputSize(0);
        if (outputSize == 0) {
            return null;
        }
        Throwable thrown = null;
        Buffer buffer = this.sink.getBuffer();
        Segment s = buffer.writableSegment$okio(outputSize);
        try {
            int ciphered = this.cipher.doFinal(s.data, s.limit);
            s.limit += ciphered;
            Buffer buffer2 = buffer;
            buffer2.setSize$okio(buffer2.size() + (long)ciphered);
        }
        catch (Throwable e) {
            thrown = e;
        }
        if (s.pos == s.limit) {
            buffer.head = s.pop();
            SegmentPool.recycle(s);
        }
        return thrown;
    }

    @NotNull
    public final Cipher getCipher() {
        return this.cipher;
    }

    public CipherSink(@NotNull BufferedSink sink2, @NotNull Cipher cipher) {
        Intrinsics.checkNotNullParameter(sink2, "sink");
        Intrinsics.checkNotNullParameter(cipher, "cipher");
        this.sink = sink2;
        this.cipher = cipher;
        this.blockSize = this.cipher.getBlockSize();
        boolean bl = this.blockSize > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Block cipher required " + this.cipher;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.blockSize <= 8192;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Cipher block size " + this.blockSize + " too large " + this.cipher;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }
}

