/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.service;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabIssue;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabRemoteSelectType;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabRemoteSynchronisation;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.SyncedRequirementHierarchy;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.SynchronisationFilterValueId;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.type.MilestoneWildcardId;
import org.squashtest.tm.plugin.xsquash4gitlab.service.SyncedRequirementPathHelper;
import xsquash4gitlab.org.jetbrains.annotations.NotNull;

public final class RequirementHierarchyHelper {
    private static final List<String> MILESTONE_TIMESTAMP_RAW_VALUES = Arrays.asList(MilestoneWildcardId.STARTED.rawValue(), MilestoneWildcardId.UPCOMING.rawValue());

    private RequirementHierarchyHelper() {
        throw new IllegalStateException("This class is not meant to be instantiated");
    }

    public static boolean shouldMoveSyncedRequirement(@NotNull GitLabRemoteSynchronisation synchronisation, @NotNull String rootFolderPath, @NotNull String currentRequirementPath, boolean isGitLabIssueStillInPerimeter, @NotNull GitLabIssue gitLabIssue, boolean hasRemoteModifications) {
        if (!hasRemoteModifications) {
            return false;
        }
        if (!RequirementHierarchyHelper.isOrganisedByIterationMilestoneOrTree(synchronisation)) {
            return false;
        }
        if (!isGitLabIssueStillInPerimeter && !RequirementHierarchyHelper.isRestrictedToTimestampedMilestone(synchronisation)) {
            return false;
        }
        boolean isRequirementDescendantOfRootFolder = currentRequirementPath.contains(rootFolderPath);
        if (!isRequirementDescendantOfRootFolder) {
            return false;
        }
        String groupFolderPath = SyncedRequirementPathHelper.buildGroupFolderPath(synchronisation, gitLabIssue, rootFolderPath);
        if (RequirementHierarchyHelper.isOrganisedByIteration(synchronisation) && RequirementHierarchyHelper.issueHasNoIterationAndCurrentGroupFolderPathIsNotRootFolder(gitLabIssue, currentRequirementPath, rootFolderPath)) {
            return true;
        }
        if (RequirementHierarchyHelper.isOrganisedByMilestone(synchronisation) && RequirementHierarchyHelper.issueHasNoMilestoneAndCurrentGroupFolderPathIsNotRootFolder(gitLabIssue, currentRequirementPath, rootFolderPath)) {
            return true;
        }
        if (RequirementHierarchyHelper.isOrganisedByIterationOrMilestone(synchronisation) && RequirementHierarchyHelper.currentRequirementPathContainsGroupFolderPath(currentRequirementPath, groupFolderPath)) {
            return false;
        }
        return !RequirementHierarchyHelper.isRequirementDescendantOfTargetGroupFolder(currentRequirementPath, groupFolderPath);
    }

    private static boolean isOrganisedByIterationMilestoneOrTree(@NotNull GitLabRemoteSynchronisation synchronisation) {
        return Arrays.asList(SyncedRequirementHierarchy.ITERATION, SyncedRequirementHierarchy.MILESTONE, SyncedRequirementHierarchy.TREE).contains((Object)synchronisation.getSyncedRequirementHierarchy());
    }

    private static boolean isOrganisedByIterationOrMilestone(@NotNull GitLabRemoteSynchronisation synchronisation) {
        return Arrays.asList(SyncedRequirementHierarchy.ITERATION, SyncedRequirementHierarchy.MILESTONE).contains((Object)synchronisation.getSyncedRequirementHierarchy());
    }

    private static boolean isOrganisedByIteration(@NotNull GitLabRemoteSynchronisation synchronisation) {
        return SyncedRequirementHierarchy.ITERATION.equals((Object)synchronisation.getSyncedRequirementHierarchy());
    }

    private static boolean isOrganisedByMilestone(@NotNull GitLabRemoteSynchronisation synchronisation) {
        return SyncedRequirementHierarchy.MILESTONE.equals((Object)synchronisation.getSyncedRequirementHierarchy());
    }

    private static boolean issueHasNoMilestoneAndCurrentGroupFolderPathIsNotRootFolder(GitLabIssue issue, String currentRequirementPath, String rootFolderPath) {
        return Objects.isNull(issue.getMilestone()) && RequirementHierarchyHelper.currentGroupFolderPathIsNotRootFolder(currentRequirementPath, rootFolderPath);
    }

    private static boolean issueHasNoIterationAndCurrentGroupFolderPathIsNotRootFolder(GitLabIssue issue, String currentRequirementPath, String rootFolderPath) {
        return Objects.isNull(issue.getIteration()) && RequirementHierarchyHelper.currentGroupFolderPathIsNotRootFolder(currentRequirementPath, rootFolderPath);
    }

    private static boolean currentGroupFolderPathIsNotRootFolder(String currentRequirementPath, String rootFolderPath) {
        String[] currentRequirementPathArray = currentRequirementPath.split("/");
        CharSequence[] currentGroupFolderPathArray = Arrays.copyOf(currentRequirementPathArray, currentRequirementPathArray.length - 1);
        String currentGroupFolderPath = String.join((CharSequence)"/", currentGroupFolderPathArray);
        return !rootFolderPath.equals(currentGroupFolderPath);
    }

    private static boolean currentRequirementPathContainsGroupFolderPath(String currentRequirementPath, String groupFolderPath) {
        String[] currentRequirementPathArray = currentRequirementPath.split("/");
        String[] groupFolderPathArray = groupFolderPath.split("/");
        HashSet<String> currentRequirementPathValues = new HashSet<String>(Arrays.asList(currentRequirementPathArray));
        HashSet<String> groupFolderPathValues = new HashSet<String>(Arrays.asList(groupFolderPathArray));
        return currentRequirementPathValues.containsAll(groupFolderPathValues);
    }

    private static boolean isRequirementDescendantOfTargetGroupFolder(String currentRequirementPath, String groupFolderPath) {
        String[] currentRequirementPathArray = currentRequirementPath.split("/");
        Object[] groupFolderPathArray = groupFolderPath.split("/");
        Object[] currentGroupFolderPathArray = Arrays.copyOf(currentRequirementPathArray, groupFolderPathArray.length);
        return Arrays.equals(groupFolderPathArray, currentGroupFolderPathArray);
    }

    private static boolean isRestrictedToTimestampedMilestone(GitLabRemoteSynchronisation synchronisation) {
        return GitLabRemoteSelectType.ISSUE.name().equals(synchronisation.getRemoteSynchronisation().getSelectType()) && SyncedRequirementHierarchy.MILESTONE.equals((Object)synchronisation.getSyncedRequirementHierarchy()) && synchronisation.getFilterValues().stream().filter(fv -> SynchronisationFilterValueId.MILESTONE.name().equals(fv.getId())).anyMatch(fv -> fv.getStringValues().stream().anyMatch(MILESTONE_TIMESTAMP_RAW_VALUES::contains));
    }
}

