/*
 * Decompiled with CFR 0.152.
 */
package bugzilla.org.apache.xmlrpc.parser;

import bugzilla.org.apache.ws.commons.util.NamespaceContextImpl;
import bugzilla.org.apache.xmlrpc.common.TypeFactory;
import bugzilla.org.apache.xmlrpc.common.XmlRpcStreamConfig;
import bugzilla.org.apache.xmlrpc.parser.RecursiveTypeParserImpl;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class MapParser
extends RecursiveTypeParserImpl {
    private int level = 0;
    private StringBuffer nameBuffer = new StringBuffer();
    private Object nameObject;
    private Map map;
    private boolean inName;
    private boolean inValue;
    private boolean doneValue;

    public MapParser(XmlRpcStreamConfig pConfig, NamespaceContextImpl pContext, TypeFactory pFactory) {
        super(pConfig, pContext, pFactory);
    }

    protected void addResult(Object pResult) throws SAXException {
        if (this.inName) {
            this.nameObject = pResult;
        } else {
            if (this.nameObject == null) {
                throw new SAXParseException("Invalid state: Expected name", this.getDocumentLocator());
            }
            if (this.map.containsKey(this.nameObject)) {
                throw new SAXParseException("Duplicate name: " + this.nameObject, this.getDocumentLocator());
            }
            this.map.put(this.nameObject, pResult);
        }
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        this.level = 0;
        this.map = new HashMap();
        this.inName = false;
        this.inValue = false;
    }

    public void characters(char[] pChars, int pOffset, int pLength) throws SAXException {
        if (this.inName && !this.inValue) {
            this.nameBuffer.append(pChars, pOffset, pLength);
        } else {
            super.characters(pChars, pOffset, pLength);
        }
    }

    public void ignorableWhitespace(char[] pChars, int pOffset, int pLength) throws SAXException {
        if (this.inName) {
            this.characters(pChars, pOffset, pLength);
        } else {
            super.ignorableWhitespace(pChars, pOffset, pLength);
        }
    }

    public void startElement(String pURI, String pLocalName, String pQName, Attributes pAttrs) throws SAXException {
        switch (this.level++) {
            case 0: {
                if ("".equals(pURI) && "struct".equals(pLocalName)) break;
                throw new SAXParseException("Expected struct, got " + new QName(pURI, pLocalName), this.getDocumentLocator());
            }
            case 1: {
                if (!"".equals(pURI) || !"member".equals(pLocalName)) {
                    throw new SAXParseException("Expected member, got " + new QName(pURI, pLocalName), this.getDocumentLocator());
                }
                this.inValue = false;
                this.inName = false;
                this.doneValue = false;
                this.nameObject = null;
                this.nameBuffer.setLength(0);
                break;
            }
            case 2: {
                if (this.doneValue) {
                    throw new SAXParseException("Expected /member, got " + new QName(pURI, pLocalName), this.getDocumentLocator());
                }
                if ("".equals(pURI) && "name".equals(pLocalName)) {
                    if (this.nameObject == null) {
                        this.inName = true;
                        break;
                    }
                    throw new SAXParseException("Expected value, got " + new QName(pURI, pLocalName), this.getDocumentLocator());
                }
                if (!"".equals(pURI) || !"value".equals(pLocalName)) break;
                if (this.nameObject == null) {
                    throw new SAXParseException("Expected name, got " + new QName(pURI, pLocalName), this.getDocumentLocator());
                }
                this.inValue = true;
                this.startValueTag();
                break;
            }
            case 3: {
                if (this.inName && "".equals(pURI) && "value".equals(pLocalName)) {
                    if (this.cfg.isEnabledForExtensions()) {
                        this.inValue = true;
                        this.startValueTag();
                        break;
                    }
                    throw new SAXParseException("Expected /name, got " + new QName(pURI, pLocalName), this.getDocumentLocator());
                }
                super.startElement(pURI, pLocalName, pQName, pAttrs);
                break;
            }
            default: {
                super.startElement(pURI, pLocalName, pQName, pAttrs);
            }
        }
    }

    public void endElement(String pURI, String pLocalName, String pQName) throws SAXException {
        switch (--this.level) {
            case 0: {
                this.setResult(this.map);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (this.inName) {
                    this.inName = false;
                    if (this.nameObject == null) {
                        this.nameObject = this.nameBuffer.toString();
                        break;
                    }
                    for (int i = 0; i < this.nameBuffer.length(); ++i) {
                        if (Character.isWhitespace(this.nameBuffer.charAt(i))) continue;
                        throw new SAXParseException("Unexpected non-whitespace character in member name", this.getDocumentLocator());
                    }
                    break;
                }
                if (!this.inValue) break;
                this.endValueTag();
                this.doneValue = true;
                break;
            }
            case 3: {
                if (this.inName && this.inValue && "".equals(pURI) && "value".equals(pLocalName)) {
                    this.endValueTag();
                    break;
                }
                super.endElement(pURI, pLocalName, pQName);
                break;
            }
            default: {
                super.endElement(pURI, pLocalName, pQName);
            }
        }
    }
}

