/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.tuleap.internal.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.domain.TuleapField;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.domain.TuleapWorkflow;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TuleapTracker {
    @JsonProperty
    private Long id;
    @JsonProperty
    private String label;
    @JsonProperty
    private List<TuleapField> fields = new ArrayList<TuleapField>();
    @JsonProperty
    private TuleapWorkflow workflow;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public List<TuleapField> getFields() {
        return this.fields;
    }

    public void setFields(List<TuleapField> fields) {
        this.fields = fields;
    }

    public TuleapWorkflow getWorkflow() {
        return this.workflow;
    }

    public void setWorkflow(TuleapWorkflow workflow) {
        this.workflow = workflow;
    }

    public TuleapField findFieldByName(String name) {
        return this.fields.stream().filter(tuleapField -> tuleapField.getName().equals(name)).findFirst().orElse(new TuleapField());
    }

    public TuleapField findFirstAttachmentField() {
        return this.fields.stream().filter(tuleapField -> tuleapField.getType().equals("file")).findFirst().orElseThrow(() -> new IllegalArgumentException("Programmatic error. There is no attachment field in tracker : " + this.getLabel()));
    }

    public boolean isWorkflowField(TuleapField tuleapField) {
        return this.workflow != null && tuleapField.getId().equals(this.workflow.getFieldId());
    }

    public List<Long> findValidInitialStatusIds() {
        return this.workflow.findValidInitialStatusIds();
    }
}

