/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.tuleap.internal.converters;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedIssue;
import org.squashtest.tm.bugtracker.advanceddomain.FieldValue;
import org.squashtest.tm.bugtracker.definition.Attachment;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.ExceptionHandler;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.domain.TuleapArtifact;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.domain.TuleapArtifactValue;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.domain.TuleapField;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.domain.TuleapFile;
import org.squashtest.tm.plugin.bugtracker.tuleap.internal.domain.TuleapTracker;

@Component
public class SquashToTuleapConverter {
    public static final int CHUNK_SIZE = 0x100000;
    @Inject
    @Named(value="tuleapExceptionHandler")
    private ExceptionHandler exceptionHandler;

    public TuleapArtifact convertAdvancedIssue(AdvancedIssue squashIssue, TuleapTracker tuleapTracker) {
        TuleapArtifact tuleapArtifact = new TuleapArtifact();
        tuleapArtifact.setTracker(tuleapTracker);
        squashIssue.getFieldValues().forEach((fieldIdentifier, fieldValue) -> {
            if (!fieldIdentifier.equals("trackername")) {
                TuleapField trackerField = tuleapTracker.getFields().stream().filter(tuleapField -> tuleapField.getLabel().equals(fieldIdentifier)).findFirst().orElseThrow(() -> new RuntimeException("Unable to find a matching field in tracker fields. id = " + fieldValue.getId()));
                TuleapArtifactValue tuleapArtifactValue = this.convertFieldValue(trackerField.getId(), (FieldValue)fieldValue, trackerField);
                tuleapArtifact.addValue(tuleapArtifactValue);
            }
        });
        return tuleapArtifact;
    }

    public TuleapArtifactValue convertFieldValue(Long fieldId, FieldValue squashFieldValue, TuleapField trackerField) {
        String fieldType;
        TuleapArtifactValue artifactValue = new TuleapArtifactValue();
        artifactValue.setFieldId(fieldId);
        String scalarValue = squashFieldValue.getScalar();
        String idValue = squashFieldValue.getId();
        FieldValue[] composite = squashFieldValue.getComposite();
        switch (fieldType = trackerField.getType()) {
            case "string": 
            case "date": 
            case "text": {
                artifactValue.setValue(scalarValue);
                break;
            }
            case "rb": 
            case "sb": {
                if (!StringUtils.isNotBlank((CharSequence)idValue) || !StringUtils.isNumeric((CharSequence)idValue)) break;
                artifactValue.addBindValueId(Long.parseLong(idValue));
                break;
            }
            case "cb": 
            case "msb": {
                this.handleMultiValueIdField(artifactValue, composite);
                break;
            }
            case "tbl": {
                this.handleMultiValueStringField(artifactValue, composite);
                break;
            }
            case "int": {
                this.handleIntegerValue(artifactValue, scalarValue);
                break;
            }
            case "float": {
                this.handleFloatValue(artifactValue, scalarValue);
            }
        }
        return artifactValue;
    }

    private void handleIntegerValue(TuleapArtifactValue artifactValue, String scalarValue) {
        if (StringUtils.isNotBlank((CharSequence)scalarValue)) {
            try {
                Integer.parseInt(scalarValue);
            }
            catch (NumberFormatException e) {
                throw this.exceptionHandler.numberConversionFailure(e, scalarValue);
            }
        }
        artifactValue.setValue(scalarValue);
    }

    private void handleFloatValue(TuleapArtifactValue artifactValue, String scalarValue) {
        if (StringUtils.isNotBlank((CharSequence)scalarValue)) {
            try {
                Float.parseFloat(scalarValue);
            }
            catch (NumberFormatException e) {
                throw this.exceptionHandler.numberConversionFailure(e, scalarValue);
            }
        }
        artifactValue.setValue(scalarValue);
    }

    private void handleMultiValueIdField(TuleapArtifactValue artifactValue, FieldValue[] composite) {
        FieldValue[] fieldValueArray = composite;
        int n = composite.length;
        int n2 = 0;
        while (n2 < n) {
            FieldValue fieldValue = fieldValueArray[n2];
            artifactValue.addBindValueId(Long.parseLong(fieldValue.getId()));
            ++n2;
        }
    }

    private void handleMultiValueStringField(TuleapArtifactValue artifactValue, FieldValue[] composite) {
        FieldValue[] fieldValueArray = composite;
        int n = composite.length;
        int n2 = 0;
        while (n2 < n) {
            FieldValue fieldValue = fieldValueArray[n2];
            artifactValue.addBindValueId(fieldValue.getScalar());
            ++n2;
        }
    }

    public TuleapFile convertFile(Attachment attachment) {
        TuleapFile tuleapFile = new TuleapFile();
        tuleapFile.setName(attachment.getName());
        tuleapFile.setDescription(attachment.getName());
        byte[] buffer = new byte[0x100000];
        int read = 0;
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (InputStream inputStream = attachment.getStreamContent();){
                while ((read = inputStream.read(buffer)) > 0) {
                    String base64Chunk;
                    if (read < 0x100000) {
                        byte[] truncatedBuffer = new byte[read];
                        System.arraycopy(buffer, 0, truncatedBuffer, 0, read);
                        base64Chunk = Base64.getEncoder().withoutPadding().encodeToString(truncatedBuffer);
                    } else {
                        base64Chunk = Base64.getEncoder().withoutPadding().encodeToString(buffer);
                    }
                    tuleapFile.addBase64chunk(base64Chunk);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BugTrackerRemoteException((Throwable)e);
        }
        List<String> base64chunks = tuleapFile.getBase64chunks();
        tuleapFile.setContent(base64chunks.get(0));
        base64chunks.remove(0);
        return tuleapFile;
    }
}

