/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.tuleap.internal;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;

@Component(value="tuleapExceptionHandler")
public class ExceptionHandler {
    @Inject
    @Named(value="tuleapConnectorMessageSource")
    private MessageSource messageSource;

    public BugTrackerRemoteException genericError(Exception ex) {
        String translation = this.messageSource.getMessage("exception.squash.unknownexception", null, LocaleContextHolder.getLocale());
        return new BugTrackerRemoteException(translation + ex.getMessage(), ex.getCause());
    }

    public BugTrackerRemoteException projectNotFound(String projectId) {
        String translation = this.messageSource.getMessage("exception.squash.notfound.project", new Object[]{projectId}, LocaleContextHolder.getLocale());
        return new BugTrackerRemoteException(translation, null);
    }

    public BugTrackerRemoteException numberConversionFailure(NumberFormatException exception, String value) {
        String translation = this.messageSource.getMessage("exception.squash.number.conversion", new Object[]{value}, LocaleContextHolder.getLocale());
        return new BugTrackerRemoteException(translation, null);
    }

    public BugTrackerRemoteException emptyCredentials() {
        String translation = this.messageSource.getMessage("exception.squash.accessdenied", new Object[0], LocaleContextHolder.getLocale());
        return new BugTrackerRemoteException(translation, null);
    }

    public BugTrackerRemoteException noTrackerConfigured() {
        String translation = this.messageSource.getMessage("exception.squash.notrackerconfigured", new Object[0], LocaleContextHolder.getLocale());
        return new BugTrackerRemoteException(translation, null);
    }

    public static interface SquashMessageKeys {
        public static final String MANDATORY_SUMMARY_REQUIRED = "exception.squash.validation.mandatory.summary";
        public static final String UNKNOWN_EXCEPTION = "exception.squash.unknownexception";
        public static final String WRONG_CREDENTIALS = "exception.squash.accessdenied";
        public static final String INVALID_TOKEN = "exception.squash.invalidtoken";
        public static final String OPERATION_DENIED = "exception.squash.operationdenied";
        public static final String ISSUE_NOT_FOUND = "exception.squash.notfound.issue";
        public static final String PROJECT_NOT_FOUND = "exception.squash.notfound.project";
        public static final String NUMBER_CONVERSION = "exception.squash.number.conversion";
        public static final String USER_NOT_FOUND = "exception.squash.notfound.user";
        public static final String INVALID_URL = "exception.squash.invalidurl";
        public static final String INVALID_OPTION = "exception.squash.invalidoption";
        public static final String OPTION_NONE = "exception.squash.optionnone";
        public static final String CONFLICTING_CONFIGURATION = "exception.squash.conflict.config";
        public static final String NO_TRACKER_CONFIGURED = "exception.squash.notrackerconfigured";
    }
}

