/*
 * Decompiled with CFR 0.152.
 */
package workflowautomjira.com.atlassian.jira.rest.client.internal.json;

import org.joda.time.DateTime;
import workflowautomjira.com.atlassian.jira.rest.client.api.OptionalIterable;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.AuditAssociatedItem;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.AuditChangedValue;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.AuditRecord;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.AuditRecordsData;
import workflowautomjira.com.atlassian.jira.rest.client.internal.json.AuditAssociatedItemJsonParser;
import workflowautomjira.com.atlassian.jira.rest.client.internal.json.AuditChangedValueJsonParser;
import workflowautomjira.com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import workflowautomjira.com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import workflowautomjira.org.codehaus.jettison.json.JSONException;
import workflowautomjira.org.codehaus.jettison.json.JSONObject;

public class AuditRecordsJsonParser
implements JsonObjectParser<AuditRecordsData> {
    private final AuditAssociatedItemJsonParser associatedItemJsonParser = new AuditAssociatedItemJsonParser();
    private final AuditChangedValueJsonParser changedValueJsonParser = new AuditChangedValueJsonParser();
    private final SingleAuditRecordJsonParser singleAuditRecordJsonParser = new SingleAuditRecordJsonParser();

    @Override
    public AuditRecordsData parse(JSONObject json) throws JSONException {
        Integer offset = json.getInt("offset");
        Integer limit = json.getInt("limit");
        Integer total = json.getInt("total");
        OptionalIterable<AuditRecord> records = JsonParseUtil.parseOptionalJsonArray(json.optJSONArray("records"), this.singleAuditRecordJsonParser);
        return new AuditRecordsData(offset, limit, total, records);
    }

    class SingleAuditRecordJsonParser
    implements JsonObjectParser<AuditRecord> {
        SingleAuditRecordJsonParser() {
        }

        @Override
        public AuditRecord parse(JSONObject json) throws JSONException {
            Long id = json.getLong("id");
            String summary = json.getString("summary");
            String createdString = json.getString("created");
            DateTime created = JsonParseUtil.parseDateTime(json, "created");
            String category = json.getString("category");
            String eventSource = json.getString("eventSource");
            String authorKey = JsonParseUtil.getOptionalString(json, "authorKey");
            String remoteAddress = JsonParseUtil.getOptionalString(json, "remoteAddress");
            AuditAssociatedItem objectItem = JsonParseUtil.getOptionalJsonObject(json, "objectItem", AuditRecordsJsonParser.this.associatedItemJsonParser);
            OptionalIterable<AuditAssociatedItem> associatedItem = JsonParseUtil.parseOptionalJsonArray(json.optJSONArray("associatedItems"), AuditRecordsJsonParser.this.associatedItemJsonParser);
            OptionalIterable<AuditChangedValue> changedValues = JsonParseUtil.parseOptionalJsonArray(json.optJSONArray("changedValues"), AuditRecordsJsonParser.this.changedValueJsonParser);
            return new AuditRecord(id, summary, remoteAddress, created, category, eventSource, authorKey, objectItem, associatedItem, changedValues);
        }
    }
}

