/*
 * Decompiled with CFR 0.152.
 */
package workflowautomjira.com.atlassian.jira.rest.client.internal.async;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import workflowautomjira.com.atlassian.httpclient.api.HttpClient;
import workflowautomjira.com.atlassian.jira.rest.client.api.IssueRestClient;
import workflowautomjira.com.atlassian.jira.rest.client.api.RestClientException;
import workflowautomjira.com.atlassian.jira.rest.client.api.SearchRestClient;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.Filter;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.SearchResult;
import workflowautomjira.com.atlassian.jira.rest.client.internal.async.AbstractAsynchronousRestClient;
import workflowautomjira.com.atlassian.jira.rest.client.internal.json.FilterJsonParser;
import workflowautomjira.com.atlassian.jira.rest.client.internal.json.GenericJsonArrayParser;
import workflowautomjira.com.atlassian.jira.rest.client.internal.json.SearchResultJsonParser;
import workflowautomjira.io.atlassian.util.concurrent.Promise;
import workflowautomjira.javax.annotation.Nullable;
import workflowautomjira.javax.ws.rs.core.UriBuilder;
import workflowautomjira.org.codehaus.jettison.json.JSONException;
import workflowautomjira.org.codehaus.jettison.json.JSONObject;

public class AsynchronousSearchRestClient
extends AbstractAsynchronousRestClient
implements SearchRestClient {
    private static final Function<IssueRestClient.Expandos, String> EXPANDO_TO_PARAM = new Function<IssueRestClient.Expandos, String>(){

        public String apply(IssueRestClient.Expandos from) {
            return from.name().toLowerCase();
        }
    };
    private static final String MAX_RESULTS_ATTRIBUTE = "maxResults";
    private static final String NEXT_PAGE_TOKEN_ATTRIBUTE = "nextPageToken";
    private static final int MAX_JQL_LENGTH_FOR_HTTP_GET = 500;
    private static final String JQL_ATTRIBUTE = "jql";
    private static final String FILTER_FAVOURITE_PATH = "filter/favourite";
    private static final String FILTER_PATH_FORMAT = "filter/%s";
    private static final String SEARCH_URI_PREFIX = "search";
    private static final String SEARCH_CLOUD_URI_PREFIX = "search/jql";
    private static final String EXPAND_ATTRIBUTE = "expand";
    private static final String FIELDS_ATTRIBUTE = "fields";
    private final SearchResultJsonParser searchResultJsonParser = new SearchResultJsonParser();
    private final FilterJsonParser filterJsonParser = new FilterJsonParser();
    private final GenericJsonArrayParser<Filter> filtersParser = GenericJsonArrayParser.create(new FilterJsonParser());
    private final URI searchUri;
    private final URI searchCloudUri;
    private final URI favouriteUri;
    private final URI baseUri;

    public AsynchronousSearchRestClient(URI baseUri, HttpClient asyncHttpClient) {
        super(asyncHttpClient);
        this.baseUri = baseUri;
        this.searchUri = UriBuilder.fromUri(baseUri).path(SEARCH_URI_PREFIX).build(new Object[0]);
        this.searchCloudUri = UriBuilder.fromUri(baseUri).path(SEARCH_CLOUD_URI_PREFIX).build(new Object[0]);
        this.favouriteUri = UriBuilder.fromUri(baseUri).path(FILTER_FAVOURITE_PATH).build(new Object[0]);
    }

    @Override
    public Promise<SearchResult> searchJql(@Nullable String jql) {
        return this.searchJql(jql, null, null, null);
    }

    @Override
    public Promise<SearchResult> searchJqlCloud(@Nullable String jql) {
        return this.searchJqlCloud(jql, null, null, null);
    }

    @Override
    public Promise<SearchResult> searchJql(@Nullable String jql, @Nullable Integer maxResults, @Nullable Integer startAt, @Nullable Set<String> fields) {
        Iterable expandosValues = Iterables.transform((Iterable)ImmutableList.of((Object)((Object)IssueRestClient.Expandos.SCHEMA), (Object)((Object)IssueRestClient.Expandos.NAMES)), EXPANDO_TO_PARAM);
        String notNullJql = StringUtils.defaultString((String)jql);
        return notNullJql.length() > 500 ? this.searchJqlImplPost(maxResults, startAt, expandosValues, notNullJql, fields) : this.searchJqlImplGet(maxResults, startAt, expandosValues, notNullJql, fields);
    }

    private Promise<SearchResult> searchJqlImplGet(@Nullable Integer maxResults, @Nullable Integer startAt, Iterable<String> expandosValues, String jql, @Nullable Set<String> fields) {
        UriBuilder uriBuilder = UriBuilder.fromUri(this.searchUri).queryParam(JQL_ATTRIBUTE, jql).queryParam(EXPAND_ATTRIBUTE, Joiner.on((String)",").join(expandosValues));
        if (fields != null) {
            uriBuilder.queryParam(FIELDS_ATTRIBUTE, Joiner.on((String)",").join(fields));
        }
        this.addOptionalQueryParam(uriBuilder, MAX_RESULTS_ATTRIBUTE, maxResults);
        this.addOptionalQueryParam(uriBuilder, "startAt", startAt);
        return this.getAndParse(uriBuilder.build(new Object[0]), this.searchResultJsonParser);
    }

    private Promise<SearchResult> searchJqlImplPost(@Nullable Integer maxResults, @Nullable Integer startAt, Iterable<String> expandosValues, String jql, @Nullable Set<String> fields) {
        JSONObject postEntity = new JSONObject();
        try {
            postEntity.put(JQL_ATTRIBUTE, jql).put(EXPAND_ATTRIBUTE, (Collection)ImmutableList.copyOf(expandosValues)).putOpt("startAt", startAt).putOpt(MAX_RESULTS_ATTRIBUTE, maxResults);
            if (fields != null) {
                postEntity.put(FIELDS_ATTRIBUTE, fields);
            }
        }
        catch (JSONException e) {
            throw new RestClientException(e);
        }
        return this.postAndParse(this.searchUri, postEntity, this.searchResultJsonParser);
    }

    @Override
    public Promise<SearchResult> searchJqlCloud(@Nullable String jql, @Nullable Integer maxResults, @Nullable String nextPageToken, @Nullable Set<String> fields) {
        String expandosValues = IssueRestClient.Expandos.SCHEMA.getValue() + "," + IssueRestClient.Expandos.NAMES.getValue();
        String notNullJql = StringUtils.defaultString((String)jql);
        return notNullJql.length() > 500 ? this.searchJqlImplPost(maxResults, nextPageToken, expandosValues, notNullJql, fields) : this.searchJqlImplGet(maxResults, nextPageToken, expandosValues, notNullJql, fields);
    }

    private Promise<SearchResult> searchJqlImplGet(@Nullable Integer maxResults, @Nullable String nextPageToken, String expandosValues, String jql, @Nullable Set<String> fields) {
        UriBuilder uriBuilder = UriBuilder.fromUri(this.searchCloudUri).queryParam(JQL_ATTRIBUTE, jql).queryParam(EXPAND_ATTRIBUTE, expandosValues);
        if (fields != null) {
            uriBuilder.queryParam(FIELDS_ATTRIBUTE, Joiner.on((String)",").join(fields));
        }
        if (maxResults != null) {
            uriBuilder.queryParam(MAX_RESULTS_ATTRIBUTE, maxResults);
        }
        if (nextPageToken != null) {
            uriBuilder.queryParam(NEXT_PAGE_TOKEN_ATTRIBUTE, nextPageToken);
        }
        return this.getAndParse(uriBuilder.build(new Object[0]), this.searchResultJsonParser);
    }

    private void addOptionalQueryParam(UriBuilder uriBuilder, String key, Object ... values) {
        if (values != null && values.length > 0 && values[0] != null) {
            uriBuilder.queryParam(key, values);
        }
    }

    private Promise<SearchResult> searchJqlImplPost(@Nullable Integer maxResults, @Nullable String nextPageToken, String expandosValues, String jql, @Nullable Set<String> fields) {
        JSONObject postEntity = new JSONObject();
        try {
            postEntity.put(JQL_ATTRIBUTE, jql);
            postEntity.put(EXPAND_ATTRIBUTE, expandosValues);
            if (maxResults != null) {
                postEntity.put(MAX_RESULTS_ATTRIBUTE, maxResults);
            }
            if (nextPageToken != null) {
                postEntity.put(NEXT_PAGE_TOKEN_ATTRIBUTE, nextPageToken);
            }
            if (fields != null) {
                postEntity.put(FIELDS_ATTRIBUTE, fields);
            }
        }
        catch (JSONException e) {
            throw new RestClientException(e);
        }
        return this.postAndParse(this.searchCloudUri, postEntity, this.searchResultJsonParser);
    }

    @Override
    public Promise<Iterable<Filter>> getFavouriteFilters() {
        return this.getAndParse(this.favouriteUri, this.filtersParser);
    }

    @Override
    public Promise<Filter> getFilter(URI filterUri) {
        return this.getAndParse(filterUri, this.filterJsonParser);
    }

    @Override
    public Promise<Filter> getFilter(long id) {
        return this.getFilter(UriBuilder.fromUri(this.baseUri).path(String.format(FILTER_PATH_FORMAT, id)).build(new Object[0]));
    }
}

