/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators.helper;

import jakarta.inject.Inject;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.project.AutomationWorkflowType;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testautomation.AutomatedTestTechnology;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestStatus;
import org.squashtest.tm.plugin.rest.jackson.model.ExploratoryTestCaseDto;
import org.squashtest.tm.plugin.rest.jackson.model.KeywordTestCaseDto;
import org.squashtest.tm.plugin.rest.jackson.model.RestType;
import org.squashtest.tm.plugin.rest.jackson.model.ScriptedTestCaseDto;
import org.squashtest.tm.plugin.rest.jackson.model.TestCaseDto;
import org.squashtest.tm.plugin.rest.jackson.model.TestCaseDtoVisitor;
import org.squashtest.tm.plugin.rest.validators.helper.RestNodeValidationHelper;
import org.squashtest.tm.service.infolist.InfoListItemFinderService;
import org.squashtest.tm.service.testautomation.AutomatedTestTechnologyFinderService;
import org.squashtest.tm.service.testcase.TestCaseFinder;

@Component
public class TestCaseDtoValidationHelper
extends RestNodeValidationHelper {
    @Inject
    private InfoListItemFinderService infoListItemFinderService;
    @Inject
    private AutomatedTestTechnologyFinderService automatedTestTechnologyFinderService;
    @Inject
    private TestCaseFinder testCaseFinder;
    private static final String NONE_VALUE = "None";

    public void checkInvalidAttributeForEachTestCaseType(Errors errors, TestCaseDto iTestCase) {
        InvalidTestCaseAttributesVisitor testCaseDtoVisitor = new InvalidTestCaseAttributesVisitor(errors);
        iTestCase.accept(testCaseDtoVisitor);
    }

    public void assignInfoList(Errors errors, TestCaseDto iTestCase) {
        this.checkAndAssignType(errors, iTestCase);
        this.checkAndAssignNature(errors, iTestCase);
    }

    private void checkAndAssignNature(Errors errors, TestCaseDto iTestCase) {
        InfoListItem nature = iTestCase.getNature();
        if (nature != null) {
            String code = nature.getCode();
            Project project = iTestCase.getProject();
            if (project == null) {
                throw new IllegalArgumentException("Programmatic error : You must give a project to a Rest Node to be able to check infolist.");
            }
            if (this.infoListItemFinderService.isNatureConsistent(project.getId().longValue(), code)) {
                iTestCase.setNature(this.infoListItemFinderService.findByCode(code));
            } else {
                errors.rejectValue("nature", "invalid nature", "Invalid test case nature for this project");
            }
        }
    }

    private void checkAndAssignType(Errors errors, TestCaseDto iTestCase) {
        InfoListItem type = iTestCase.getType();
        if (type != null) {
            String code = type.getCode();
            if (this.infoListItemFinderService.isTypeConsistent(iTestCase.getProject().getId().longValue(), code)) {
                iTestCase.setType(this.infoListItemFinderService.findByCode(code));
            } else {
                errors.rejectValue("type", "invalid type", "Invalid test case type for this project");
            }
        }
    }

    public void checkAutomationAttributes(Errors errors, TestCaseDto patch) {
        if (patch.getAutomatedTestTechnology() != null) {
            this.checkAutomatedTestTechnologyAttribute(errors, patch);
        }
        if (patch.getScmRepositoryId() != null) {
            this.checkScmRepositoryAttribute(errors, patch);
        } else if (patch.getScmRepositoryUrl() != null) {
            errors.rejectValue("scmRepositoryUrl", "invalid attribute", "Scm Repository Url can not be modified directly. Use instead scm_repository_id to modify the associated scm repository.");
        }
        if (patch.getAutomatable() != null) {
            this.checkHasAutomationWorkflow(errors, patch, "automatable");
        }
        if (patch.getAutomationPriority() != null) {
            this.checkHasAutomationWorkflow(errors, patch, "automationPriority");
        }
        if (patch.getAutomationStatus() != null) {
            this.checkAutomationEligibility(errors, patch);
            this.checkValidAutomationWorkflowForAutomationStatusUpdate(errors, patch);
            this.checkValidAutomationStatus(errors, patch);
        }
    }

    private void checkAutomationEligibility(Errors errors, TestCaseDto patch) {
        TestCase tc = this.testCaseFinder.findById(patch.getId().longValue());
        boolean isAutomatable = TestCaseAutomatable.Y.equals((Object)tc.getAutomatable());
        if (!isAutomatable) {
            String message = "The selected eligibility does not allow automation of test case";
            errors.rejectValue("automationStatus", "invalid eligibility for automation", message);
        }
    }

    private void checkValidAutomationWorkflowForAutomationStatusUpdate(Errors errors, TestCaseDto patch) {
        AutomationWorkflowType automationWorkflowType = patch.getProject().getAutomationWorkflowType();
        if (AutomationWorkflowType.NONE.equals((Object)automationWorkflowType) || AutomationWorkflowType.REMOTE_WORKFLOW.equals((Object)automationWorkflowType)) {
            String message = String.format("The current automation workflow '%s' doesn't allow modification of automation status.", automationWorkflowType.name());
            errors.rejectValue("automationStatus", "invalid automation workflow for automation status update", message);
        }
    }

    private void checkValidAutomationStatus(Errors errors, TestCaseDto patch) {
        List<AutomationRequestStatus> validStatuses = List.of(AutomationRequestStatus.AUTOMATED);
        if (!validStatuses.contains(patch.getAutomationStatus())) {
            List validStatusesList = validStatuses.stream().map(Enum::name).collect(Collectors.toList());
            String message = String.format("The automation status '%s' is not handled by the API. Only the following statuses are currently supported: '%s'", patch.getAutomationStatus(), String.join((CharSequence)", ", validStatusesList));
            errors.rejectValue("automationStatus", "invalid automation status", message);
        }
    }

    private void checkAutomatedTestTechnologyAttribute(Errors errors, TestCaseDto patch) {
        AutomatedTestTechnology techno = this.automatedTestTechnologyFinderService.findByNameIgnoreCase(patch.getAutomatedTestTechnology());
        if (techno == null && !NONE_VALUE.equalsIgnoreCase(patch.getAutomatedTestTechnology())) {
            String allAutomatedTestTechnologies = this.automatedTestTechnologyFinderService.getAllAvailableAutomatedTestTechnology().stream().map(AutomatedTestTechnology::getName).collect(Collectors.joining(", "));
            String message = String.format("No entity known for %s and name %s. Available values are : %s, %s", AutomatedTestTechnology.class, patch.getAutomatedTestTechnology(), NONE_VALUE, allAutomatedTestTechnologies);
            errors.rejectValue("automatedTestTechnology", "invalid automated test technology name", message);
        }
    }

    private void checkScmRepositoryAttribute(Errors errors, TestCaseDto patch) {
        this.checkEntityExist(errors, RestType.SCM_REPOSITORY, patch.getScmRepositoryId());
    }

    private void checkHasAutomationWorkflow(Errors errors, TestCaseDto patch, String field) {
        if (!patch.getProject().isAllowAutomationWorkflow()) {
            String message = String.format("The project '%s' doesn't have the automation workflow enabled.", patch.getProject().getName());
            errors.rejectValue(field, "invalid automation workflow", message);
            return;
        }
        AutomationWorkflowType automationWorkflowType = patch.getProject().getAutomationWorkflowType();
        if (AutomationWorkflowType.NONE.equals((Object)automationWorkflowType)) {
            String message = String.format("The current automation workflow '%s' doesn't allow modification.", automationWorkflowType.name(), field);
            errors.rejectValue(field, "invalid automation workflow", message);
        }
    }

    private static final class InvalidTestCaseAttributesVisitor
    implements TestCaseDtoVisitor {
        private final Errors errors;

        InvalidTestCaseAttributesVisitor(Errors errors) {
            this.errors = errors;
        }

        @Override
        public void visit(TestCaseDto testCaseDto) {
        }

        @Override
        public void visit(ScriptedTestCaseDto scriptedTestCaseDto) {
            this.rejectStepsAndParametersAndDatasets(scriptedTestCaseDto, "Scripted");
        }

        @Override
        public void visit(KeywordTestCaseDto keywordTestCaseDto) {
        }

        @Override
        public void visit(ExploratoryTestCaseDto exploratoryTestCaseDto) {
            this.rejectStepsAndParametersAndDatasets(exploratoryTestCaseDto, "Exploratory");
        }

        private void rejectStepsAndParametersAndDatasets(TestCaseDto testCaseDto, String kind) {
            if (testCaseDto.getSteps() != null) {
                this.errors.rejectValue("steps", "invalid steps", String.format("%s test case should not have steps", kind));
            }
            if (testCaseDto.getParameters() != null) {
                this.errors.rejectValue("parameters", "invalid parameters", String.format("%s test case should not have parameters", kind));
            }
            if (testCaseDto.getDatasets() != null) {
                this.errors.rejectValue("datasets", "invalid datasets", String.format("%s test case should not have datasets", kind));
            }
        }
    }
}

