/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import jakarta.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.campaign.SprintReqVersion;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.plugin.rest.jackson.model.SprintReqVersionDto;
import org.squashtest.tm.plugin.rest.repository.RestSprintReqVersionRepository;
import org.squashtest.tm.plugin.rest.repository.RestTestPlanItemRepository;
import org.squashtest.tm.plugin.rest.service.RestSprintReqVersionService;
import org.squashtest.tm.service.campaign.SprintManagerService;
import org.squashtest.tm.service.campaign.SprintReqVersionModificationService;

@Service
@Transactional
public class RestSprintReqVersionServiceImpl
implements RestSprintReqVersionService {
    @Inject
    private RestSprintReqVersionRepository sprintReqVersionRepository;
    @Inject
    private RestTestPlanItemRepository restTestPlanItemRepository;
    @Inject
    private SprintManagerService sprintManagerService;
    @Inject
    private SprintReqVersionModificationService sprintReqVersionModificationService;
    @Inject
    private DSLContext dslContext;

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="@apiSecurity.hasPermission(#sprintReqVersionId, 'org.squashtest.tm.domain.campaign.SprintReqVersion', 'READ')")
    public SprintReqVersion getOne(Long sprintReqVersionId) {
        return (SprintReqVersion)this.sprintReqVersionRepository.getReferenceById(sprintReqVersionId);
    }

    @Override
    public void deleteSprintReqVersionsByIds(List<Long> ids) {
        List<RestSprintReqVersionRepository.SrvIdBySprintIdRecord> srvIdsBySprintIdRecords = this.sprintReqVersionRepository.findSrvIdsBySprintIds(ids);
        Map srvIdsBySprintIds = srvIdsBySprintIdRecords.stream().collect(Collectors.groupingBy(RestSprintReqVersionRepository.SrvIdBySprintIdRecord::getSprintId, Collectors.mapping(RestSprintReqVersionRepository.SrvIdBySprintIdRecord::getSprintReqVersionId, Collectors.toList())));
        srvIdsBySprintIds.forEach((sprintId, srvIds) -> this.sprintManagerService.deleteSprintReqVersions(sprintId.longValue(), (Collection)srvIds));
    }

    @Override
    public SprintReqVersion patchSprintReqVersion(long id, SprintReqVersionDto sprintReqVersionDto) {
        this.sprintReqVersionModificationService.changeValidationStatus(id, sprintReqVersionDto.getValidationStatus());
        return this.getOne(id);
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="@apiSecurity.hasPermission(#sprintReqVersionId, 'org.squashtest.tm.domain.campaign.SprintReqVersion', 'READ')")
    public Page<TestPlanItem> findSprintReqVersionTestPlan(long sprintReqVersionId, Pageable pageable) {
        return this.restTestPlanItemRepository.findAllBySprintReqVersionId(sprintReqVersionId, pageable);
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#id, 'org.squashtest.tm.domain.campaign.SprintReqVersion', 'READ')")
    public List<Long> getExecutionIdsBySprintReqVersion(long id) {
        return this.dslContext.select((SelectField)Tables.EXECUTION.EXECUTION_ID).from((TableLike)Tables.EXECUTION).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq((Field)Tables.EXECUTION.TEST_PLAN_ITEM_ID)).join((TableLike)Tables.SPRINT_REQ_VERSION).on(Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).where(Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID.eq((Object)id)).fetchInto(Long.class);
    }
}

