/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import jakarta.inject.Inject;
import java.util.List;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.execution.ExploratoryExecution;
import org.squashtest.tm.domain.execution.SessionNote;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.plugin.rest.repository.RestSessionNoteRepository;
import org.squashtest.tm.plugin.rest.service.RestSessionNoteService;

@Service
@Transactional
public class RestSessionNoteServiceImpl
implements RestSessionNoteService {
    @Inject
    private RestSessionNoteRepository sessionNoteRepository;
    @Inject
    private DSLContext dslContext;

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#id,'org.squashtest.tm.domain.execution.SessionNote' , 'READ')")
    @Transactional(readOnly=true)
    public SessionNote getOne(long id) {
        return (SessionNote)this.sessionNoteRepository.getReferenceById(id);
    }

    @Override
    public List<SessionNote> getSessionNotesFromIssue(String remoteIssueId, Long executionId) {
        return this.dslContext.selectDistinct((SelectField)Tables.SESSION_NOTE.NOTE_ID.as("ID")).from((TableLike)Tables.SESSION_NOTE).join((TableLike)Tables.ISSUE_LIST).on(Tables.ISSUE_LIST.ISSUE_LIST_ID.eq((Field)Tables.SESSION_NOTE.ISSUE_LIST_ID)).join((TableLike)Tables.ISSUE).on(Tables.ISSUE.ISSUE_LIST_ID.eq((Field)Tables.ISSUE_LIST.ISSUE_LIST_ID)).join((TableLike)Tables.EXPLORATORY_EXECUTION).on(Tables.EXPLORATORY_EXECUTION.EXECUTION_ID.eq((Field)Tables.SESSION_NOTE.EXECUTION_ID)).join((TableLike)Tables.EXECUTION_ISSUES_CLOSURE).on(Tables.EXECUTION_ISSUES_CLOSURE.EXECUTION_ID.eq((Field)Tables.EXPLORATORY_EXECUTION.EXECUTION_ID)).where(Tables.EXECUTION_ISSUES_CLOSURE.EXECUTION_ID.eq((Object)executionId)).and(Tables.ISSUE.REMOTE_ISSUE_ID.eq((Object)remoteIssueId)).fetchInto(SessionNote.class);
    }

    @Override
    public ExploratoryExecution getExecutionFromSessionNote(Long sessionNoteId) {
        return (ExploratoryExecution)this.dslContext.select((SelectField)Tables.EXPLORATORY_EXECUTION.EXECUTION_ID.as("ID")).from((TableLike)Tables.EXPLORATORY_EXECUTION).join((TableLike)Tables.SESSION_NOTE).on(Tables.SESSION_NOTE.EXECUTION_ID.eq((Field)Tables.EXPLORATORY_EXECUTION.EXECUTION_ID)).where(Tables.SESSION_NOTE.NOTE_ID.eq((Object)sessionNoteId)).fetchOneInto(ExploratoryExecution.class);
    }
}

