/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service;

import java.util.List;
import java.util.Map;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.squashtest.tm.domain.acl.AclGroup;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.domain.customreport.CustomReportLibraryNode;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.domain.resource.Resource;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.plugin.rest.jackson.model.GenericProjectDto;
import org.squashtest.tm.plugin.rest.jackson.model.RestPartyClearance;
import org.squashtest.tm.plugin.rest.jackson.model.RestPartyPermission;

public interface RestProjectService {
    public Boolean isGenericProjectExist(long var1);

    public GenericProject getOne(long var1);

    public GenericProject getOneByName(String var1);

    public Page<GenericProject> findAllReadable(Long var1, String var2, Pageable var3);

    public Page<GenericProject> findAllReadableProjectTemplate(Long var1, String var2, Pageable var3);

    public Page<GenericProject> findAllReadableStandardProject(Long var1, String var2, Pageable var3);

    public Page<RequirementLibraryNode<Resource>> findRequirementLibraryAllContent(long var1, Pageable var3);

    public Page<RequirementLibraryNode<Resource>> findRequirementLibraryRootContent(long var1, Pageable var3);

    public Page<TestCaseLibraryNode> findTestCaseLibraryAllContent(long var1, Pageable var3);

    public Page<TestCaseLibraryNode> findTestCaseLibraryRootContent(long var1, Pageable var3);

    public Page<CampaignLibraryNode> findCampaignLibraryAllContent(long var1, Pageable var3);

    public Page<CampaignLibraryNode> findCampaignLibraryRootContent(long var1, Pageable var3);

    public GenericProject createGenericProject(GenericProjectDto var1);

    public RestPartyClearance findAllClearancesByProjectId(long var1);

    public RestPartyPermission findAllPermissionsByProjectId(long var1);

    public RestPartyPermission buildPartyPermissionDataModel(String var1, List<Long> var2);

    public RestPartyClearance buildPartyClearanceDataModel(long var1, List<Long> var3);

    public void addNewPermissionToProject(long var1, long var3, String var5);

    public void addNewPermissionToProject(long var1, long var3, long var5);

    public List<AclGroup> findAllPossiblePermission();

    public Page<Requirement> findRequirementsByProject(long var1, Pageable var3);

    public Page<TestCase> findTestCasesByProject(long var1, Pageable var3, List<String> var4);

    public Page<Campaign> findCampaignsByProject(long var1, Pageable var3);

    public void deletePartyFromProject(Long var1, long var2);

    public Map<Long, String> findNamesByProjectIds(List<Long> var1);

    public List<Long> getReadableProjectIdsOnRequirementLibrary(List<Long> var1);

    public List<Long> getReadableProjectIdsOnTestCaseLibrary(List<Long> var1);

    public List<Long> getReadableProjectIdsOnCampaignLibrary(List<Long> var1);

    public Page<CustomReportLibraryNode> findCustomReportLibraryAllContent(long var1, Pageable var3);

    public Page<CustomReportLibraryNode> findCustomReportLibraryRootContent(long var1, Pageable var3);

    public <T> void replaceLinksByCustomSelfLinks(EntityModel<T> var1, String var2);

    public String toKebabCase(String var1);
}

