/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.ser.VirtualBeanPropertyWriter;
import com.fasterxml.jackson.databind.util.Annotations;
import jakarta.inject.Inject;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestPlanStatistics;
import org.squashtest.tm.plugin.rest.service.RestIterationService;

@Component
public class IterationStatusWriter
extends VirtualBeanPropertyWriter {
    @Inject
    private RestIterationService restIterationService;

    public IterationStatusWriter() {
    }

    private IterationStatusWriter(BeanPropertyDefinition propDef, Annotations contextAnnotations, JavaType declaredType, RestIterationService restIterationService) {
        super(propDef, contextAnnotations, declaredType);
        this.restIterationService = restIterationService;
    }

    protected Object value(Object bean, JsonGenerator gen, SerializerProvider prov) {
        Iteration holder = (Iteration)bean;
        TestPlanStatistics testPlanStatistics = this.restIterationService.getIterationStatisticsByTpiIds(holder.getId());
        return testPlanStatistics.getStatus();
    }

    public VirtualBeanPropertyWriter withConfig(MapperConfig<?> config, AnnotatedClass declaringClass, BeanPropertyDefinition propDef, JavaType type) {
        return new IterationStatusWriter(propDef, declaringClass.getAnnotations(), type, this.restIterationService);
    }
}

