/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.PropertyFilter;
import com.fasterxml.jackson.databind.ser.VirtualBeanPropertyWriter;
import com.fasterxml.jackson.databind.util.Annotations;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolder;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldValue;
import org.squashtest.tm.plugin.rest.core.jackson.SerializationDynamicFilter;
import org.squashtest.tm.plugin.rest.jackson.model.CustomFieldValueDto;
import org.squashtest.tm.plugin.rest.jackson.model.RestCustomFieldMembers;
import org.squashtest.tm.service.denormalizedfield.DenormalizedFieldValueManager;

@Component
public class DenormalizedCustomFieldValuesPropertyWriter
extends VirtualBeanPropertyWriter {
    @Inject
    private DenormalizedFieldValueManager denormalizedFieldValueFinder;

    public DenormalizedCustomFieldValuesPropertyWriter() {
    }

    public DenormalizedCustomFieldValuesPropertyWriter(BeanPropertyDefinition propDef, Annotations contextAnnotations, JavaType declaredType, DenormalizedFieldValueManager denormalizedFieldValueFinder) {
        super(propDef, contextAnnotations, declaredType);
        this.denormalizedFieldValueFinder = denormalizedFieldValueFinder;
    }

    protected Object value(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
        RestCustomFieldMembers customFieldValueDtos = new RestCustomFieldMembers();
        if (this.denormalizedFieldValueFinder != null) {
            List denormalizedFieldValues = this.denormalizedFieldValueFinder.findAllForEntity((DenormalizedFieldHolder)bean);
            List<DenormalizedFieldValue> filtered = this.applyFilter(denormalizedFieldValues, prov);
            for (DenormalizedFieldValue denormalizedFieldValue : filtered) {
                customFieldValueDtos.add(new CustomFieldValueDto(denormalizedFieldValue));
            }
        }
        return customFieldValueDtos;
    }

    public VirtualBeanPropertyWriter withConfig(MapperConfig<?> config, AnnotatedClass declaringClass, BeanPropertyDefinition propDef, JavaType type) {
        return new DenormalizedCustomFieldValuesPropertyWriter(propDef, declaringClass.getAnnotations(), type, this.denormalizedFieldValueFinder);
    }

    private List<DenormalizedFieldValue> applyFilter(List<DenormalizedFieldValue> orig, SerializerProvider provider) {
        SerializationDynamicFilter filter = this.findFilter(orig, provider);
        if (filter == null) {
            return orig;
        }
        filter = filter.forCurrentBean();
        ArrayList<DenormalizedFieldValue> newlist = new ArrayList<DenormalizedFieldValue>();
        for (DenormalizedFieldValue value : orig) {
            if (!filter.include(value.getCode())) continue;
            newlist.add(value);
        }
        return newlist;
    }

    private SerializationDynamicFilter findFilter(List<DenormalizedFieldValue> cufs, SerializerProvider provider) {
        FilterProvider filterProvider = provider.getConfig().getFilterProvider();
        if (filterProvider != null) {
            try {
                PropertyFilter filter = filterProvider.findPropertyFilter((Object)"squashrest", cufs);
                if (filter != null && SerializationDynamicFilter.class.isAssignableFrom(filter.getClass())) {
                    return (SerializationDynamicFilter)filter;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return null;
    }
}

