/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.core.web;

import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.server.LinkRelationProvider;
import org.springframework.util.StringUtils;
import org.squashtest.tm.plugin.rest.core.jackson.RestDtoName;

public class RestApiRelProvider
implements LinkRelationProvider {
    public boolean supports(LinkRelationProvider.LookupContext delimiter) {
        return true;
    }

    public LinkRelation getItemResourceRelFor(Class<?> type) {
        return LinkRelation.of((String)this.hyphenatedClassname(type));
    }

    public LinkRelation getCollectionResourceRelFor(Class<?> type) {
        RestDtoName annotation = (RestDtoName)AnnotationUtils.findAnnotation(type, RestDtoName.class);
        if (annotation != null) {
            return LinkRelation.of((String)this.getPluralName(annotation.value()));
        }
        return LinkRelation.of((String)this.getPluralName(this.hyphenatedClassname(type)));
    }

    private String getPluralName(String name) {
        if (name.endsWith("y")) {
            return name.substring(0, name.length() - 1) + "ies";
        }
        return name + "s";
    }

    private String hyphenatedClassname(Class<?> type) {
        return StringUtils.uncapitalize((String)type.getSimpleName()).replaceAll("(?=[A-Z])", "-$0").toLowerCase();
    }
}

