/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.core.web;

import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.squashtest.tm.plugin.rest.core.web.ContentInclusion;

public class ContentInclusionArgumentResolver
implements HandlerMethodArgumentResolver {
    private ContentInclusion defaultInclusion = ContentInclusion.ROOT;
    private String includeParameterName = "include";

    public boolean supportsParameter(MethodParameter parameter) {
        return ContentInclusion.class.equals((Object)parameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        String value = webRequest.getParameter(this.includeParameterName);
        if (value == null) {
            return this.defaultInclusion;
        }
        try {
            return ContentInclusion.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Invalid value '" + value + "' for request parameter '" + this.includeParameterName + "' : must be one of '" + ContentInclusion.ROOT.name().toLowerCase() + "', '" + ContentInclusion.NESTED.name().toLowerCase() + "'");
        }
    }

    public ContentInclusion getDefaultInclusion() {
        return this.defaultInclusion;
    }

    public void setDefaultInclusion(ContentInclusion defaultInclusion) {
        this.defaultInclusion = defaultInclusion;
    }

    public String getIncludeParameterName() {
        return this.includeParameterName;
    }

    public void setIncludeParameterName(String includeParameterName) {
        this.includeParameterName = includeParameterName;
    }
}

