/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.jiracloud.internal.conversion;

import jakarta.inject.Inject;
import java.util.Collection;
import java.util.List;
import jiracloud.com.atlassian.jira.rest.client.api.domain.BasicUser;
import jiracloud.com.atlassian.jira.rest.client.api.domain.CimProject;
import jiracloud.com.atlassian.jira.rest.client.api.domain.Issue;
import jiracloud.com.atlassian.jira.rest.client.api.domain.Permission;
import jiracloud.com.atlassian.jira.rest.client.api.domain.input.AttachmentInput;
import jiracloud.com.atlassian.jira.rest.client.api.domain.input.IssueInput;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerInterfaceDescriptor;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedIssue;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedProject;
import org.squashtest.tm.bugtracker.advanceddomain.FieldValue;
import org.squashtest.tm.bugtracker.definition.Attachment;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.JiraClient;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.conversion.JiraCloudToSquashEntityConverter;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.conversion.SquashToJiraCloudEntityConverter;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.exceptions.NumberConversionException;
import org.squashtest.tm.plugin.bugtracker.jiracloud.internal.json.BasicEntity;

@Component
@Scope(value="prototype")
public class CloudEntityConverter {
    @Inject
    private JiraCloudToSquashEntityConverter j2Sconverter;
    @Inject
    private SquashToJiraCloudEntityConverter s2Jconverter;

    public void setJiraClient(JiraClient client) {
        this.j2Sconverter.setJiraClient(client);
    }

    public AdvancedProject jira2SquashProject(CimProject jiraProject, Permission userPickerPermission) {
        return this.j2Sconverter.jira2SquashProject(jiraProject, userPickerPermission);
    }

    public AdvancedIssue jira2SquashIssue(Issue jiraIssue) {
        return this.j2Sconverter.jira2SquashIssue(jiraIssue);
    }

    public List<AdvancedIssue> jira2SquashIssues(Iterable<Issue> jiraIssues) {
        return this.j2Sconverter.jira2SquashIssues(jiraIssues);
    }

    public FieldValue convertToEpicCompositeFieldValue(Iterable<? extends BasicEntity> entities, String typename) {
        return this.j2Sconverter.convertToEpicCompositeFieldValue(entities, typename);
    }

    public FieldValue convertToUserCompositeFieldValue(Iterable<BasicUser> users) {
        return this.j2Sconverter.convertToUserCompositeFieldValue(users);
    }

    public IssueInput squash2jiraIssue(AdvancedIssue issue, long issueTypeId) throws NumberConversionException {
        return this.s2Jconverter.squash2jiraIssue(issue, issueTypeId);
    }

    public AdvancedProject createReadOnlyProjectStub(String schemeName, BugTrackerInterfaceDescriptor descriptor) {
        return this.j2Sconverter.createReadOnlyProjectStub(schemeName, descriptor);
    }

    public Collection<AttachmentInput> convertToJiraAttachments(Collection<Attachment> sqAttachments) {
        return this.s2Jconverter.convertToJiraAttachments(sqAttachments);
    }
}

