/*
 * Decompiled with CFR 0.152.
 */
package jiracloud.org.apache.http.impl.client.cache;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import jiracloud.org.apache.http.client.cache.HttpCacheInvalidator;
import jiracloud.org.apache.http.client.cache.HttpCacheStorage;
import jiracloud.org.apache.http.client.cache.ResourceFactory;
import jiracloud.org.apache.http.impl.client.HttpClientBuilder;
import jiracloud.org.apache.http.impl.client.cache.AsynchronousValidator;
import jiracloud.org.apache.http.impl.client.cache.BasicHttpCache;
import jiracloud.org.apache.http.impl.client.cache.BasicHttpCacheStorage;
import jiracloud.org.apache.http.impl.client.cache.CacheConfig;
import jiracloud.org.apache.http.impl.client.cache.CacheInvalidator;
import jiracloud.org.apache.http.impl.client.cache.CacheKeyGenerator;
import jiracloud.org.apache.http.impl.client.cache.CachingExec;
import jiracloud.org.apache.http.impl.client.cache.FileResourceFactory;
import jiracloud.org.apache.http.impl.client.cache.HeapResourceFactory;
import jiracloud.org.apache.http.impl.client.cache.ImmediateSchedulingStrategy;
import jiracloud.org.apache.http.impl.client.cache.ManagedHttpCacheStorage;
import jiracloud.org.apache.http.impl.client.cache.SchedulingStrategy;
import jiracloud.org.apache.http.impl.execchain.ClientExecChain;

public class CachingHttpClientBuilder
extends HttpClientBuilder {
    private ResourceFactory resourceFactory;
    private HttpCacheStorage storage;
    private File cacheDir;
    private CacheConfig cacheConfig;
    private SchedulingStrategy schedulingStrategy;
    private HttpCacheInvalidator httpCacheInvalidator;
    private boolean deleteCache = true;

    public static CachingHttpClientBuilder create() {
        return new CachingHttpClientBuilder();
    }

    protected CachingHttpClientBuilder() {
    }

    public final CachingHttpClientBuilder setResourceFactory(ResourceFactory resourceFactory) {
        this.resourceFactory = resourceFactory;
        return this;
    }

    public final CachingHttpClientBuilder setHttpCacheStorage(HttpCacheStorage storage) {
        this.storage = storage;
        return this;
    }

    public final CachingHttpClientBuilder setCacheDir(File cacheDir) {
        this.cacheDir = cacheDir;
        return this;
    }

    public final CachingHttpClientBuilder setCacheConfig(CacheConfig cacheConfig) {
        this.cacheConfig = cacheConfig;
        return this;
    }

    public final CachingHttpClientBuilder setSchedulingStrategy(SchedulingStrategy schedulingStrategy) {
        this.schedulingStrategy = schedulingStrategy;
        return this;
    }

    public final CachingHttpClientBuilder setHttpCacheInvalidator(HttpCacheInvalidator cacheInvalidator) {
        this.httpCacheInvalidator = cacheInvalidator;
        return this;
    }

    public CachingHttpClientBuilder setDeleteCache(boolean deleteCache) {
        this.deleteCache = deleteCache;
        return this;
    }

    @Override
    protected ClientExecChain decorateMainExec(ClientExecChain mainExec) {
        HttpCacheStorage storageCopy;
        CacheConfig config = this.cacheConfig != null ? this.cacheConfig : CacheConfig.DEFAULT;
        ResourceFactory resourceFactoryCopy = this.resourceFactory;
        if (resourceFactoryCopy == null) {
            resourceFactoryCopy = this.cacheDir == null ? new HeapResourceFactory() : new FileResourceFactory(this.cacheDir);
        }
        if ((storageCopy = this.storage) == null) {
            if (this.cacheDir == null) {
                storageCopy = new BasicHttpCacheStorage(config);
            } else {
                final ManagedHttpCacheStorage managedStorage = new ManagedHttpCacheStorage(config);
                if (this.deleteCache) {
                    this.addCloseable(new Closeable(){

                        @Override
                        public void close() throws IOException {
                            managedStorage.shutdown();
                        }
                    });
                } else {
                    this.addCloseable(managedStorage);
                }
                storageCopy = managedStorage;
            }
        }
        AsynchronousValidator revalidator = this.createAsynchronousRevalidator(config);
        CacheKeyGenerator uriExtractor = new CacheKeyGenerator();
        HttpCacheInvalidator cacheInvalidator = this.httpCacheInvalidator;
        if (cacheInvalidator == null) {
            cacheInvalidator = new CacheInvalidator(uriExtractor, storageCopy);
        }
        return new CachingExec(mainExec, new BasicHttpCache(resourceFactoryCopy, storageCopy, config, uriExtractor, cacheInvalidator), config, revalidator);
    }

    private AsynchronousValidator createAsynchronousRevalidator(CacheConfig config) {
        if (config.getAsynchronousWorkersMax() > 0) {
            SchedulingStrategy configuredSchedulingStrategy = this.createSchedulingStrategy(config);
            AsynchronousValidator revalidator = new AsynchronousValidator(configuredSchedulingStrategy);
            this.addCloseable(revalidator);
            return revalidator;
        }
        return null;
    }

    private SchedulingStrategy createSchedulingStrategy(CacheConfig config) {
        return this.schedulingStrategy != null ? this.schedulingStrategy : new ImmediateSchedulingStrategy(config);
    }
}

