/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.validators;

import jakarta.inject.Inject;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.exception.DomainException;
import org.squashtest.tm.exception.NameAlreadyInUseException;
import org.squashtest.tm.exception.RequiredFieldException;
import org.squashtest.tm.exception.sync.PathAlreadyInUseException;
import org.squashtest.tm.exception.sync.PathContainsASprintGroupException;
import org.squashtest.tm.exception.sync.PathValidationDomainException;
import org.squashtest.tm.plugin.jirasync.domain.JiraRemoteSynchronisation;
import org.squashtest.tm.plugin.jirasync.domain.JiraSelectType;
import org.squashtest.tm.plugin.jirasync.exception.LocalePluginValidationException;
import org.squashtest.tm.plugin.jirasync.service.ConfigurationService;
import org.squashtest.tm.plugin.rest.admin.jackson.model.JiraRemoteSynchronisationModelDto;
import org.squashtest.tm.plugin.rest.admin.validators.RestJiraSyncApiValidator;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.service.remotesynchronisation.RemoteSynchronisationService;

@Component
public class RemoteSynchronisationValidator
extends RestJiraSyncApiValidator {
    private static final String ATTRIBUTE_CANNOT_BE_EMPTY = "This attribute cannot be empty.";
    private static final String POST_SYNCHRONISATION_VALIDATION = "post-synchronisation-validation";
    private static final String POST_SPRINT_SYNCHRONISATION_VALIDATION = "post-sprint-synchronisation-validation";
    private static final String PATCH_REQUIREMENT_SYNCHRONISATION_VALIDATION = "patch-requirement-synchronisation-validation";
    private static final String PATCH_SPRINT_SYNCHRONISATION_VALIDATION = "patch-sprint-synchronisation-validation";
    private static final String CANNOT_POST_GENERATED_ID = "This attribute is generated by database and should not be provided. If you want to update an existing synchronisation, please do a patch request to the synchronisation id.";
    public static final String REQUIRED = "required";
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private RemoteSynchronisationService remoteSynchronisationService;

    public boolean supports(Class<?> clazz) {
        return JiraRemoteSynchronisationModelDto.class.equals(clazz);
    }

    public void validatePostRemoteSynchronisation(JiraRemoteSynchronisationModelDto synchronisationDto, long projectId) throws BindException {
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        BeanPropertyBindingResult validationBean = new BeanPropertyBindingResult((Object)synchronisationDto, POST_SYNCHRONISATION_VALIDATION);
        Project project = (Project)this.checkEntityExist((Errors)validationBean, Project.class, projectId);
        this.checkServer(synchronisationDto.getServerId(), (Errors)validationBean);
        this.checkRequirementSynchronisation(project, synchronisationDto, (BindingResult)validationBean);
        String selectType = synchronisationDto.getSelectTypeConst();
        if (synchronisationDto.getSprintSynchronisationEnable()) {
            this.checkSprintSynchronisation(project, selectType, synchronisationDto, synchronisationDto.getRestrictedToActiveSprint(), (Errors)validationBean);
        }
        if (validationBean.hasErrors()) {
            errors.add(validationBean);
        }
        ErrorHandlerHelper.throwIfError((Object)synchronisationDto, errors, (String)POST_SYNCHRONISATION_VALIDATION);
    }

    public void validatePostSprintSynchronisation(JiraRemoteSynchronisationModelDto synchronisationDto, long jiraSynchroId) throws BindException {
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        BeanPropertyBindingResult validationBean = new BeanPropertyBindingResult((Object)synchronisationDto, POST_SPRINT_SYNCHRONISATION_VALIDATION);
        RemoteSynchronisation remoteSynchronisation = (RemoteSynchronisation)this.checkEntityExist((Errors)validationBean, RemoteSynchronisation.class, jiraSynchroId);
        if (!synchronisationDto.getSprintSynchronisationEnable()) {
            validationBean.rejectValue("sprintSynchronisationEnable", "not enabled", "The attribute sprint_synchronisation_activated must be present and true.");
        }
        if (Objects.nonNull(remoteSynchronisation)) {
            JiraRemoteSynchronisation jiraRemoteSynchronisation = new JiraRemoteSynchronisation(remoteSynchronisation);
            this.checkIfSprintSynchronisationExists(jiraRemoteSynchronisation, (BindingResult)validationBean);
            Project project = remoteSynchronisation.getProject();
            String selectType = remoteSynchronisation.getSelectType();
            this.checkSprintSynchronisation(project, selectType, synchronisationDto, jiraRemoteSynchronisation.isRestrictedToActiveSprint(), (Errors)validationBean);
        }
        if (validationBean.hasErrors()) {
            errors.add(validationBean);
        }
        ErrorHandlerHelper.throwIfError((Object)synchronisationDto, errors, (String)POST_SPRINT_SYNCHRONISATION_VALIDATION);
    }

    private void checkIfSprintSynchronisationExists(JiraRemoteSynchronisation jiraRemoteSynchronisation, BindingResult validationBean) {
        if (jiraRemoteSynchronisation.isSprintSynchronisationEnable()) {
            String errorMessage = String.format("A sprint synchronisation is already configured for synchronisation %d. To update it, use the correct PATCH request", jiraRemoteSynchronisation.getId());
            validationBean.rejectValue("sprintSynchronisationEnable", "sprint synchronisation already exists", errorMessage);
        }
    }

    private void checkIfSelectTypeIsBoard(String selectType, Errors validationBean) {
        if (JiraSelectType.BOARD.toString().equals(selectType)) {
            return;
        }
        validationBean.rejectValue("id", "not board synchronisation", "The synchronisation is not a board synchronisation. It cannot have a sprint synchronisation configuration");
    }

    public void validatePatchRequirementRemoteSynchronisation(JiraRemoteSynchronisationModelDto synchronisationDto, long jiraSynchroId) throws BindException {
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        BeanPropertyBindingResult validationBean = new BeanPropertyBindingResult((Object)synchronisationDto, PATCH_REQUIREMENT_SYNCHRONISATION_VALIDATION);
        this.checkEntityExist((Errors)validationBean, RemoteSynchronisation.class, jiraSynchroId);
        if (Objects.nonNull(synchronisationDto.getName())) {
            this.checkSynchronisationName(synchronisationDto.getName(), (Errors)validationBean);
        }
        if (validationBean.hasErrors()) {
            errors.add(validationBean);
        }
        ErrorHandlerHelper.throwIfError((Object)synchronisationDto, errors, (String)PATCH_REQUIREMENT_SYNCHRONISATION_VALIDATION);
    }

    public void validatePatchSprintRemoteSynchronisation(JiraRemoteSynchronisationModelDto synchronisationDto, long jiraSynchroId) throws BindException {
        JiraRemoteSynchronisation jiraRemoteSynchronisation;
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        BeanPropertyBindingResult validationBean = new BeanPropertyBindingResult((Object)synchronisationDto, PATCH_SPRINT_SYNCHRONISATION_VALIDATION);
        RemoteSynchronisation remoteSynchronisation = (RemoteSynchronisation)this.checkEntityExist((Errors)validationBean, RemoteSynchronisation.class, jiraSynchroId);
        if (Objects.nonNull(remoteSynchronisation) && !(jiraRemoteSynchronisation = new JiraRemoteSynchronisation(remoteSynchronisation)).isSprintSynchronisationEnable()) {
            validationBean.rejectValue("id", "no sprint synchronisation", "This synchronisation does not have a sprint synchronisation configured.");
        }
        if (validationBean.hasErrors()) {
            errors.add(validationBean);
        }
        ErrorHandlerHelper.throwIfError((Object)synchronisationDto, errors, (String)PATCH_SPRINT_SYNCHRONISATION_VALIDATION);
    }

    private void checkServer(Long serverId, Errors validationBean) {
        if (serverId == null) {
            validationBean.rejectValue("serverId", REQUIRED, ATTRIBUTE_CANNOT_BE_EMPTY);
        } else {
            this.checkEntityExist(validationBean, BugTracker.class, serverId);
        }
    }

    private void checkRequirementSynchronisation(Project project, JiraRemoteSynchronisationModelDto synchronisationDto, BindingResult validationBean) {
        this.checkSynchronisationId(synchronisationDto.getId(), (Errors)validationBean);
        this.checkSynchronisationName(synchronisationDto.getName(), (Errors)validationBean);
        this.checkRequirementSynchronisationPath(project, synchronisationDto.getSynchronisationPath(), (Errors)validationBean);
        this.checkSelectType(synchronisationDto.getSelectTypeConst(), (Errors)validationBean);
        this.checkSelectValue((Errors)validationBean);
    }

    private void checkSynchronisationId(Long synchronisationId, Errors validationBean) {
        if (synchronisationId != null) {
            validationBean.rejectValue("id", "generated value", CANNOT_POST_GENERATED_ID);
        }
    }

    private void checkSynchronisationName(String name, Errors errors) {
        try {
            this.configurationService.validateName(name);
        }
        catch (Exception ex) {
            Exception exception = ex;
            Objects.requireNonNull(exception);
            Exception exception2 = exception;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LocalePluginValidationException.class, NameAlreadyInUseException.class}, (Object)exception2, 0)) {
                case 0: {
                    LocalePluginValidationException localePluginValidationException = (LocalePluginValidationException)((Object)exception2);
                    errors.rejectValue("name", REQUIRED, ATTRIBUTE_CANNOT_BE_EMPTY);
                    break;
                }
                case 1: {
                    NameAlreadyInUseException nameAlreadyInUseException = (NameAlreadyInUseException)exception2;
                    errors.rejectValue("name", "name already in use", "Another synchronisation with this name already exists.");
                    break;
                }
                default: {
                    throw ex;
                }
            }
        }
    }

    private void checkSelectType(String selectType, Errors validationBean) {
        if (selectType == null) {
            validationBean.rejectValue("selectTypeConst", REQUIRED, ATTRIBUTE_CANNOT_BE_EMPTY);
        } else {
            try {
                JiraSelectType.valueOf(selectType);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String errorMessage = String.format("The attribute select_type is invalid. It can only be one of the following: %s", Arrays.toString((Object[])JiraSelectType.values()));
                validationBean.rejectValue("selectTypeConst", "invalid attribute", errorMessage);
            }
        }
    }

    private void checkSelectValue(Errors errors) {
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"selectValue", (String)REQUIRED, (String)ATTRIBUTE_CANNOT_BE_EMPTY);
    }

    private void checkSprintSynchronisation(Project project, String selectType, JiraRemoteSynchronisationModelDto synchronisationDto, boolean isRestrictedToActiveSprint, Errors errors) {
        this.checkIfSelectTypeIsBoard(selectType, errors);
        this.checkSprintSynchronisationPath(project, synchronisationDto, errors);
        this.checkSprintRestrictedToActiveSprintBoolean(isRestrictedToActiveSprint, synchronisationDto.getSprintRestrictedToActiveSprint(), errors);
    }

    private void checkSprintRestrictedToActiveSprintBoolean(boolean isRestrictedToActiveSprint, Boolean isSprintRestrictedToActiveSprint, Errors errors) {
        if (Objects.isNull(isSprintRestrictedToActiveSprint)) {
            errors.rejectValue("sprintRestrictedToActiveSprint", REQUIRED, ATTRIBUTE_CANNOT_BE_EMPTY);
        } else if (isRestrictedToActiveSprint && !isSprintRestrictedToActiveSprint.booleanValue()) {
            errors.rejectValue("sprintRestrictedToActiveSprint", "wrong value", "The attribute sprint_restricted_to_active_sprint cannot be false if restricted_to_active_sprint is true.");
        }
    }

    private void checkRequirementSynchronisationPath(Project project, String synchronisationPath, Errors errors) {
        if (Objects.nonNull(project)) {
            try {
                this.remoteSynchronisationService.validatePathForRequirementSync(project.getName(), synchronisationPath);
            }
            catch (DomainException ex) {
                this.handlePathExceptions(ex, errors, "synchronisationPath", "This path is already in use in the Requirement workspace.");
            }
        } else {
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"synchronisationPath", (String)REQUIRED, (String)ATTRIBUTE_CANNOT_BE_EMPTY);
        }
    }

    private void checkSprintSynchronisationPath(Project project, JiraRemoteSynchronisationModelDto synchronisationDto, Errors errors) {
        if (Objects.nonNull(project)) {
            try {
                this.remoteSynchronisationService.validatePathForSprintSync(project.getName(), synchronisationDto.getSprintSynchronisationPath());
            }
            catch (DomainException ex) {
                this.handlePathExceptions(ex, errors, "sprintSynchronisationPath", "This path is already in use in the Execution workspace.");
            }
        } else {
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"sprintSynchronisationPath", (String)REQUIRED, (String)ATTRIBUTE_CANNOT_BE_EMPTY);
        }
    }

    private void handlePathExceptions(DomainException ex, Errors errors, String relatedPath, String alreadyInUseMessage) {
        DomainException domainException = ex;
        Objects.requireNonNull(domainException);
        DomainException domainException2 = domainException;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RequiredFieldException.class, PathValidationDomainException.class, PathAlreadyInUseException.class, PathContainsASprintGroupException.class}, (Object)((Object)domainException2), 0)) {
            case 0: {
                RequiredFieldException requiredFieldException = (RequiredFieldException)domainException2;
                errors.rejectValue(relatedPath, REQUIRED, ATTRIBUTE_CANNOT_BE_EMPTY);
                break;
            }
            case 1: {
                PathValidationDomainException pathValidationDomainException = (PathValidationDomainException)domainException2;
                errors.rejectValue(relatedPath, "invalid path syntax", "Invalid path syntax.");
                break;
            }
            case 2: {
                PathAlreadyInUseException pathAlreadyInUseException = (PathAlreadyInUseException)domainException2;
                errors.rejectValue(relatedPath, "path already in use", alreadyInUseMessage);
                break;
            }
            case 3: {
                PathContainsASprintGroupException pathContainsASprintGroupException = (PathContainsASprintGroupException)domainException2;
                errors.rejectValue(relatedPath, "path contains a sprint group", "This path contains a sprint group. Please enter a path that does not contain a sprint group.");
                break;
            }
            default: {
                throw ex;
            }
        }
    }
}

