/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.service.finder;

import com.google.api.client.util.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import jirasync.com.atlassian.jira.rest.client.api.domain.BasicIssue;
import jirasync.com.atlassian.jira.rest.client.api.domain.Issue;
import jirasync.com.atlassian.jira.rest.client.api.domain.SearchResult;
import jirasync.io.atlassian.fugue.Iterables;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.squashtest.tm.plugin.jirasync.client.JiraClient;
import org.squashtest.tm.plugin.jirasync.domain.EpicIssueType;
import org.squashtest.tm.plugin.jirasync.domain.JiraRemoteSynchronisation;
import org.squashtest.tm.plugin.jirasync.domain.JiraSelectType;
import org.squashtest.tm.plugin.jirasync.domain.RemoteJiraIssueDto;
import org.squashtest.tm.plugin.jirasync.exception.MaxItemPerSyncException;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraAgileIssue;
import org.squashtest.tm.plugin.jirasync.repository.PluginRequirementDao;
import org.squashtest.tm.plugin.jirasync.service.ConfigurationManager;
import org.squashtest.tm.plugin.jirasync.service.finder.RemoteRequirementKeys;

public class RemoteRequirementFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteRequirementFinder.class);
    private final JiraRemoteSynchronisation jiraRemoteSynchronisation;
    private final JiraClient jiraClient;
    private final PluginRequirementDao pluginRequirementDao;
    private final ConfigurationManager configurationManager;
    private final Environment environment;

    RemoteRequirementFinder(JiraRemoteSynchronisation jiraRemoteSynchronisation, JiraClient jiraClient, PluginRequirementDao pluginRequirementDao, ConfigurationManager configurationManager, Environment environment) {
        this.jiraRemoteSynchronisation = Objects.requireNonNull(jiraRemoteSynchronisation);
        this.jiraClient = Objects.requireNonNull(jiraClient);
        this.pluginRequirementDao = Objects.requireNonNull(pluginRequirementDao);
        this.configurationManager = Objects.requireNonNull(configurationManager);
        this.environment = environment;
    }

    public RemoteRequirementKeys findRemoteRequirementKeys() {
        RemoteRequirementKeys keys = new RemoteRequirementKeys();
        boolean isSprintSynchro = false;
        String filter = this.computeJQL(this.jiraRemoteSynchronisation, this.jiraClient, isSprintSynchro);
        Map<String, Date> squashKnownIssueKeyAndDate = this.pluginRequirementDao.findKnownIssueKeyAndDate(this.jiraRemoteSynchronisation);
        int batchSize = this.configurationManager.getBatchSize();
        if (this.jiraClient.isJiraCloudServer()) {
            this.fetchAndProcessIssuesCloud(filter, batchSize, keys, squashKnownIssueKeyAndDate, this.jiraRemoteSynchronisation);
        } else {
            this.fetchAndProcessIssues(filter, batchSize, keys, squashKnownIssueKeyAndDate, this.jiraRemoteSynchronisation);
        }
        squashKnownIssueKeyAndDate.forEach((currentIssueKey, currentIssueDate) -> keys.addUnprocessed((String)currentIssueKey));
        return keys;
    }

    private void fetchAndProcessIssues(String filter, int batchSize, RemoteRequirementKeys keys, Map<String, Date> squashKnownIssueKeyAndDate, JiraRemoteSynchronisation jiraRemoteSynchronisation) {
        int total;
        int increment;
        int processed = 0;
        do {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Fetching from JIRA DC : {} for remote synchronisation {}. Fetching {} issues, from {}.", new Object[]{jiraRemoteSynchronisation.getServer().getUrl(), jiraRemoteSynchronisation, batchSize, processed});
            }
            SearchResult res = this.jiraClient.getIssueForModificationChecking(filter, processed, batchSize).claim();
            total = res.getTotal();
            this.processFetchedIssues(res.getIssues(), keys, squashKnownIssueKeyAndDate, jiraRemoteSynchronisation);
        } while ((processed += (increment = Math.min(batchSize, total - processed))) < total);
    }

    private void fetchAndProcessIssuesCloud(String filter, int batchSize, RemoteRequirementKeys keys, Map<String, Date> squashKnownIssueKeyAndDate, JiraRemoteSynchronisation jiraRemoteSynchronisation) {
        SearchResult res;
        String nextPageToken = null;
        do {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Fetching from JIRA Cloud : {} for remote synchronisation {}. Fetching {} issues with nextPageToken={}.", new Object[]{jiraRemoteSynchronisation.getServer().getUrl(), jiraRemoteSynchronisation, batchSize, nextPageToken});
            }
            res = this.jiraClient.getIssueForModificationCheckingCloud(filter, nextPageToken, batchSize).claim();
            this.processFetchedIssues(res.getIssues(), keys, squashKnownIssueKeyAndDate, jiraRemoteSynchronisation);
        } while ((nextPageToken = res.getNextPageToken()) != null);
    }

    private void processFetchedIssues(Iterable<Issue> issues, RemoteRequirementKeys keys, Map<String, Date> squashKnownIssueKeyAndDate, JiraRemoteSynchronisation jiraRemoteSynchronisation) {
        Map<String, DateTime> jiraIssuesKeyAndDate = StreamSupport.stream(issues.spliterator(), false).collect(Collectors.toMap(BasicIssue::getKey, Issue::getUpdateDate));
        List<String> epicIssueKeys = this.filterEpicIssueKeys(issues);
        List<String> highLevelIssueKeys = this.pluginRequirementDao.getHighLevelIssueKeys(jiraIssuesKeyAndDate.keySet(), jiraRemoteSynchronisation.getId());
        jiraIssuesKeyAndDate.forEach((jiraIssueKey, jiraIssueDate) -> {
            if (squashKnownIssueKeyAndDate.containsKey(jiraIssueKey)) {
                this.checkUpdateIsNeeded(keys, squashKnownIssueKeyAndDate, epicIssueKeys, (String)jiraIssueKey, (DateTime)jiraIssueDate, highLevelIssueKeys);
            } else {
                this.addIssueKeyToCreate(keys, (String)jiraIssueKey);
            }
            keys.addKnown((String)jiraIssueKey);
            squashKnownIssueKeyAndDate.remove(jiraIssueKey);
        });
    }

    public RemoteRequirementKeys findRemoteSprintRequirementKeys(Map<String, DateTime> jiraIssuesKeyAndDateInBoard, Set<JiraAgileIssue> agileIssuesInSprint, long squashSprintId) {
        RemoteRequirementKeys keys = new RemoteRequirementKeys();
        Map<String, Date> squashKnownIssueKeyAndDate = this.pluginRequirementDao.findSprintRequirementKnownIssueKeyAndDate(this.jiraRemoteSynchronisation, squashSprintId);
        Set issueKeysInSprint = agileIssuesInSprint.stream().map(JiraAgileIssue::getKey).collect(Collectors.toSet());
        Map<String, DateTime> jiraIssuesKeyAndDateInSprint = jiraIssuesKeyAndDateInBoard.entrySet().stream().filter(entry -> issueKeysInSprint.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        jiraIssuesKeyAndDateInSprint.forEach((jiraIssueKey, jiraIssueDate) -> {
            if (squashKnownIssueKeyAndDate.containsKey(jiraIssueKey)) {
                this.checkUpdateIsNeeded(keys, squashKnownIssueKeyAndDate, (String)jiraIssueKey, (DateTime)jiraIssueDate);
            } else {
                this.addIssueKeyToCreate(keys, (String)jiraIssueKey);
            }
            keys.addKnown((String)jiraIssueKey);
            squashKnownIssueKeyAndDate.remove(jiraIssueKey);
        });
        squashKnownIssueKeyAndDate.forEach((currentIssueKey, currentIssueDate) -> keys.addUnprocessed((String)currentIssueKey));
        return keys;
    }

    private void addIssueKeyToCreate(RemoteRequirementKeys keys, String jiraIssueKey) {
        if (LOGGER.isTraceEnabled()) {
            String message = String.format("The issue %s is not present in SquashTM database for synchronisation %s. Will sync it!", jiraIssueKey, this.jiraRemoteSynchronisation);
            LOGGER.trace(message);
        }
        keys.addToCreate(jiraIssueKey);
    }

    private void checkUpdateIsNeeded(RemoteRequirementKeys keys, Map<String, Date> squashKnownIssueKeyAndDate, List<String> epicIssueKeys, String jiraIssueKey, DateTime jiraIssueDate, List<String> highLevelIssueKeys) {
        Date squashKnownIssueDate = squashKnownIssueKeyAndDate.get(jiraIssueKey);
        if (this.isUpdateNeeded(squashKnownIssueDate, epicIssueKeys, jiraIssueKey, jiraIssueDate, highLevelIssueKeys)) {
            this.addIssueKeyToUpdate(keys, jiraIssueKey, jiraIssueDate, squashKnownIssueDate);
        }
    }

    private void checkUpdateIsNeeded(RemoteRequirementKeys keys, Map<String, Date> squashKnownIssueKeyAndDate, String jiraIssueKey, DateTime jiraIssueDate) {
        Date squashKnownIssueDate = squashKnownIssueKeyAndDate.get(jiraIssueKey);
        if (this.isTimeDiffIsSuperiorToThreshold(jiraIssueDate, squashKnownIssueDate)) {
            this.addIssueKeyToUpdate(keys, jiraIssueKey, jiraIssueDate, squashKnownIssueDate);
        }
    }

    private void addIssueKeyToUpdate(RemoteRequirementKeys keys, String jiraIssueKey, DateTime jiraIssueDate, Date squashKnownIssueDate) {
        if (LOGGER.isTraceEnabled()) {
            String message = String.format("The issue %s is present in SquashTM database for synchronisation %s. Persisted modification date is %s, JIRA modification date is %s. Must resync the issue!", jiraIssueKey, this.jiraRemoteSynchronisation, jiraIssueDate, squashKnownIssueDate);
            LOGGER.trace(message);
        }
        keys.addToUpdate(jiraIssueKey);
    }

    private boolean isUpdateNeeded(Date squashKnownIssueDate, List<String> epicIssueKeys, String jiraIssueKey, DateTime jiraIssueDate, List<String> highLevelIssueKeys) {
        boolean diffIsSuperiorToThreshold = this.isTimeDiffIsSuperiorToThreshold(jiraIssueDate, squashKnownIssueDate);
        boolean isNotIssueTypeAndRequirementLevelCoincide = this.checkIssueTypeAndRequirementLevelNotCoincide(jiraIssueKey, epicIssueKeys, highLevelIssueKeys);
        return diffIsSuperiorToThreshold || isNotIssueTypeAndRequirementLevelCoincide;
    }

    private boolean checkIssueTypeAndRequirementLevelNotCoincide(String jiraIssueKey, List<String> epicIssueKeys, List<String> highLevelIssueKeys) {
        if (epicIssueKeys.contains(jiraIssueKey)) {
            return !highLevelIssueKeys.contains(jiraIssueKey);
        }
        return highLevelIssueKeys.contains(jiraIssueKey);
    }

    private List<String> filterEpicIssueKeys(Iterable<Issue> issues) {
        List<String> epicNames = EpicIssueType.getAllEpicIssueTypes();
        return StreamSupport.stream(issues.spliterator(), false).filter(issue -> epicNames.contains(issue.getIssueType().getName())).map(BasicIssue::getKey).toList();
    }

    public List<RemoteJiraIssueDto> findRemoteJiraIssues(boolean isSprintSynchroSimulation) {
        String filter = this.computeJQL(this.jiraRemoteSynchronisation, this.jiraClient, isSprintSynchroSimulation);
        int batchSize = this.configurationManager.getBatchSize();
        return this.jiraClient.isJiraCloudServer() ? this.fetchIssuesInBatchesCloud(filter, batchSize) : this.fetchIssuesInBatches(filter, batchSize);
    }

    private List<RemoteJiraIssueDto> fetchIssuesInBatchesCloud(String filter, int batchSize) {
        SearchResult result;
        ArrayList<RemoteJiraIssueDto> jiraIssues = new ArrayList<RemoteJiraIssueDto>();
        String nextPageToken = null;
        do {
            result = this.jiraClient.getIssueForModificationCheckingCloud(filter, nextPageToken, batchSize).claim();
            jiraIssues.addAll(this.transformIssues(result.getIssues()));
        } while ((nextPageToken = result.getNextPageToken()) != null);
        return jiraIssues;
    }

    private List<RemoteJiraIssueDto> fetchIssuesInBatches(String filter, int batchSize) {
        int total;
        int increment;
        ArrayList<RemoteJiraIssueDto> jiraIssues = new ArrayList<RemoteJiraIssueDto>();
        int processed = 0;
        do {
            SearchResult result = this.jiraClient.getIssueForModificationChecking(filter, processed, batchSize).claim();
            total = result.getTotal();
            increment = Math.min(batchSize, total - processed);
            jiraIssues.addAll(this.transformIssues(result.getIssues()));
        } while ((processed += increment) < total);
        return jiraIssues;
    }

    private List<RemoteJiraIssueDto> transformIssues(Iterable<Issue> issues) {
        return StreamSupport.stream(issues.spliterator(), false).map(issue -> {
            String url = StringUtils.appendIfMissing((String)this.jiraRemoteSynchronisation.getServer().getUrl(), (CharSequence)"/", (CharSequence[])new CharSequence[0]) + "browse/" + issue.getKey();
            return new RemoteJiraIssueDto(issue.getId(), issue.getKey(), issue.getSummary(), url);
        }).toList();
    }

    public Set<Issue> findBoardRemoteJiraIssuesWithSprintAdditionalJQL() {
        String jql = this.computeJQLForBoard(this.jiraClient, this.jiraRemoteSynchronisation.getSprintAdditionalJQL(), this.jiraRemoteSynchronisation.getSelectValue());
        return this.jiraClient.isJiraCloudServer() ? this.fetchJiraIssuesFromJQLCloud(jql) : this.fetchJiraIssuesFromJQL(jql);
    }

    private Set<Issue> fetchJiraIssuesFromJQLCloud(String filter) {
        SearchResult result;
        HashSet<Issue> jiraIssues = new HashSet<Issue>();
        String nextPageToken = null;
        int batchSize = this.configurationManager.getBatchSize();
        do {
            result = this.jiraClient.getIssueForModificationCheckingCloud(filter, nextPageToken, batchSize).claim();
            jiraIssues.addAll(Lists.newArrayList(result.getIssues()));
        } while ((nextPageToken = result.getNextPageToken()) != null);
        return jiraIssues;
    }

    private Set<Issue> fetchJiraIssuesFromJQL(String filter) {
        int total;
        int increment;
        HashSet<Issue> jiraIssues = new HashSet<Issue>();
        int processed = 0;
        int batchSize = this.configurationManager.getBatchSize();
        do {
            SearchResult result = this.jiraClient.getIssueForModificationChecking(filter, processed, batchSize).claim();
            total = result.getTotal();
            increment = Math.min(batchSize, total - processed);
            jiraIssues.addAll(Lists.newArrayList(result.getIssues()));
        } while ((processed += increment) < total);
        return jiraIssues;
    }

    private String computeJQL(JiraRemoteSynchronisation remoteSynchronisation, JiraClient jiraClient, boolean isSprintSynchroSimulation) {
        JiraSelectType jiraSelectType = (JiraSelectType)EnumUtils.getEnum(JiraSelectType.class, (String)remoteSynchronisation.getSelectType());
        Object jql = "";
        switch (jiraSelectType) {
            case BOARD: {
                String additionalJQL = isSprintSynchroSimulation ? remoteSynchronisation.getSprintAdditionalJQL() : remoteSynchronisation.getAdditionalJQL();
                jql = (String)jql + this.computeJQLForBoard(jiraClient, additionalJQL, remoteSynchronisation.getSelectValue());
                break;
            }
            case FILTER: {
                String filterName = remoteSynchronisation.getSelectValue();
                filterName = filterName.replace("'", "\\'");
                filterName = StringUtils.overlay((String)"''", (String)filterName, (int)1, (int)1);
                jql = (String)jql + "filter=" + filterName;
                break;
            }
            case QUERY: {
                jql = (String)jql + remoteSynchronisation.getSelectValue();
                break;
            }
            default: {
                throw new IllegalArgumentException("Programmatic error, the select type " + String.valueOf((Object)jiraSelectType) + "isn't handled by this plugin.");
            }
        }
        if (remoteSynchronisation.isRestrictedToActiveSprint() || isSprintSynchroSimulation && remoteSynchronisation.isSprintRestrictedToActiveSprint()) {
            jql = "sprint IN openSprints() AND (" + this.removeOrderByIfExists((String)jql) + ")";
        }
        return jql;
    }

    private String computeJQLForBoard(JiraClient jiraClient, String additionalJQL, String boardName) {
        String jql = jiraClient.getFilterForBoard(boardName);
        if (StringUtils.isNotBlank((CharSequence)additionalJQL)) {
            jql = String.format("(%s) AND (%s)", this.removeOrderByIfExists(additionalJQL), this.removeOrderByIfExists(jql));
        }
        return jql;
    }

    private boolean isTimeDiffIsSuperiorToThreshold(DateTime jiraIssueDate, Date squashKnownIssueDate) {
        long squashTime = squashKnownIssueDate.getTime();
        long jiraTime = jiraIssueDate.toDate().getTime();
        long diff = jiraTime - squashTime;
        return diff > 1000L;
    }

    private String removeOrderByIfExists(String jql) {
        return jql.toLowerCase().contains("order by") ? jql.split("(?i)ORDER BY")[0] : jql;
    }

    public void checkIfMaxNumberOfIssuesInPerimeterExceeded(boolean isSprintSynchroSimulation) {
        Integer maxItemPerSync = this.getMaxItemPerSync();
        if (Objects.nonNull(maxItemPerSync)) {
            String filter = this.computeJQL(this.jiraRemoteSynchronisation, this.jiraClient, isSprintSynchroSimulation);
            boolean isJiraCloudServer = this.jiraClient.isJiraCloudServer();
            int nbTickets = 0;
            if (isJiraCloudServer) {
                SearchResult result;
                String nextPageToken = null;
                do {
                    result = this.jiraClient.getIssueForModificationCheckingCloud(filter, nextPageToken, 501).claim();
                    nbTickets += Iterables.size(result.getIssues());
                } while ((nextPageToken = result.getNextPageToken()) != null);
            } else {
                SearchResult result = this.jiraClient.getIssueForModificationChecking(filter, 0, 1).claim();
                nbTickets = result.getTotal();
            }
            if (nbTickets > maxItemPerSync) {
                this.throwMaxItemPerSyncException(nbTickets, maxItemPerSync);
            }
        }
    }

    private void throwMaxItemPerSyncException(int currentCount, int maxItemPerSync) {
        LOGGER.error("Too many Jira tickets in synchronisation scope: {} tickets. Max number allowed: {}", (Object)currentCount, (Object)maxItemPerSync);
        throw new MaxItemPerSyncException(currentCount, maxItemPerSync);
    }

    private Integer getMaxItemPerSync() {
        String property = this.environment.getProperty("squash.external.synchronisation.max-items-per-sync");
        Integer maxItemPerSync = null;
        if (StringUtils.isNotBlank((CharSequence)property)) {
            try {
                maxItemPerSync = Integer.parseInt(property);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.warn("Impossible to parse the property 'squash.external.synchronisation.max-items-per-sync' as a number. Please provide a valid value.");
            }
        }
        return maxItemPerSync;
    }
}

