/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.jsonext;

import java.text.ParseException;
import java.util.Date;
import jirasync.com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import jirasync.org.codehaus.jettison.json.JSONException;
import jirasync.org.codehaus.jettison.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.core.foundation.lang.DateUtils;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraSprint;

public class JiraSprintParser
implements JsonObjectParser<JiraSprint> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JiraSprintParser.class);

    @Override
    public JiraSprint parse(JSONObject json) throws JSONException {
        JiraSprint jiraSprint = new JiraSprint();
        jiraSprint.setId(json.getLong("id"));
        jiraSprint.setName(json.getString("name"));
        jiraSprint.setState(json.getString("state"));
        Date completeDate = this.parseDate(jiraSprint, json, "endDate");
        jiraSprint.setCompleteDate(completeDate);
        Date startDate = this.parseDate(jiraSprint, json, "startDate");
        jiraSprint.setStartDate(startDate);
        return jiraSprint;
    }

    private Date parseDate(JiraSprint sprint, JSONObject json, String pptName) {
        String strDate = null;
        Date res = null;
        try {
            strDate = json.optString(pptName);
            res = StringUtils.isBlank((CharSequence)strDate) ? null : DateUtils.parseIso8601Date((String)strDate);
        }
        catch (ParseException parseException) {
            LOGGER.debug("date for sprint {}({}) is incorrect : {}", new Object[]{sprint.getName(), sprint.getId(), strDate});
            res = null;
        }
        return res;
    }
}

