/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.domain.execplan;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import jirasync.com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import jirasync.org.codehaus.jettison.json.JSONException;
import jirasync.org.codehaus.jettison.json.JSONObject;
import org.springframework.web.util.HtmlUtils;

public class ExecplanIssue {
    public static final String EXECPLAN_REQUIRED_FIELDS = "self,key,status,assignee,summary,issuetype";
    private String key = null;
    private String url = null;
    private String browseUrl = null;
    private String status = null;
    private String summary = null;
    private String issueType = null;
    private String assignee = null;
    private Boolean syncedAsFeature = null;
    private Boolean syncedAsIssue = null;
    private Boolean featureIsCovered = null;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecplanIssue that = (ExecplanIssue)o;
        return this.key != null ? this.key.equals(that.key) : that.key == null;
    }

    public int hashCode() {
        return this.key != null ? this.key.hashCode() : 0;
    }

    public ExecplanIssue() {
    }

    public ExecplanIssue(String key) {
        this.key = key;
    }

    public ExecplanIssue(String key, String url, String status, String summary, String issueType, String assignee) {
        this.key = key;
        this.url = url;
        this.status = status;
        this.summary = summary;
        this.issueType = issueType;
        this.assignee = assignee;
    }

    public ExecplanIssue(String key, Boolean syncedAsFeature, Boolean syncedAsIssue, Boolean featureIsCovered) {
        this.key = key;
        this.syncedAsFeature = syncedAsFeature;
        this.syncedAsIssue = syncedAsIssue;
        this.featureIsCovered = featureIsCovered;
    }

    @Deprecated
    public ExecplanIssue(String key, String url, String status) {
        this.key = key;
        this.url = url;
        this.status = status;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getBrowseUrl() {
        return this.browseUrl;
    }

    public void setBrowseUrl(String browseUrl) {
        this.browseUrl = browseUrl;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @JsonSerialize(using=HtmlEscaper.class)
    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getIssueType() {
        return this.issueType;
    }

    public void setIssueType(String issueType) {
        this.issueType = issueType;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public Boolean getSyncedAsFeature() {
        return this.syncedAsFeature;
    }

    public void setSyncedAsFeature(Boolean syncedAsFeature) {
        this.syncedAsFeature = syncedAsFeature;
    }

    public Boolean getSyncedAsIssue() {
        return this.syncedAsIssue;
    }

    public void setSyncedAsIssue(Boolean syncedAsIssue) {
        this.syncedAsIssue = syncedAsIssue;
    }

    public Boolean getFeatureIsCovered() {
        return this.featureIsCovered;
    }

    public void setFeatureIsCovered(Boolean featureIsCovered) {
        this.featureIsCovered = featureIsCovered;
    }

    public void resetSyncFlags() {
        this.syncedAsFeature = Boolean.FALSE;
        this.syncedAsIssue = Boolean.FALSE;
        this.featureIsCovered = Boolean.FALSE;
    }

    public void mergeWith(ExecplanIssue other) {
        if (this.url == null) {
            this.url = other.url;
        }
        if (this.browseUrl == null) {
            this.browseUrl = other.browseUrl;
        }
        if (this.status == null) {
            this.status = other.status;
        }
        if (this.summary == null) {
            this.summary = other.summary;
        }
        if (this.issueType == null) {
            this.issueType = other.issueType;
        }
        if (this.assignee == null) {
            this.assignee = other.assignee;
        }
        if (this.syncedAsFeature == null) {
            this.syncedAsFeature = other.syncedAsFeature;
        }
        if (this.syncedAsIssue == null) {
            this.syncedAsIssue = other.syncedAsIssue;
        }
        if (this.featureIsCovered == null) {
            this.featureIsCovered = other.featureIsCovered;
        }
    }

    public static final class HtmlEscaper
    extends JsonSerializer<String> {
        public void serialize(String value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
            gen.writeString(HtmlUtils.htmlEscape((String)value));
        }
    }

    public static final class Parser
    implements JsonObjectParser<ExecplanIssue> {
        @Override
        public ExecplanIssue parse(JSONObject json) throws JSONException {
            String self = json.getString("self");
            String key = json.getString("key");
            JSONObject fields = json.getJSONObject("fields");
            String summary = fields.optString("summary");
            String status = this.nestedAttribute(fields, "status", "name");
            String issueType = this.nestedAttribute(fields, "issuetype", "name");
            String assignee = this.nestedAttribute(fields, "assignee", "name");
            return new ExecplanIssue(key, self, status, summary, issueType, assignee);
        }

        private String nestedAttribute(JSONObject json, String attribute, String nested) {
            JSONObject attr = json.optJSONObject(attribute);
            if (attr == null) {
                return null;
            }
            return attr.optString(nested);
        }
    }
}

