/*
 * Decompiled with CFR 0.152.
 */
package jirasync.com.atlassian.jira.rest.client.internal.json;

import java.net.URI;
import jirasync.com.atlassian.jira.rest.client.api.domain.Attachment;
import jirasync.com.atlassian.jira.rest.client.api.domain.BasicUser;
import jirasync.com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import jirasync.org.codehaus.jettison.json.JSONException;
import jirasync.org.codehaus.jettison.json.JSONObject;
import org.joda.time.DateTime;

public class AttachmentJsonParser
implements JsonObjectParser<Attachment> {
    private static final String THUMBNAIL = "thumbnail";

    @Override
    public Attachment parse(JSONObject json) throws JSONException {
        URI selfUri = JsonParseUtil.getSelfUri(json);
        String filename = json.getString("filename");
        BasicUser author = JsonParseUtil.parseBasicUser(json.optJSONObject("author"));
        DateTime creationDate = JsonParseUtil.parseDateTime(json.getString("created"));
        int size = json.getInt("size");
        String mimeType = json.getString("mimeType");
        URI contentURI = JsonParseUtil.parseURI(json.getString("content"));
        URI thumbnailURI = JsonParseUtil.parseOptionalURI(json, THUMBNAIL);
        return new Attachment(selfUri, filename, author, creationDate, size, mimeType, contentURI, thumbnailURI);
    }
}

