/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.validators;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.squashtest.tm.domain.artificialintelligence.AiUsageName;
import org.squashtest.tm.exception.artificialintelligence.server.AiServerInvalidHandlebarsTemplateException;
import org.squashtest.tm.service.internal.artificialintelligence.server.custom.RequestPayloadGenerator;

@Service
public class HelpValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(HelpValidator.class);
    private static final String AI_USAGE = "aiUsage";
    private static final String INVALID_VALUE = "Invalid value";

    public void validateAttributes(String attribute, Errors errors) {
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)attribute, (String)"required", (String)"This attribute can't be empty");
    }

    public void validateUrl(String strUrl, Errors errors) {
        try {
            new URL(strUrl);
        }
        catch (MalformedURLException malformedURLException) {
            errors.rejectValue("url", INVALID_VALUE, "Malformed Url.");
        }
    }

    public void validateAiUsage(BindingResult validation, String aiUsage) {
        if (StringUtils.isBlank((CharSequence)aiUsage)) {
            this.validateAttributes(AI_USAGE, (Errors)validation);
        } else {
            boolean isValidAiUsage = Arrays.stream(AiUsageName.values()).anyMatch(enumValue -> enumValue.name().equals(aiUsage));
            if (!isValidAiUsage) {
                validation.rejectValue(AI_USAGE, INVALID_VALUE, String.format("The aiUsage %s is not a valid value", aiUsage));
            }
        }
    }

    public void validateHandlebarsTemplate(Errors errors, String fieldName, String template) {
        try {
            RequestPayloadGenerator.generate((String)template, (String)fieldName, new ArrayList(), (String)"");
        }
        catch (AiServerInvalidHandlebarsTemplateException e) {
            String message = String.format("The %s is not a valid Handlebars template.", fieldName);
            LOGGER.error(message, (Throwable)e);
            errors.rejectValue(fieldName, INVALID_VALUE, message);
        }
    }
}

