/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.validators;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Date;
import org.springframework.stereotype.Service;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.users.ApiTokenPermission;
import org.squashtest.tm.plugin.rest.jackson.model.ApiTokenRestDto;

@Service
public class ApiTokenValidator
implements Validator {
    private static final String EXPIRY_DATE = "expiryDate";
    private static final String INVALID_VALUE = "Invalid value";
    private static final String NAME = "name";
    private static final String NO_EMPTY_ATTRIBUTE = "This attribute can't be empty";
    private static final String PERMISSIONS = "permissions";
    private static final String REQUIRED = "Required";

    public boolean supports(Class<?> clazz) {
        return ApiTokenRestDto.class.equals(clazz);
    }

    public void validate(Object target, Errors errors) {
        ApiTokenRestDto apiTokenRestDto = (ApiTokenRestDto)target;
        boolean permissionsExist = Arrays.asList(ApiTokenPermission.READ.toString(), ApiTokenPermission.READ_WRITE.toString()).contains(apiTokenRestDto.getPermissions());
        if (!permissionsExist && apiTokenRestDto.getPermissions() != null) {
            errors.rejectValue(PERMISSIONS, INVALID_VALUE, "Permissions must be either 'READ' or 'READ_WRITE'.");
        }
        if (ApiTokenValidator.isDateBeforeTomorrow(apiTokenRestDto.getExpiryDate())) {
            errors.rejectValue(EXPIRY_DATE, INVALID_VALUE, "Expiry date cannot be set before tomorrow.");
        }
        if (ApiTokenValidator.isDateAfterOneYearFromToday(apiTokenRestDto.getExpiryDate())) {
            errors.rejectValue(EXPIRY_DATE, INVALID_VALUE, "Expiry date cannot be set later one year from today.");
        }
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)NAME, (String)REQUIRED, (String)NO_EMPTY_ATTRIBUTE);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)PERMISSIONS, (String)REQUIRED, (String)NO_EMPTY_ATTRIBUTE);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)EXPIRY_DATE, (String)REQUIRED, (String)NO_EMPTY_ATTRIBUTE);
    }

    private static boolean isDateAfterOneYearFromToday(Date givenDate) {
        LocalDate localGivenDate = givenDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate today = LocalDate.now();
        LocalDate oneYearFromToday = today.plusYears(1L);
        return localGivenDate.isAfter(oneYearFromToday);
    }

    private static boolean isDateBeforeTomorrow(Date givenDate) {
        LocalDate localGivenDate = givenDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate tomorrow = LocalDate.now().plusDays(1L);
        return localGivenDate.isBefore(tomorrow);
    }
}

