/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.validators;

import jakarta.inject.Inject;
import jakarta.persistence.EntityNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.squashtest.tm.core.foundation.exception.ActionException;
import org.squashtest.tm.domain.aiserver.AiProvider;
import org.squashtest.tm.domain.aiserver.AiServer;
import org.squashtest.tm.exception.artificialintelligence.server.MalformedJsonPathException;
import org.squashtest.tm.plugin.rest.admin.jackson.model.AiServerDto;
import org.squashtest.tm.plugin.rest.admin.jackson.model.AiServerOptionsDto;
import org.squashtest.tm.plugin.rest.admin.jackson.model.LegacyAiServerDto;
import org.squashtest.tm.plugin.rest.admin.service.RestAiServerService;
import org.squashtest.tm.plugin.rest.admin.validators.HelpValidator;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.service.artificialintelligence.server.AiServerManagerService;
import org.squashtest.tm.service.internal.repository.AiServerDao;
import org.squashtest.tm.service.jsonpathextractor.JsonPathExtractor;

@Component
public class AiServerValidator
implements Validator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AiServerValidator.class);
    private static final String POST_AI_SERVER = "post-ai-server";
    private static final String PATCH_AI_SERVER = "patch-ai-server";
    private static final String INVALID_VALUE = "Invalid value";
    private static final String OPTIONS_PREFIX_FORMATTER = "options.%s";
    private static final String REQUIRED = "required";
    private static final String PROJECT_ID = "projectId";
    private static final String REGION = "region";
    private static final String GENERATED_TEXT_JSON_PATH = "generatedTextJsonPath";
    private static final String PAYLOAD_TEMPLATE = "payloadTemplate";
    private static final int HTTP_HEADERS_MAX_NUMBER = 5;
    @Inject
    private HelpValidator helpValidator;
    @Inject
    private RestAiServerService aiServerService;
    @Inject
    private JsonPathExtractor jsonPathExtractor;
    @Inject
    private AiServerManagerService aiServerManagerService;
    @Inject
    private AiServerDao aiServerDao;

    public boolean supports(Class<?> aClass) {
        return LegacyAiServerDto.class.equals(aClass);
    }

    public void validate(Object target, Errors errors) {
    }

    public void aiServerLegacyPostValidator(LegacyAiServerDto aiServerDto) throws BindException {
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)aiServerDto, POST_AI_SERVER);
        if (aiServerDto.getId() != null) {
            validation.rejectValue("id", "generated value", "This attribute is generated by database. ");
        }
        this.validateName((Errors)validation, aiServerDto.getName());
        this.validateUrl((Errors)validation, aiServerDto.getUrl());
        if (validation.hasErrors()) {
            errors.add(validation);
        }
        ErrorHandlerHelper.throwIfError((Object)aiServerDto, errors, (String)POST_AI_SERVER);
    }

    public void aiServerLegacyPatchValidator(Long aiServerId, LegacyAiServerDto aiServerDto) throws BindException {
        Optional aiServer;
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)aiServerDto, PATCH_AI_SERVER);
        try {
            this.aiServerService.findAiServerById(aiServerId);
            this.validateIsLegacyAiServer(aiServerId);
        }
        catch (EntityNotFoundException e) {
            String message = String.format("No entity known for type aiServer and id %d", aiServerId);
            validation.rejectValue("id", "invalid id", message);
            LOGGER.error(message, (Object)aiServerId, (Object)e);
        }
        if (aiServerDto.getName() != null && (aiServer = this.aiServerDao.findById((Object)aiServerId)).isPresent() && !((AiServer)aiServer.get()).getName().equals(aiServerDto.getName())) {
            this.validateName((Errors)validation, aiServerDto.getName());
        }
        if (aiServerDto.getUrl() != null) {
            this.validateUrl((Errors)validation, aiServerDto.getUrl());
        }
        if (aiServerDto.getJsonPath() != null) {
            this.validateJsonPathAiServer((Errors)validation, aiServerDto);
        }
        if (validation.hasErrors()) {
            errors.add(validation);
        }
        ErrorHandlerHelper.throwIfError((Object)aiServerDto, errors, (String)PATCH_AI_SERVER);
    }

    private void validateJsonPathAiServer(Errors errors, LegacyAiServerDto aiServerDto) {
        if (StringUtils.isBlank((CharSequence)aiServerDto.getJsonPath())) {
            this.helpValidator.validateAttributes("jsonPath", errors);
        } else if (!this.jsonPathExtractor.isPathValid(aiServerDto.getJsonPath()) && !aiServerDto.getJsonPath().isEmpty()) {
            throw new MalformedJsonPathException();
        }
    }

    public void validateIsLegacyAiServer(Long aiServerId) {
        AiServer aiServer = (AiServer)this.aiServerDao.getReferenceById((Object)aiServerId);
        if (!AiProvider.NONE.equals((Object)aiServer.getProvider())) {
            throw new ActionException("This endpoint is only available for legacy AI servers.");
        }
    }

    public void aiServerPostValidator(AiServerDto aiServerDto) throws BindException {
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)aiServerDto, POST_AI_SERVER);
        if (aiServerDto.getId() != null) {
            validation.rejectValue("id", "generated value", "This attribute is generated by database. ");
        }
        this.validateName((Errors)validation, aiServerDto.getName());
        if (!AiProvider.GOOGLE_VERTEX_AI.name().equals(aiServerDto.getProvider())) {
            this.validateUrl((Errors)validation, aiServerDto.getUrl());
        }
        this.validateProvider((Errors)validation, aiServerDto.getProvider());
        this.validateModelName((Errors)validation, aiServerDto.getModelName(), aiServerDto.getProvider());
        this.validateOptions((Errors)validation, aiServerDto.getOptions(), aiServerDto.getProvider());
        if (validation.hasErrors()) {
            errors.add(validation);
        }
        ErrorHandlerHelper.throwIfError((Object)aiServerDto, errors, (String)POST_AI_SERVER);
    }

    public void aiServerPatchValidator(Long aiServerId, AiServerDto aiServerDto) throws BindException {
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)aiServerDto, PATCH_AI_SERVER);
        try {
            boolean isNewProvider;
            String provider;
            AiServer aiServer = this.aiServerService.findAiServerById(aiServerId);
            this.checkAndRejectIfLegacyAiServer((BindingResult)validation, aiServer);
            if (Objects.nonNull(aiServerDto.getProvider())) {
                this.validateProvider((Errors)validation, aiServerDto.getProvider());
                provider = aiServerDto.getProvider();
                isNewProvider = !aiServer.getProvider().name().equals(provider);
            } else {
                provider = aiServer.getProvider().name();
                isNewProvider = false;
            }
            if (aiServerDto.getName() != null && !aiServer.getName().equals(aiServerDto.getName())) {
                this.validateName((Errors)validation, aiServerDto.getName());
            }
            if (Objects.nonNull(aiServerDto.getUrl()) && !AiProvider.GOOGLE_VERTEX_AI.name().equals(provider)) {
                this.validateUrl((Errors)validation, aiServerDto.getUrl());
            }
            if (isNewProvider || Objects.nonNull(aiServerDto.getModelName())) {
                this.validateModelName((Errors)validation, aiServerDto.getModelName(), provider);
            }
            if (isNewProvider) {
                this.validateOptions((Errors)validation, aiServerDto.getOptions(), provider);
            } else if (Objects.nonNull(aiServerDto.getOptions())) {
                this.validateOptionsForPatch((Errors)validation, aiServerDto.getOptions(), provider);
            }
        }
        catch (EntityNotFoundException e) {
            String message = String.format("No entity known for type aiServer and id %d", aiServerId);
            validation.rejectValue("id", "invalid id", message);
            LOGGER.error(message, (Object)aiServerId, (Object)e);
        }
        if (validation.hasErrors()) {
            errors.add(validation);
        }
        ErrorHandlerHelper.throwIfError((Object)aiServerDto, errors, (String)PATCH_AI_SERVER);
    }

    private void checkAndRejectIfLegacyAiServer(BindingResult validation, AiServer aiServer) {
        if (AiProvider.NONE.equals((Object)aiServer.getProvider())) {
            validation.rejectValue("id", INVALID_VALUE, "This endpoint is not available for legacy AI servers.");
        }
    }

    private void validateName(Errors errors, String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            this.helpValidator.validateAttributes("name", errors);
        } else if (this.aiServerManagerService.nameInUse(name)) {
            errors.rejectValue("name", INVALID_VALUE, "The name is already used by another server. ");
        }
    }

    private void validateUrl(Errors errors, String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            this.helpValidator.validateAttributes("url", errors);
        } else {
            this.helpValidator.validateUrl(url, errors);
        }
    }

    private void validateProvider(Errors errors, String provider) {
        if (StringUtils.isBlank((CharSequence)provider)) {
            this.helpValidator.validateAttributes("provider", errors);
        } else if (!this.isValidAiProvider(provider)) {
            errors.rejectValue("provider", INVALID_VALUE, String.format("The provider %s is not a valid provider. Available providers are: ANTHROPIC, AZURE_OPEN_AI, CUSTOM, GOOGLE_VERTEX_AI, MISTRAL_AI, OPEN_AI", provider));
        }
    }

    private boolean isValidAiProvider(String provider) {
        if (AiProvider.NONE.name().equals(provider)) {
            return false;
        }
        return Arrays.stream(AiProvider.values()).anyMatch(enumValue -> enumValue.name().equals(provider));
    }

    private void validateModelName(Errors errors, String modelName, String provider) {
        if (StringUtils.isBlank((CharSequence)modelName) && !this.isCustomAiServer(provider)) {
            this.helpValidator.validateAttributes("modelName", errors);
        }
        if (StringUtils.isNotBlank((CharSequence)modelName) && this.isCustomAiServer(provider)) {
            errors.rejectValue("modelName", INVALID_VALUE, "The model name field should not be provided for custom ai server. To indicate the model name, please use the payload template inside the options of the AI server.");
        }
    }

    private boolean isCustomAiServer(String provider) {
        return AiProvider.CUSTOM.name().equals(provider);
    }

    private void validateOptions(Errors errors, AiServerOptionsDto options, String provider) {
        if (this.isCustomAiServer(provider)) {
            this.validateCustomAiServerOptions(errors, options);
        } else {
            this.validateAiServerOptions(errors, options, provider);
        }
    }

    private void validateOptionsForPatch(Errors errors, AiServerOptionsDto options, String provider) {
        if (this.isCustomAiServer(provider)) {
            this.validateCustomAiServerOptionsForPatch(errors, options);
        } else {
            this.validateAiServerOptionsForPatch(errors, options, provider);
        }
    }

    private void validateCustomAiServerOptions(Errors errors, AiServerOptionsDto options) {
        this.validateGeneratedTextJsonPath(errors, options);
        this.validatePayloadTemplate(errors, options);
        if (Objects.nonNull(options)) {
            this.checkInvalidCustomAiServerOptions(errors, options);
            this.validateHttpHeaders(errors, options);
        }
    }

    private void validateCustomAiServerOptionsForPatch(Errors errors, AiServerOptionsDto options) {
        this.validateGeneratedTextJsonPathForPatch(errors, options);
        this.validatePayloadTemplateForPatch(errors, options);
        this.checkInvalidCustomAiServerOptions(errors, options);
        this.validateHttpHeaders(errors, options);
    }

    private void checkInvalidCustomAiServerOptions(Errors errors, AiServerOptionsDto options) {
        this.checkAndRejectInvalidOptionForCustomAiServer(errors, options.getTemperature(), "temperature");
        this.checkAndRejectInvalidOptionForCustomAiServer(errors, options.getTopP(), "topP");
        this.checkAndRejectInvalidOptionForCustomAiServer(errors, options.getRandomSeed(), "randomSeed");
        this.checkAndRejectInvalidOptionForCustomAiServer(errors, options.getSeed(), "seed");
        this.checkAndRejectInvalidOptionForCustomAiServer(errors, options.getMaxTokens(), "maxTokens");
        this.checkAndRejectInvalidOptionForCustomAiServer(errors, options.getMaxCompletionTokens(), "maxCompletionTokens");
        this.checkAndRejectInvalidOptionForCustomAiServer(errors, options.getMaxOutputTokens(), "maxOutputTokens");
        this.checkAndRejectInvalidOptionForCustomAiServer(errors, options.getReasoningEffort(), "reasoningEffort");
        this.checkAndRejectInvalidOptionForCustomAiServer(errors, options.getOrganizationId(), "organizationId");
        this.checkAndRejectInvalidOptionForCustomAiServer(errors, options.getApiVersion(), "apiVersion");
        this.checkAndRejectInvalidOptionForCustomAiServer(errors, options.getThinkingType(), "thinkingType");
        this.checkAndRejectInvalidOptionForCustomAiServer(errors, options.getThinkingBudgetTokens(), "thinkingBudgetTokens");
        this.checkAndRejectInvalidOptionForCustomAiServer(errors, options.getProjectId(), PROJECT_ID);
        this.checkAndRejectInvalidOptionForCustomAiServer(errors, options.getRegion(), REGION);
    }

    private void checkAndRejectInvalidOptionForCustomAiServer(Errors errors, Optional<?> targetOption, String fieldName) {
        if (this.checkOptionalIsNotNullOrEmpty(targetOption)) {
            errors.rejectValue(String.format(OPTIONS_PREFIX_FORMATTER, fieldName), INVALID_VALUE, "This option is not valid for custom AI servers.");
        }
    }

    private void validateHttpHeaders(Errors errors, AiServerOptionsDto options) {
        int i = 1;
        while (i <= 5) {
            this.validateHttpHeaderPair(errors, options, i);
            ++i;
        }
    }

    private void validateHttpHeaderPair(Errors errors, AiServerOptionsDto options, int index) {
        Optional<String> headerName = this.getHttpHeaderNameByIndex(options, index);
        Optional<String> headerValueTemplate = this.getHttpHeaderValueTemplateByIndex(options, index);
        this.validateHttpHeaderName(errors, headerName, index);
        this.validateHttpHeaderValueTemplate(errors, headerValueTemplate, headerName, index);
    }

    private void validateHttpHeaderName(Errors errors, Optional<String> httpHeaderName, int index) {
        if (this.checkOptionalIsNotNullOrEmpty(httpHeaderName) && StringUtils.isBlank((CharSequence)httpHeaderName.get())) {
            errors.rejectValue(String.format(OPTIONS_PREFIX_FORMATTER, "httpHeaderName" + index), REQUIRED, "The http header name can't be empty");
        }
    }

    private void validateHttpHeaderValueTemplate(Errors errors, Optional<String> httpHeaderValueTemplate, Optional<String> httpHeaderName, int index) {
        if (this.checkOptionalIsNotNullOrEmpty(httpHeaderValueTemplate)) {
            this.checkAndRejectHttpHeaderValueTemplateWithoutHttpHeaderName(errors, httpHeaderValueTemplate.get(), httpHeaderName, index);
        }
    }

    private void checkAndRejectHttpHeaderValueTemplateWithoutHttpHeaderName(Errors errors, String httpHeaderValueTemplate, Optional<String> httpHeaderName, int index) {
        if (this.isInvalidHttpHeaderValueTemplate(httpHeaderValueTemplate, httpHeaderName)) {
            errors.rejectValue(String.format(OPTIONS_PREFIX_FORMATTER, "httpHeaderValueTemplate" + index), REQUIRED, "The http header value template requires a corresponding http header name");
        }
    }

    private boolean isInvalidHttpHeaderValueTemplate(String httpHeaderValueTemplate, Optional<String> httpHeaderName) {
        if (StringUtils.isBlank((CharSequence)httpHeaderValueTemplate)) {
            return false;
        }
        return Objects.isNull(httpHeaderName) || httpHeaderName.isEmpty() || StringUtils.isBlank((CharSequence)httpHeaderName.get());
    }

    private void validateGeneratedTextJsonPath(Errors errors, AiServerOptionsDto options) {
        if (AiServerValidator.isEmptyGeneratedTextJsonPath(options)) {
            AiServerValidator.rejectEmptyGeneratedTextJsonPath(errors);
        } else if (!this.jsonPathExtractor.isPathValid(options.getGeneratedTextJsonPath().get())) {
            AiServerValidator.rejectInvalidGeneratedTextJsonPath(errors);
        }
    }

    private static boolean isEmptyGeneratedTextJsonPath(AiServerOptionsDto options) {
        return Objects.isNull(options) || Objects.isNull(options.getGeneratedTextJsonPath()) || options.getGeneratedTextJsonPath().isEmpty() || StringUtils.isBlank((CharSequence)options.getGeneratedTextJsonPath().get());
    }

    private void validateGeneratedTextJsonPathForPatch(Errors errors, AiServerOptionsDto options) {
        if (this.isEmptyGeneratedTextJsonPathForPatch(options)) {
            AiServerValidator.rejectEmptyGeneratedTextJsonPath(errors);
        } else if (this.checkOptionalIsNotNullOrEmpty(options.getGeneratedTextJsonPath()) && !this.jsonPathExtractor.isPathValid(options.getGeneratedTextJsonPath().get())) {
            AiServerValidator.rejectInvalidGeneratedTextJsonPath(errors);
        }
    }

    private boolean isEmptyGeneratedTextJsonPathForPatch(AiServerOptionsDto options) {
        return Objects.nonNull(options.getGeneratedTextJsonPath()) && options.getGeneratedTextJsonPath().isEmpty() || this.checkOptionalIsNotNullOrEmpty(options.getGeneratedTextJsonPath()) && StringUtils.isBlank((CharSequence)options.getGeneratedTextJsonPath().get());
    }

    private static void rejectInvalidGeneratedTextJsonPath(Errors errors) {
        errors.rejectValue(String.format(OPTIONS_PREFIX_FORMATTER, GENERATED_TEXT_JSON_PATH), INVALID_VALUE, "The json path for the generated text is not valid.");
    }

    private static void rejectEmptyGeneratedTextJsonPath(Errors errors) {
        errors.rejectValue(String.format(OPTIONS_PREFIX_FORMATTER, GENERATED_TEXT_JSON_PATH), REQUIRED, "Generated text json path can't be empty for custom AI servers");
    }

    private void validatePayloadTemplate(Errors errors, AiServerOptionsDto options) {
        if (AiServerValidator.isEmptyPayloadTemplate(options)) {
            AiServerValidator.rejectEmptyPayloadTemplate(errors);
        } else {
            this.validatePayloadHandlebarsTemplate(errors, options);
        }
    }

    private static boolean isEmptyPayloadTemplate(AiServerOptionsDto options) {
        return Objects.isNull(options) || Objects.isNull(options.getPayloadTemplate()) || options.getPayloadTemplate().isEmpty() || StringUtils.isBlank((CharSequence)options.getPayloadTemplate().get());
    }

    private void validatePayloadTemplateForPatch(Errors errors, AiServerOptionsDto options) {
        if (this.isEmptyPayloadTemplateForPatch(options)) {
            AiServerValidator.rejectEmptyPayloadTemplate(errors);
        } else if (this.checkOptionalIsNotNullOrEmpty(options.getPayloadTemplate())) {
            this.validatePayloadHandlebarsTemplate(errors, options);
        }
    }

    private boolean isEmptyPayloadTemplateForPatch(AiServerOptionsDto options) {
        return Objects.nonNull(options.getPayloadTemplate()) && options.getPayloadTemplate().isEmpty() || this.checkOptionalIsNotNullOrEmpty(options.getPayloadTemplate()) && StringUtils.isBlank((CharSequence)options.getPayloadTemplate().get());
    }

    private static void rejectEmptyPayloadTemplate(Errors errors) {
        errors.rejectValue(String.format(OPTIONS_PREFIX_FORMATTER, PAYLOAD_TEMPLATE), REQUIRED, "Payload template can't be empty for custom AI servers");
    }

    private void validatePayloadHandlebarsTemplate(Errors errors, AiServerOptionsDto options) {
        this.helpValidator.validateHandlebarsTemplate(errors, String.format(OPTIONS_PREFIX_FORMATTER, PAYLOAD_TEMPLATE), options.getPayloadTemplate().get());
    }

    private void validateAiServerOptions(Errors errors, AiServerOptionsDto options, String provider) {
        this.checkHasNoCustomAiServerOptions(errors, options);
        this.checkOptionsAreValidForProvider(errors, options, provider);
    }

    private void validateAiServerOptionsForPatch(Errors errors, AiServerOptionsDto options, String provider) {
        this.checkHasNoCustomAiServerOptions(errors, options);
        this.checkOptionsAreValidForProvider(errors, options, provider, true);
    }

    private void checkOptionsAreValidForProvider(Errors errors, AiServerOptionsDto options, String provider) {
        this.checkOptionsAreValidForProvider(errors, options, provider, false);
    }

    private void checkOptionsAreValidForProvider(Errors errors, AiServerOptionsDto options, String provider, boolean isPatch) {
        if (this.isValidAiProvider(provider)) {
            if (Objects.nonNull(options)) {
                this.validateRandomSeed(errors, options.getRandomSeed(), provider);
                this.validateSeed(errors, options.getSeed(), provider);
                this.validateMaxTokens(errors, options.getMaxTokens(), provider);
                this.validateMaxCompletionTokens(errors, options.getMaxCompletionTokens(), provider);
                this.validateMaxOutputTokens(errors, options.getMaxOutputTokens(), provider);
                this.validateReasoningEffort(errors, options.getReasoningEffort(), provider);
                this.validateOrganizationId(errors, options.getOrganizationId(), provider);
                this.validateApiVersion(errors, options.getApiVersion(), provider);
                this.validateThinkingType(errors, options.getThinkingType(), provider);
                this.validateThinkingBudgetTokens(errors, options.getThinkingBudgetTokens(), provider);
            }
            if (isPatch) {
                this.validateProjectIdForPatch(errors, options, provider);
                this.validateRegionForPatch(errors, options, provider);
            } else {
                this.validateProjectId(errors, options, provider);
                this.validateRegion(errors, options, provider);
            }
        }
    }

    private void validateRandomSeed(Errors errors, Optional<Integer> randomSeed, String provider) {
        if (this.checkOptionalIsNotNullOrEmpty(randomSeed) && !AiProvider.MISTRAL_AI.name().equals(provider)) {
            this.rejectOptionForProvider(errors, "randomSeed", provider);
        }
    }

    private void validateSeed(Errors errors, Optional<Integer> seed, String provider) {
        Set<String> validProviders;
        if (this.checkOptionalIsNotNullOrEmpty(seed) && !(validProviders = Set.of(AiProvider.AZURE_OPEN_AI.name(), AiProvider.OPEN_AI.name(), AiProvider.GOOGLE_VERTEX_AI.name())).contains(provider)) {
            this.rejectOptionForProvider(errors, "seed", provider);
        }
    }

    private void validateMaxTokens(Errors errors, Optional<Integer> maxTokens, String provider) {
        Set<String> validProviders;
        if (this.checkOptionalIsNotNullOrEmpty(maxTokens) && !(validProviders = Set.of(AiProvider.AZURE_OPEN_AI.name(), AiProvider.MISTRAL_AI.name(), AiProvider.ANTHROPIC.name())).contains(provider)) {
            this.rejectOptionForProvider(errors, "maxTokens", provider);
        }
    }

    private void validateMaxCompletionTokens(Errors errors, Optional<Integer> maxCompletionTokens, String provider) {
        if (this.checkOptionalIsNotNullOrEmpty(maxCompletionTokens) && !AiProvider.OPEN_AI.name().equals(provider)) {
            this.rejectOptionForProvider(errors, "maxCompletionTokens", provider);
        }
    }

    private void validateMaxOutputTokens(Errors errors, Optional<Integer> maxOutputTokens, String provider) {
        if (this.checkOptionalIsNotNullOrEmpty(maxOutputTokens) && !AiProvider.GOOGLE_VERTEX_AI.name().equals(provider)) {
            this.rejectOptionForProvider(errors, "maxOutputTokens", provider);
        }
    }

    private void validateReasoningEffort(Errors errors, Optional<String> reasoningEffort, String provider) {
        if (this.checkOptionalIsNotNullOrEmpty(reasoningEffort) && !AiProvider.OPEN_AI.name().equals(provider)) {
            this.rejectOptionForProvider(errors, "reasoningEffort", provider);
        }
    }

    private void validateOrganizationId(Errors errors, Optional<String> organizationId, String provider) {
        if (this.checkOptionalIsNotNullOrEmpty(organizationId) && !AiProvider.OPEN_AI.name().equals(provider)) {
            this.rejectOptionForProvider(errors, "organizationId", provider);
        }
    }

    private void validateApiVersion(Errors errors, Optional<String> apiVersion, String provider) {
        if (this.checkOptionalIsNotNullOrEmpty(apiVersion) && !AiProvider.AZURE_OPEN_AI.name().equals(provider)) {
            this.rejectOptionForProvider(errors, "apiVersion", provider);
        }
    }

    private void validateThinkingType(Errors errors, Optional<String> thinkingType, String provider) {
        if (this.checkOptionalIsNotNullOrEmpty(thinkingType) && !AiProvider.ANTHROPIC.name().equals(provider)) {
            this.rejectOptionForProvider(errors, "thinkingType", provider);
        }
    }

    private void validateThinkingBudgetTokens(Errors errors, Optional<Integer> thinkingBudgetTokens, String provider) {
        if (this.checkOptionalIsNotNullOrEmpty(thinkingBudgetTokens) && !AiProvider.ANTHROPIC.name().equals(provider)) {
            this.rejectOptionForProvider(errors, "thinkingBudgetTokens", provider);
        }
    }

    private void validateProjectId(Errors errors, AiServerOptionsDto options, String provider) {
        if (Objects.nonNull(options) && this.checkOptionalIsNotNullOrEmpty(options.getProjectId()) && !AiProvider.GOOGLE_VERTEX_AI.name().equals(provider)) {
            this.rejectOptionForProvider(errors, PROJECT_ID, provider);
        } else if (AiProvider.GOOGLE_VERTEX_AI.name().equals(provider) && AiServerValidator.isEmptyProjectId(options)) {
            AiServerValidator.rejectEmptyValueForProjectIdParameter(errors);
        }
    }

    private static boolean isEmptyProjectId(AiServerOptionsDto options) {
        return Objects.isNull(options) || Objects.isNull(options.getProjectId()) || options.getProjectId().isEmpty() || StringUtils.isBlank((CharSequence)options.getProjectId().get());
    }

    private void validateProjectIdForPatch(Errors errors, AiServerOptionsDto options, String provider) {
        if (this.checkOptionalIsNotNullOrEmpty(options.getProjectId()) && !AiProvider.GOOGLE_VERTEX_AI.name().equals(provider)) {
            this.rejectOptionForProvider(errors, PROJECT_ID, provider);
        } else if (AiProvider.GOOGLE_VERTEX_AI.name().equals(provider) && this.isEmptyProjectIdForPatch(options)) {
            AiServerValidator.rejectEmptyValueForProjectIdParameter(errors);
        }
    }

    private boolean isEmptyProjectIdForPatch(AiServerOptionsDto options) {
        return Objects.nonNull(options.getProjectId()) && options.getProjectId().isEmpty() || this.checkOptionalIsNotNullOrEmpty(options.getProjectId()) && StringUtils.isBlank((CharSequence)options.getProjectId().get());
    }

    private static void rejectEmptyValueForProjectIdParameter(Errors errors) {
        errors.rejectValue(String.format(OPTIONS_PREFIX_FORMATTER, PROJECT_ID), REQUIRED, "project_id can't be empty for AI servers with GOOGLE_VERTEX_AI provider");
    }

    private void validateRegion(Errors errors, AiServerOptionsDto options, String provider) {
        if (Objects.nonNull(options) && this.checkOptionalIsNotNullOrEmpty(options.getRegion()) && !AiProvider.GOOGLE_VERTEX_AI.name().equals(provider)) {
            this.rejectOptionForProvider(errors, REGION, provider);
        } else if (AiProvider.GOOGLE_VERTEX_AI.name().equals(provider) && AiServerValidator.isEmptyRegion(options)) {
            AiServerValidator.rejectEmptyValueForRegionParameter(errors);
        }
    }

    private static boolean isEmptyRegion(AiServerOptionsDto options) {
        return Objects.isNull(options) || Objects.isNull(options.getRegion()) || options.getRegion().isEmpty() || StringUtils.isBlank((CharSequence)options.getRegion().get());
    }

    private void validateRegionForPatch(Errors errors, AiServerOptionsDto options, String provider) {
        if (this.checkOptionalIsNotNullOrEmpty(options.getRegion()) && !AiProvider.GOOGLE_VERTEX_AI.name().equals(provider)) {
            this.rejectOptionForProvider(errors, REGION, provider);
        } else if (AiProvider.GOOGLE_VERTEX_AI.name().equals(provider) && this.isEmptyRegionForPatch(options)) {
            AiServerValidator.rejectEmptyValueForRegionParameter(errors);
        }
    }

    private boolean isEmptyRegionForPatch(AiServerOptionsDto options) {
        return Objects.nonNull(options.getRegion()) && options.getRegion().isEmpty() || this.checkOptionalIsNotNullOrEmpty(options.getRegion()) && StringUtils.isBlank((CharSequence)options.getRegion().get());
    }

    private static void rejectEmptyValueForRegionParameter(Errors errors) {
        errors.rejectValue(String.format(OPTIONS_PREFIX_FORMATTER, REGION), REQUIRED, "region can't be empty for AI servers with GOOGLE_VERTEX_AI provider");
    }

    private void rejectOptionForProvider(Errors errors, String fieldName, String provider) {
        errors.rejectValue(String.format(OPTIONS_PREFIX_FORMATTER, fieldName), INVALID_VALUE, String.format("This option is not valid for %s provider.", provider));
    }

    private void checkHasNoCustomAiServerOptions(Errors errors, AiServerOptionsDto options) {
        if (Objects.isNull(options)) {
            return;
        }
        int i = 1;
        while (i <= 5) {
            this.checkAndRejectCustomAiServerOption(errors, this.getHttpHeaderNameByIndex(options, i), "httpHeaderName" + i);
            this.checkAndRejectCustomAiServerOption(errors, this.getHttpHeaderValueTemplateByIndex(options, i), "httpHeaderValueTemplate" + i);
            ++i;
        }
        this.checkAndRejectCustomAiServerOption(errors, options.getGeneratedTextJsonPath(), GENERATED_TEXT_JSON_PATH);
        this.checkAndRejectCustomAiServerOption(errors, options.getPayloadTemplate(), PAYLOAD_TEMPLATE);
    }

    private boolean checkOptionalIsNotNullOrEmpty(Optional<?> optional) {
        return Objects.nonNull(optional) && optional.isPresent();
    }

    private void checkAndRejectCustomAiServerOption(Errors errors, Optional<?> targetOption, String fieldName) {
        if (Objects.nonNull(targetOption)) {
            errors.rejectValue(String.format(OPTIONS_PREFIX_FORMATTER, fieldName), INVALID_VALUE, "This option is invalid and should only be used for custom AI servers.");
        }
    }

    private Optional<String> getHttpHeaderNameByIndex(AiServerOptionsDto options, int index) {
        return switch (index) {
            case 1 -> options.getHttpHeaderName1();
            case 2 -> options.getHttpHeaderName2();
            case 3 -> options.getHttpHeaderName3();
            case 4 -> options.getHttpHeaderName4();
            case 5 -> options.getHttpHeaderName5();
            default -> throw new IllegalArgumentException("Invalid http header name index: " + index);
        };
    }

    private Optional<String> getHttpHeaderValueTemplateByIndex(AiServerOptionsDto options, int index) {
        return switch (index) {
            case 1 -> options.getHttpHeaderValueTemplate1();
            case 2 -> options.getHttpHeaderValueTemplate2();
            case 3 -> options.getHttpHeaderValueTemplate3();
            case 4 -> options.getHttpHeaderValueTemplate4();
            case 5 -> options.getHttpHeaderValueTemplate5();
            default -> throw new IllegalArgumentException("Invalid http header value template index: " + index);
        };
    }
}

