/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.service.impl;

import jakarta.inject.Inject;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jooq.DSLContext;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.aiserver.AiProvider;
import org.squashtest.tm.domain.aiserver.AiServer;
import org.squashtest.tm.exception.artificialintelligence.server.MalformedJsonPathException;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.plugin.rest.admin.jackson.model.AiServerDto;
import org.squashtest.tm.plugin.rest.admin.jackson.model.LegacyAiServerDto;
import org.squashtest.tm.plugin.rest.admin.service.RestAiServerService;
import org.squashtest.tm.plugin.rest.admin.service.patcher.AiServerPatcher;
import org.squashtest.tm.plugin.rest.admin.service.patcher.LegacyAiServerPatcher;
import org.squashtest.tm.plugin.rest.core.utils.ExceptionUtils;
import org.squashtest.tm.service.annotation.IsUltimateLicenseAvailable;
import org.squashtest.tm.service.artificialintelligence.server.AiServerManagerService;
import org.squashtest.tm.service.internal.display.dto.aiserver.AbstractAiServerConfiguration;
import org.squashtest.tm.service.internal.display.dto.aiserver.AiServerConfiguration;
import org.squashtest.tm.service.internal.display.dto.aiserver.CustomAiServerConfiguration;
import org.squashtest.tm.service.internal.repository.AiServerDao;
import org.squashtest.tm.service.jsonpathextractor.JsonPathExtractor;

@Service
@Transactional
public class RestAiServerServiceImpl
implements RestAiServerService {
    @Inject
    private AiServerDao aiServerDao;
    @Inject
    private AiServerManagerService aiServerManagerService;
    @Inject
    private DSLContext dsl;
    @Inject
    private JsonPathExtractor jsonPathExtractor;
    @Inject
    private LegacyAiServerPatcher legacyAiServerPatcher;
    @Inject
    private AiServerPatcher aiServerPatcher;

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public AiServer findAiServerById(Long aiServerId) {
        return (AiServer)this.aiServerDao.findById((Object)aiServerId).orElseThrow(() -> ExceptionUtils.entityNotFoundException(AiServer.class, (Long)aiServerId));
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public Page<AiServer> findAllLegacyAiServers(Pageable pageable) {
        Page aiServers = this.aiServerDao.findAll(pageable);
        List<AiServer> filteredList = aiServers.stream().filter(aiServer -> aiServer.getProvider() == AiProvider.NONE).toList();
        return new PageImpl(filteredList, aiServers.getPageable(), (long)filteredList.size());
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public Page<AiServer> findAllAiServers(Pageable pageable) {
        return this.aiServerDao.findAll(pageable);
    }

    @Override
    @IsUltimateLicenseAvailable
    public void deleteAiServers(List<Long> aiServerIds) {
        this.aiServerManagerService.deleteAiServers(this.findExistingAiServerIds(aiServerIds));
    }

    private List<Long> findExistingAiServerIds(List<Long> aiServerIds) {
        return this.dsl.select((SelectField)Tables.AI_SERVER.SERVER_ID).from((TableLike)Tables.AI_SERVER).where(Tables.AI_SERVER.SERVER_ID.in(aiServerIds)).fetchInto(Long.class);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public AiServer createNewLegacyAiServer(AiServer server) {
        if (server.getJsonPath() != null && !this.jsonPathExtractor.isPathValid(server.getJsonPath()) && !server.getJsonPath().isEmpty()) {
            throw new MalformedJsonPathException();
        }
        this.aiServerManagerService.persist(server);
        Optional newAiServer = this.aiServerDao.findById((Object)server.getId());
        if (newAiServer.isPresent()) {
            return (AiServer)newAiServer.get();
        }
        throw new IllegalArgumentException("Failed to create a new AI server. The provided server object may be invalid or incomplete.");
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public AiServer createNewAiServer(AiServerDto aiServerDto) {
        AiServer server = aiServerDto.toAiServer();
        this.aiServerManagerService.persist(server);
        Optional newAiServer = this.aiServerDao.findById((Object)server.getId());
        if (newAiServer.isPresent()) {
            return (AiServer)newAiServer.get();
        }
        throw new IllegalArgumentException("Failed to create a new AI server. The provided server object may be invalid or incomplete.");
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public AiServer updateLegacyAiServer(Long aiServerId, LegacyAiServerDto aiServerDto) {
        AiServer aiServer = this.findAiServerById(aiServerId);
        this.legacyAiServerPatcher.patch(aiServer, aiServerDto);
        return aiServer;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @IsUltimateLicenseAvailable
    public AiServer updateAiServer(Long aiServerId, AiServerDto aiServerDto) {
        AiServer aiServer = this.findAiServerById(aiServerId);
        this.resetConfigIfProviderHasChanged(aiServer, aiServerDto);
        this.aiServerPatcher.patch(aiServer, aiServerDto);
        this.patchProvider(aiServer, aiServerDto);
        this.patchOptions(aiServer, aiServerDto);
        return aiServer;
    }

    private void patchProvider(AiServer aiServer, AiServerDto aiServerDto) {
        aiServer.setProvider(AiProvider.valueOf((String)aiServerDto.getProvider()));
    }

    private void resetConfigIfProviderHasChanged(AiServer aiServer, AiServerDto aiServerDto) {
        if (!aiServer.getProvider().name().equals(aiServerDto.getProvider())) {
            aiServer.setOptions(null);
            aiServer.setModelName(null);
        }
    }

    private void patchOptions(AiServer aiServer, AiServerDto aiServerDto) {
        if (Objects.nonNull(aiServerDto.getOptions())) {
            if (AiProvider.CUSTOM.name().equals(aiServerDto.getProvider())) {
                CustomAiServerConfiguration conf = (CustomAiServerConfiguration)AbstractAiServerConfiguration.getDeserializedConfiguration((String)aiServer.getOptions(), (String)aiServer.getName(), CustomAiServerConfiguration.class);
                aiServer.setOptions(aiServerDto.getOptions().toCustomAiServerConfigurationAsString(conf));
            } else {
                AiServerConfiguration conf = (AiServerConfiguration)AbstractAiServerConfiguration.getDeserializedConfiguration((String)aiServer.getOptions(), (String)aiServer.getName(), AiServerConfiguration.class);
                aiServer.setOptions(aiServerDto.getOptions().toAiServerConfigurationAsString(conf));
            }
        }
    }
}

