--  Lock Database
UPDATE DATABASECHANGELOGLOCK SET `LOCKED` = 1, LOCKEDBY = 'runner-yfpexrfv8-project-33554404-concurrent-0-5sbje3y3 (100.64.9.45)', LOCKGRANTED = NOW() WHERE ID = 1 AND `LOCKED` = 0;

--  *********************************************************************
--  Update Database Script
--  *********************************************************************
--  Change Log: upgrade.changelog-up-to-8.0.0.xml
--  Ran at: 16/02/2026 13:56
--  Against: root@jdbc:mariadb://mariadb/squashtest
--  Liquibase version: 4.29.2
--  *********************************************************************

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0::mbrugniere
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '8.0.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0', 'mbrugniere', '../tm/tm.changelog-8.0.0.xml', NOW(), 1, '9:da5a1a70628566273a68386bf3258f16', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, NULL, '4.29.2', '1246604164');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-1658-add-column-duration-in-automated-execution-extender-table::xzhao
--  Add column duration in automated execution extender table
ALTER TABLE AUTOMATED_EXECUTION_EXTENDER ADD DURATION INT NULL COMMENT 'the execution time of a automation test';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-1658-add-column-duration-in-automated-execution-extender-table', 'xzhao', '../tm/tm.changelog-8.0.0.xml', NOW(), 2, '9:ec05fea5b5ddb5519d8b693c2ccbf03a', 'addColumn tableName=AUTOMATED_EXECUTION_EXTENDER', 'Add column duration in automated execution extender table', 'EXECUTED', NULL, NULL, '4.29.2', '1246604164');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-custom-field-value-update-unique-constraint::rfortoso
ALTER TABLE CUSTOM_FIELD_VALUE DROP KEY u_cfv_id_type_binding;

ALTER TABLE CUSTOM_FIELD_VALUE ADD CONSTRAINT u_cfv_type_id_binding UNIQUE (BOUND_ENTITY_TYPE, BOUND_ENTITY_ID, CFB_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-custom-field-value-update-unique-constraint', 'rfortoso', '../tm/tm.changelog-8.0.0.xml', NOW(), 3, '9:7a35e83afc787162e080388deed7dddc', 'dropUniqueConstraint constraintName=u_cfv_id_type_binding, tableName=CUSTOM_FIELD_VALUE; addUniqueConstraint constraintName=u_cfv_type_id_binding, tableName=CUSTOM_FIELD_VALUE', '', 'EXECUTED', NULL, NULL, '4.29.2', '1246604164');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-denormalized_field_value-update-unique-constraint::rfortoso
ALTER TABLE DENORMALIZED_FIELD_VALUE DROP KEY u_dfv_id_type_code;

ALTER TABLE DENORMALIZED_FIELD_VALUE ADD CONSTRAINT u_dfv_type_id_code UNIQUE (DENORMALIZED_FIELD_HOLDER_TYPE, DENORMALIZED_FIELD_HOLDER_ID, CODE);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-denormalized_field_value-update-unique-constraint', 'rfortoso', '../tm/tm.changelog-8.0.0.xml', NOW(), 4, '9:a2c120181a625204cbbc79c245e2150c', 'dropUniqueConstraint constraintName=u_dfv_id_type_code, tableName=DENORMALIZED_FIELD_VALUE; addUniqueConstraint constraintName=u_dfv_type_id_code, tableName=DENORMALIZED_FIELD_VALUE', '', 'EXECUTED', NULL, NULL, '4.29.2', '1246604164');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-denormalized_environment_variable-update-unique-constraint::rfortoso
ALTER TABLE DENORMALIZED_ENVIRONMENT_VARIABLE DROP KEY uc_dev_id_type_name;

ALTER TABLE DENORMALIZED_ENVIRONMENT_VARIABLE ADD CONSTRAINT uc_dev_type_id_name UNIQUE (HOLDER_TYPE, HOLDER_ID, NAME);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-denormalized_environment_variable-update-unique-constraint', 'rfortoso', '../tm/tm.changelog-8.0.0.xml', NOW(), 5, '9:ce0df88a63d0e8592f8b85efe57793bc', 'dropUniqueConstraint constraintName=uc_dev_id_type_name, tableName=DENORMALIZED_ENVIRONMENT_VARIABLE; addUniqueConstraint constraintName=uc_dev_type_id_name, tableName=DENORMALIZED_ENVIRONMENT_VARIABLE', '', 'EXECUTED', NULL, NULL, '4.29.2', '1246604164');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-denormalized_environment_tag-update-unique-constraint::rfortoso
ALTER TABLE DENORMALIZED_ENVIRONMENT_TAG DROP KEY uc_det_id_type_value;

ALTER TABLE DENORMALIZED_ENVIRONMENT_TAG ADD CONSTRAINT uc_det_type_id_value UNIQUE (HOLDER_TYPE, HOLDER_ID, VALUE);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-denormalized_environment_tag-update-unique-constraint', 'rfortoso', '../tm/tm.changelog-8.0.0.xml', NOW(), 6, '9:3f67ac813240f65a484fa66830769c98', 'dropUniqueConstraint constraintName=uc_det_id_type_value, tableName=DENORMALIZED_ENVIRONMENT_TAG; addUniqueConstraint constraintName=uc_det_type_id_value, tableName=DENORMALIZED_ENVIRONMENT_TAG', '', 'EXECUTED', NULL, NULL, '4.29.2', '1246604164');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-environment_variable_binding-update-unique-constraint::rfortoso
ALTER TABLE ENVIRONMENT_VARIABLE_BINDING DROP KEY uc_evb_id_type_ev_id_binding;

ALTER TABLE ENVIRONMENT_VARIABLE_BINDING ADD CONSTRAINT uc_type_evb_id_ev_id_binding UNIQUE (ENTITY_TYPE, ENTITY_ID, EV_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-environment_variable_binding-update-unique-constraint', 'rfortoso', '../tm/tm.changelog-8.0.0.xml', NOW(), 7, '9:2d792ed2bf3ce5632b537beeb4067f52', 'dropUniqueConstraint constraintName=uc_evb_id_type_ev_id_binding, tableName=ENVIRONMENT_VARIABLE_BINDING; addUniqueConstraint constraintName=uc_type_evb_id_ev_id_binding, tableName=ENVIRONMENT_VARIABLE_BINDING', '', 'EXECUTED', NULL, NULL, '4.29.2', '1246604164');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-automation_environment_tag-update-unique-constraint::rfortoso
ALTER TABLE AUTOMATION_ENVIRONMENT_TAG DROP KEY uniq_value_entity_type_entity_id;

ALTER TABLE AUTOMATION_ENVIRONMENT_TAG ADD CONSTRAINT uniq_entity_type_entity_id_value UNIQUE (ENTITY_TYPE, ENTITY_ID, VALUE);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-automation_environment_tag-update-unique-constraint', 'rfortoso', '../tm/tm.changelog-8.0.0.xml', NOW(), 8, '9:6d1a3ea7a72fb3d7b1b38b79fe88d906', 'dropUniqueConstraint constraintName=uniq_value_entity_type_entity_id, tableName=AUTOMATION_ENVIRONMENT_TAG; addUniqueConstraint constraintName=uniq_entity_type_entity_id_value, tableName=AUTOMATION_ENVIRONMENT_TAG', '', 'EXECUTED', NULL, NULL, '4.29.2', '1246604164');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-modify_restrain_to_active_sprint_json_keys::pguygot
UPDATE REMOTE_SYNCHRONISATION SET REMOTE_SYNCHRONISATION_OPTIONS = REPLACE(REMOTE_SYNCHRONISATION_OPTIONS, 'restrainToActiveSprint', 'restrictedToActiveSprint');

UPDATE REMOTE_SYNCHRONISATION SET REMOTE_SYNCHRONISATION_OPTIONS = REPLACE(REMOTE_SYNCHRONISATION_OPTIONS, 'restrainSprintToActiveSprint', 'sprintRestrictedToActiveSprint');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-modify_restrain_to_active_sprint_json_keys', 'pguygot', '../tm/tm.changelog-8.0.0.xml', NOW(), 9, '9:76e1b4e0c4b157b2c7d30eb171738e12', 'sql', '', 'EXECUTED', NULL, NULL, '4.29.2', '1246604164');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-remove-unnecessary-roles::jprioux
DELETE FROM CORE_PARTY_AUTHORITY WHERE authority in ('ROLE_TM_PROJECT_MANAGER', 'ROLE_TF_FUNCTIONAL_TESTER', 'ROLE_TF_AUTOMATION_PROGRAMMER');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-remove-unnecessary-roles', 'jprioux', '../tm/tm.changelog-8.0.0.xml', NOW(), 10, '9:4a8c30f71f1505794d2f57106f29b8c9', 'delete tableName=CORE_PARTY_AUTHORITY', '', 'EXECUTED', NULL, NULL, '4.29.2', '1246604164');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-add_remote_sync_id_in_sprint_group_table::pguygot
ALTER TABLE SPRINT_GROUP ADD REMOTE_SYNCHRONISATION_ID BIGINT NULL;

ALTER TABLE SPRINT_GROUP ADD CONSTRAINT fk_sprint_group_remote_synchronisation FOREIGN KEY (REMOTE_SYNCHRONISATION_ID) REFERENCES REMOTE_SYNCHRONISATION (REMOTE_SYNCHRONISATION_ID);

CREATE INDEX idx_fk_sprint_group_remote_synchronisation ON SPRINT_GROUP(REMOTE_SYNCHRONISATION_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-add_remote_sync_id_in_sprint_group_table', 'pguygot', '../tm/tm.changelog-8.0.0.xml', NOW(), 11, '9:c9bc54b9c3ecbad7e8b26c7c3ba8710d', 'addColumn tableName=SPRINT_GROUP; createIndex indexName=idx_fk_sprint_group_remote_synchronisation, tableName=SPRINT_GROUP', '', 'EXECUTED', NULL, NULL, '4.29.2', '1246604164');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-add-manage-milestone-permission::jprioux
INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID)
      SELECT (SELECT ID FROM ACL_GROUP WHERE QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'),
             32768,
             (SELECT ID FROM ACL_CLASS WHERE CLASSNAME = 'org.squashtest.tm.domain.project.Project');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-add-manage-milestone-permission', 'jprioux', '../tm/tm.changelog-8.0.0.xml', NOW(), 12, '9:438f790a864a5b1ca6f831e873b3d10d', 'sql', '', 'EXECUTED', NULL, NULL, '4.29.2', '1246604164');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-add-manage-project-clearance-permission::jprioux
INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID)
      SELECT (SELECT ID FROM ACL_GROUP WHERE QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'),
             65536,
             (SELECT ID FROM ACL_CLASS WHERE CLASSNAME = 'org.squashtest.tm.domain.project.Project');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-add-manage-project-clearance-permission', 'jprioux', '../tm/tm.changelog-8.0.0.xml', NOW(), 13, '9:321e8c064bd548664074d7e154546011', 'sql', '', 'EXECUTED', NULL, NULL, '4.29.2', '1246604164');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-add-active-in-acl-group::jprioux
ALTER TABLE ACL_GROUP ADD ACTIVE TINYINT(1) DEFAULT 1 NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-add-active-in-acl-group', 'jprioux', '../tm/tm.changelog-8.0.0.xml', NOW(), 14, '9:e2e307038d99c9ae01d5493770489324', 'addColumn tableName=ACL_GROUP', '', 'EXECUTED', NULL, NULL, '4.29.2', '1246604164');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-add-description-in-acl-group::jprioux
ALTER TABLE ACL_GROUP ADD `DESCRIPTION` LONGTEXT DEFAULT '' NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-add-description-in-acl-group', 'jprioux', '../tm/tm.changelog-8.0.0.xml', NOW(), 15, '9:648bc9595fe47806f6dc57d33b0b6e94', 'addColumn tableName=ACL_GROUP', '', 'EXECUTED', NULL, NULL, '4.29.2', '1246604164');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-add-auditable-columns-in-sprint-req-version::pckerneis
ALTER TABLE SPRINT_REQ_VERSION ADD CREATED_BY VARCHAR(100) NULL, ADD CREATED_ON datetime NULL, ADD LAST_MODIFIED_BY VARCHAR(100) DEFAULT null NULL, ADD LAST_MODIFIED_ON datetime DEFAULT null NULL;

UPDATE SPRINT_REQ_VERSION SET CREATED_BY = 'Upgrade Squash 8.0', CREATED_ON = NOW() WHERE CREATED_ON IS NULL;

ALTER TABLE SPRINT_REQ_VERSION MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE SPRINT_REQ_VERSION MODIFY CREATED_ON datetime NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-add-auditable-columns-in-sprint-req-version', 'pckerneis', '../tm/tm.changelog-8.0.0.xml', NOW(), 16, '9:7b9695a7fec85024827d529cdf54ec63', 'addColumn tableName=SPRINT_REQ_VERSION; update tableName=SPRINT_REQ_VERSION; addNotNullConstraint columnName=CREATED_BY, tableName=SPRINT_REQ_VERSION; addNotNullConstraint columnName=CREATED_ON, tableName=SPRINT_REQ_VERSION', '', 'EXECUTED', NULL, NULL, '4.29.2', '1246604164');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-add-auditable-columns-in-acl-group::jprioux
ALTER TABLE ACL_GROUP ADD CREATED_BY VARCHAR(100) NULL, ADD CREATED_ON datetime NULL, ADD LAST_MODIFIED_BY VARCHAR(100) DEFAULT null NULL, ADD LAST_MODIFIED_ON datetime DEFAULT null NULL;

UPDATE ACL_GROUP SET CREATED_BY = 'Upgrade Squash 8.0', CREATED_ON = NOW() WHERE qualified_name like 'squashtest.acl.group.tm.%';

ALTER TABLE ACL_GROUP MODIFY CREATED_BY VARCHAR(100) NOT NULL;

ALTER TABLE ACL_GROUP MODIFY CREATED_ON datetime NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-add-auditable-columns-in-acl-group', 'jprioux', '../tm/tm.changelog-8.0.0.xml', NOW(), 17, '9:611344fe6e10611009b7c2920f75a233', 'addColumn tableName=ACL_GROUP; update tableName=ACL_GROUP; addNotNullConstraint columnName=CREATED_BY, tableName=ACL_GROUP; addNotNullConstraint columnName=CREATED_ON, tableName=ACL_GROUP', '', 'EXECUTED', NULL, NULL, '4.29.2', '1246604164');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-limit-acl-group-name-to-50::jprioux
ALTER TABLE ACL_GROUP MODIFY QUALIFIED_NAME VARCHAR(50);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-limit-acl-group-name-to-50', 'jprioux', '../tm/tm.changelog-8.0.0.xml', NOW(), 18, '9:7458d877d512b0602e4684d476e1b15b', 'modifyDataType columnName=QUALIFIED_NAME, tableName=ACL_GROUP', '', 'EXECUTED', NULL, NULL, '4.29.2', '1246604164');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-add-created-by-column-in-api-token::mbrugniere
ALTER TABLE API_TOKEN ADD CREATED_BY VARCHAR(100) NULL;

UPDATE API_TOKEN
      SET CREATED_BY = (
        SELECT CORE_USER.LOGIN
        FROM CORE_USER
        WHERE CORE_USER.PARTY_ID = API_TOKEN.USER_ID
        AND API_TOKEN.CREATED_BY IS NULL
      );

ALTER TABLE API_TOKEN MODIFY CREATED_BY VARCHAR(100) NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-add-created-by-column-in-api-token', 'mbrugniere', '../tm/tm.changelog-8.0.0.xml', NOW(), 19, '9:b3090da737afdac4a5baaf293b66ce06', 'addColumn tableName=API_TOKEN; sql; addNotNullConstraint columnName=CREATED_BY, tableName=API_TOKEN', '', 'EXECUTED', NULL, NULL, '4.29.2', '1246604164');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-add-table-for-pivot-format-import::dclaerhout
--  Add a pivot format import table in squash tm.
CREATE TABLE PIVOT_FORMAT_IMPORT (PFI_ID BIGINT AUTO_INCREMENT NOT NULL, NAME VARCHAR(255) NOT NULL, CREATED_BY BIGINT NULL COMMENT 'Foreign key to the user that requested the pivot format import', CREATED_ON datetime NOT NULL, FILE_PATH VARCHAR(255) NOT NULL, STATUS VARCHAR(50) NOT NULL, PROJECT_ID BIGINT DEFAULT null NULL, IMPORT_TYPE VARCHAR(50) NOT NULL, SUCCESSFULLY_IMPORTED_ON datetime NULL, CONSTRAINT PK_PIVOT_FORMAT_IMPORT PRIMARY KEY (PFI_ID), CONSTRAINT fk_pivot_format_import_project_project_id FOREIGN KEY (PROJECT_ID) REFERENCES PROJECT(PROJECT_ID) ON DELETE CASCADE, CONSTRAINT fk_pivot_format_import_core_user_party_id FOREIGN KEY (CREATED_BY) REFERENCES CORE_USER(PARTY_ID) ON DELETE CASCADE);

CREATE INDEX idx_fk_pivot_format_import_created_by ON PIVOT_FORMAT_IMPORT(CREATED_BY);

CREATE INDEX idx_fk_pivot_format_import_project_id ON PIVOT_FORMAT_IMPORT(PROJECT_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-add-table-for-pivot-format-import', 'dclaerhout', '../tm/tm.changelog-8.0.0.xml', NOW(), 20, '9:cc3a4ab79f5b5a29f3e497e2185ab422', 'createTable tableName=PIVOT_FORMAT_IMPORT; createIndex indexName=idx_fk_pivot_format_import_created_by, tableName=PIVOT_FORMAT_IMPORT; createIndex indexName=idx_fk_pivot_format_import_project_id, tableName=PIVOT_FORMAT_IMPORT', 'Add a pivot format import table in squash tm.', 'EXECUTED', NULL, NULL, '4.29.2', '1246604164');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-harmonize-profile-permissions::jprioux
DELETE FROM ACL_GROUP_PERMISSION
      WHERE CLASS_ID = (SELECT ID FROM ACL_CLASS WHERE CLASSNAME = 'org.squashtest.tm.domain.tf.automationrequest.AutomationRequestLibrary')
      AND PERMISSION_MASK NOT IN (8192, 16384);

DELETE FROM ACL_GROUP_PERMISSION
      WHERE CLASS_ID = (SELECT ID FROM ACL_CLASS WHERE CLASSNAME = 'org.squashtest.tm.domain.project.Project')
      AND PERMISSION_MASK = 1024;

DELETE FROM ACL_GROUP_PERMISSION
      WHERE CLASS_ID = (SELECT ID FROM ACL_CLASS WHERE CLASSNAME = 'org.squashtest.tm.domain.actionword.ActionWordLibrary')
      AND PERMISSION_MASK = 256;

DELETE FROM ACL_GROUP_PERMISSION
      WHERE ACL_GROUP_ID = (SELECT ID FROM ACL_GROUP WHERE QUALIFIED_NAME = 'squashtest.acl.group.tm.AutomatedTestWriter')
      AND PERMISSION_MASK = 1
      AND CLASS_ID NOT IN (SELECT ID FROM ACL_CLASS WHERE CLASSNAME IN ('org.squashtest.tm.domain.project.Project', 'org.squashtest.tm.domain.testcase.TestCaseLibrary'));

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-harmonize-profile-permissions', 'jprioux', '../tm/tm.changelog-8.0.0.xml', NOW(), 21, '9:71f8dc427a500f8da2cedf8c97e33152', 'sql', '', 'EXECUTED', NULL, NULL, '4.29.2', '1246604164');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-add-credentials_not_shared-column-in-scm-server-table::xzhao
--  Add column credentials_not_shared in scm_server table
ALTER TABLE SCM_SERVER ADD CREDENTIALS_NOT_SHARED TINYINT(1) DEFAULT 0 NOT NULL COMMENT 'the credentials_not_shared prevent git credentials propagation';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-add-credentials_not_shared-column-in-scm-server-table', 'xzhao', '../tm/tm.changelog-8.0.0.xml', NOW(), 22, '9:691b4872fb76c3c63c3b4d109684b924', 'addColumn tableName=SCM_SERVER', 'Add column credentials_not_shared in scm_server table', 'EXECUTED', NULL, NULL, '4.29.2', '1246604164');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-remove-the-table-denormalized_field_option-from-the-squash-database::jmarque and rfortoso
--  DENORMALIZED_FIELD_OPTION has been unused for some time
TRUNCATE TABLE DENORMALIZED_FIELD_OPTION;

DROP TABLE DENORMALIZED_FIELD_OPTION;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-remove-the-table-denormalized_field_option-from-the-squash-database', 'jmarque and rfortoso', '../tm/tm.changelog-8.0.0.xml', NOW(), 23, '9:77e068b720f9736562413ef2099f151d', 'sql', 'DENORMALIZED_FIELD_OPTION has been unused for some time', 'EXECUTED', NULL, NULL, '4.29.2', '1246604164');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-add-validation-status-column-in-sprint-requirement-version-table::mbrugniere
--  Add column validation_status in sprint_req_version table
ALTER TABLE SPRINT_REQ_VERSION ADD VALIDATION_STATUS VARCHAR(50) DEFAULT 'TO_BE_TESTED' NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-add-validation-status-column-in-sprint-requirement-version-table', 'mbrugniere', '../tm/tm.changelog-8.0.0.xml', NOW(), 24, '9:0d755ad52c58dec5ae67c9258ff87053', 'addColumn tableName=SPRINT_REQ_VERSION', 'Add column validation_status in sprint_req_version table', 'EXECUTED', NULL, NULL, '4.29.2', '1246604164');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-add-last_modified_on-column-in-attachment-table::xzhao
--  Add column last_modified_on in attachment table
ALTER TABLE ATTACHMENT ADD LAST_MODIFIED_ON datetime NULL COMMENT 'the date when the attachment was last modified';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-add-last_modified_on-column-in-attachment-table', 'xzhao', '../tm/tm.changelog-8.0.0.xml', NOW(), 25, '9:1e180d5f12864542089b7494a4ea7b46', 'addColumn tableName=ATTACHMENT', 'Add column last_modified_on in attachment table', 'EXECUTED', NULL, NULL, '4.29.2', '1246604164');

--  Changeset ../tm/tm.changelog-8.0.0.xml::tm-8.0.0-add-import-permission-to-project-manager-profile::jprioux
INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID)
      SELECT (SELECT ID FROM ACL_GROUP WHERE QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'),
             512,
             (SELECT ID FROM ACL_CLASS WHERE CLASSNAME = 'org.squashtest.tm.domain.project.Project');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-8.0.0-add-import-permission-to-project-manager-profile', 'jprioux', '../tm/tm.changelog-8.0.0.xml', NOW(), 26, '9:54461965589da4cc39529ae42dc6a2b1', 'sql', '', 'EXECUTED', NULL, NULL, '4.29.2', '1246604164');

--  Release Database Lock
UPDATE DATABASECHANGELOGLOCK SET `LOCKED` = 0, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;

