/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.controller;

import jakarta.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.LinkBuilder;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.squashtest.tm.plugin.rest.admin.jackson.model.RequirementLinkTypeMappingDto;
import org.squashtest.tm.plugin.rest.admin.service.RestRequirementLinkTypeMappingService;
import org.squashtest.tm.plugin.rest.admin.validators.RequirementLinkTypeMappingValidator;
import org.squashtest.tm.plugin.rest.core.web.BasePathAwareLinkBuildingService;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;

@RestApiController
@UseDefaultRestApiConfiguration
@ConditionalOnClass(name={"org.squashtest.tm.plugin.rest.admin.SquashAdminApiConditionalInterface"})
public class RestRequirementLinkTypeMappingController {
    @Inject
    private BasePathAwareLinkBuildingService linkService;
    @Inject
    private RestRequirementLinkTypeMappingService restRequirementLinkTypeMappingService;
    @Inject
    private RequirementLinkTypeMappingValidator requirementLinkTypeMappingValidator;

    @GetMapping(value={"/projects/{projectId}/requirement-link-type-mappings/{id}"})
    public ResponseEntity<EntityModel<RequirementLinkTypeMappingDto>> getRequirementLinkTypeMappingByIdForProject(@PathVariable(value="projectId") Long projectId, @PathVariable(value="id") Long requirementLinkTypeId) {
        RequirementLinkTypeMappingDto requirementLinkTypeMappingDto = this.restRequirementLinkTypeMappingService.getRequirementLinkTypeMappingByIdForProject(projectId, requirementLinkTypeId);
        EntityModel<RequirementLinkTypeMappingDto> resource = this.toRequirementLinkTypeMappingResource(projectId, requirementLinkTypeMappingDto);
        return ResponseEntity.ok(resource);
    }

    private EntityModel<RequirementLinkTypeMappingDto> toRequirementLinkTypeMappingResource(Long projectId, RequirementLinkTypeMappingDto entity) {
        EntityModel resource = EntityModel.of((Object)entity);
        LinkBuilder linkBuilder = this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestRequirementLinkTypeMappingController)WebMvcLinkBuilder.methodOn(RestRequirementLinkTypeMappingController.class, (Object[])new Object[0])).getRequirementLinkTypeMappingByIdForProject(projectId, entity.getId())));
        resource.add(linkBuilder.withSelfRel());
        return resource;
    }

    @GetMapping(value={"/projects/{id}/requirement-link-type-mappings"})
    public ResponseEntity<PagedModel<EntityModel<RequirementLinkTypeMappingDto>>> getAllRequirementLinkTypeMappingsForProject(@PathVariable(value="id") Long projectId) {
        List<RequirementLinkTypeMappingDto> requirementLinkTypeMappingDtoList = this.restRequirementLinkTypeMappingService.getAllRequirementLinkTypeMappingsForProject(projectId);
        PagedModel<EntityModel<RequirementLinkTypeMappingDto>> resources = this.toRequirementLinkTypeMappingPagedResources(requirementLinkTypeMappingDtoList, projectId);
        return ResponseEntity.ok(resources);
    }

    private PagedModel<EntityModel<RequirementLinkTypeMappingDto>> toRequirementLinkTypeMappingPagedResources(List<RequirementLinkTypeMappingDto> content, Long projectId) {
        Collection resourceCollection = content.stream().map(requirementLinkTypeMappingDto -> this.toRequirementLinkTypeMappingResource(projectId, (RequirementLinkTypeMappingDto)requirementLinkTypeMappingDto)).collect(Collectors.toList());
        PagedModel.PageMetadata metadata = new PagedModel.PageMetadata((long)resourceCollection.size(), 0L, (long)resourceCollection.size());
        LinkBuilder linkBuilder = this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestRequirementLinkTypeMappingController)WebMvcLinkBuilder.methodOn(RestRequirementLinkTypeMappingController.class, (Object[])new Object[0])).getAllRequirementLinkTypeMappingsForProject(projectId)));
        return PagedModel.of((Collection)resourceCollection, (PagedModel.PageMetadata)metadata, (Link[])new Link[]{linkBuilder.withSelfRel()});
    }

    @PatchMapping(value={"/projects/{projectId}/requirement-link-type-mappings/{id}"})
    public ResponseEntity<EntityModel<RequirementLinkTypeMappingDto>> updateRequirementLinkTypeMapping(@PathVariable(value="projectId") Long projectId, @PathVariable(value="id") Long requirementLinkTypeId, @RequestBody RequirementLinkTypeMappingDto requirementLinkTypeMappingDto) throws BindException {
        this.requirementLinkTypeMappingValidator.validatePatchRequirementLinkTypeMapping(projectId, requirementLinkTypeId, requirementLinkTypeMappingDto);
        RequirementLinkTypeMappingDto updatedRequirementLinkTypeMapping = this.restRequirementLinkTypeMappingService.updateRequirementLinkTypeMapping(projectId, requirementLinkTypeId, requirementLinkTypeMappingDto);
        EntityModel<RequirementLinkTypeMappingDto> resource = this.toRequirementLinkTypeMappingResource(projectId, updatedRequirementLinkTypeMapping);
        return ResponseEntity.ok(resource);
    }
}

