/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.domain.execplan;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.squashtest.tm.plugin.jirasync.domain.execplan.BoardSprints;
import org.squashtest.tm.plugin.jirasync.domain.execplan.ExecplanSearchOperation;

public class SprintSearch
implements ExecplanSearchOperation<List<BoardSprints>> {
    private Collection<String> boards = new ArrayList<String>();
    private Date completedSince = null;
    private boolean sprintStillRunning = false;
    private String nameLike = null;
    private Integer mostRecentReleasesLimit = null;
    @JsonDeserialize(contentAs=BoardSprints.class)
    private List<BoardSprints> sprints;

    public Collection<String> getBoards() {
        return this.boards;
    }

    public void setBoards(Collection<String> boards) {
        this.boards = boards;
    }

    public Date getCompletedSince() {
        return this.completedSince;
    }

    public void setCompletedSince(Date completedSince) {
        this.completedSince = completedSince;
    }

    public boolean isSprintStillRunning() {
        return this.sprintStillRunning;
    }

    public void setSprintStillRunning(boolean sprintStillRunning) {
        this.sprintStillRunning = sprintStillRunning;
    }

    public List<BoardSprints> getSprints() {
        return this.sprints;
    }

    public void setResult(List<BoardSprints> sprints) {
        this.sprints = sprints;
        Collections.sort(this.sprints);
    }

    public String getNameLike() {
        return this.nameLike;
    }

    public void setNameLike(String nameLike) {
        this.nameLike = nameLike;
    }

    public Integer getMostRecentReleasesLimit() {
        return this.mostRecentReleasesLimit;
    }

    public void setMostRecentReleasesLimit(Integer mostRecentReleasesLimit) {
        this.mostRecentReleasesLimit = mostRecentReleasesLimit;
    }

    @Override
    public List<BoardSprints> getResult() {
        return this.sprints;
    }

    public String logParameters() {
        String strSince = this.completedSince != null ? this.completedSince.toString() : "(no limit)";
        String strRun = this.sprintStillRunning ? "true" : "false";
        StringBuilder builder = new StringBuilder("Sprint Search parameters :");
        builder.append("\n\tboards : ").append(this.boards);
        builder.append("\n\texpected completion date : ").append(strSince);
        builder.append("\n\tsprint should still run : ").append(strRun);
        builder.append("\n\tname like : ").append(this.nameLike);
        builder.append("\n\tX most recent : ").append(this.mostRecentReleasesLimit);
        return builder.toString();
    }

    public static final class SprintSearchValidator
    implements Validator {
        public boolean supports(Class<?> clazz) {
            return SprintSearch.class.isAssignableFrom(clazz);
        }

        public void validate(Object target, Errors errors) {
            SprintSearch search = (SprintSearch)target;
            if (search.isSprintStillRunning() && search.getCompletedSince() != null) {
                errors.rejectValue("sprintsearch.sprintStillRunning", "Illegally enabled", "option 'sprintStillRunning' and 'completedSince' cannot be used at the same time");
            }
        }
    }
}

