/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.domain;

import java.util.Arrays;
import java.util.List;
import org.squashtest.tm.domain.synchronisation.SynchronisationFieldMapping;
import org.squashtest.tm.plugin.jirasync.domain.BuiltinSquashField;

public class FieldMapping
extends SynchronisationFieldMapping {
    private String jiraField;
    private boolean deletable;

    public FieldMapping() {
    }

    public FieldMapping(BuiltinSquashField squashField, String jiraField, boolean locked) {
        this(squashField, jiraField);
        this.setLocked(locked);
    }

    public FieldMapping(BuiltinSquashField squashField, String jiraField) {
        this.squashField = squashField.toString();
        this.jiraField = jiraField;
    }

    public FieldMapping(String squashFieldId, String jiraFieldId) {
        this.squashField = squashFieldId;
        this.jiraField = jiraFieldId;
    }

    public boolean isDeletable() {
        return this.deletable;
    }

    public void setDeletable(boolean deletable) {
        this.deletable = deletable;
    }

    public String getJiraField() {
        return this.jiraField;
    }

    public void setJiraField(String jiraField) {
        this.jiraField = jiraField;
    }

    public static List<FieldMapping> getBuiltinMapping() {
        return Arrays.asList(new FieldMapping(BuiltinSquashField.REFERENCE, "issuekey", true), new FieldMapping(BuiltinSquashField.LABEL, "summary", true), new FieldMapping(BuiltinSquashField.DESCRIPTION, "description", true), new FieldMapping(BuiltinSquashField.CRITICALITY, "priority", true));
    }

    public static FieldMapping byId(String id) {
        return new FieldMapping(id, null);
    }

    public String toString() {
        return this.squashField + "<->" + this.jiraField;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.squashField == null ? 0 : this.squashField.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        FieldMapping other = (FieldMapping)((Object)obj);
        return !(this.squashField == null ? other.squashField != null : !this.squashField.equals(other.squashField));
    }
}

