/*
 * Decompiled with CFR 0.152.
 */
package jirasync.com.atlassian.httpclient.apache.httpcomponents;

import com.google.common.base.Throwables;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import jirasync.com.atlassian.event.api.EventPublisher;
import jirasync.com.atlassian.httpclient.apache.httpcomponents.BannedHostResolver;
import jirasync.com.atlassian.httpclient.apache.httpcomponents.BoundedHttpAsyncClient;
import jirasync.com.atlassian.httpclient.apache.httpcomponents.DefaultHostResolver;
import jirasync.com.atlassian.httpclient.apache.httpcomponents.DefaultResponse;
import jirasync.com.atlassian.httpclient.apache.httpcomponents.EntityTooLargeException;
import jirasync.com.atlassian.httpclient.apache.httpcomponents.MavenUtils;
import jirasync.com.atlassian.httpclient.apache.httpcomponents.PromiseHttpAsyncClient;
import jirasync.com.atlassian.httpclient.apache.httpcomponents.RedirectStrategy;
import jirasync.com.atlassian.httpclient.apache.httpcomponents.RequestEntityEffect;
import jirasync.com.atlassian.httpclient.apache.httpcomponents.SettableFuturePromiseHttpPromiseAsyncClient;
import jirasync.com.atlassian.httpclient.apache.httpcomponents.cache.FlushableHttpCacheStorage;
import jirasync.com.atlassian.httpclient.apache.httpcomponents.cache.FlushableHttpCacheStorageImpl;
import jirasync.com.atlassian.httpclient.apache.httpcomponents.cache.LoggingHttpCacheStorage;
import jirasync.com.atlassian.httpclient.apache.httpcomponents.proxy.ProxyConfigFactory;
import jirasync.com.atlassian.httpclient.apache.httpcomponents.proxy.ProxyCredentialsProvider;
import jirasync.com.atlassian.httpclient.api.HostResolver;
import jirasync.com.atlassian.httpclient.api.HttpClient;
import jirasync.com.atlassian.httpclient.api.HttpStatus;
import jirasync.com.atlassian.httpclient.api.Request;
import jirasync.com.atlassian.httpclient.api.Response;
import jirasync.com.atlassian.httpclient.api.ResponsePromise;
import jirasync.com.atlassian.httpclient.api.ResponsePromises;
import jirasync.com.atlassian.httpclient.api.ResponseTooLargeException;
import jirasync.com.atlassian.httpclient.api.factory.HttpClientOptions;
import jirasync.com.atlassian.httpclient.base.AbstractHttpClient;
import jirasync.com.atlassian.httpclient.base.event.HttpRequestCompletedEvent;
import jirasync.com.atlassian.httpclient.base.event.HttpRequestFailedEvent;
import jirasync.com.atlassian.sal.api.ApplicationProperties;
import jirasync.com.atlassian.sal.api.executor.ThreadLocalContextManager;
import jirasync.io.atlassian.fugue.Suppliers;
import jirasync.io.atlassian.util.concurrent.Promises;
import jirasync.io.atlassian.util.concurrent.ThreadFactories;
import jirasync.org.apache.http.Header;
import jirasync.org.apache.http.HttpEntity;
import jirasync.org.apache.http.HttpResponse;
import jirasync.org.apache.http.StatusLine;
import jirasync.org.apache.http.client.CredentialsProvider;
import jirasync.org.apache.http.client.config.RequestConfig;
import jirasync.org.apache.http.client.methods.HttpDelete;
import jirasync.org.apache.http.client.methods.HttpGet;
import jirasync.org.apache.http.client.methods.HttpHead;
import jirasync.org.apache.http.client.methods.HttpOptions;
import jirasync.org.apache.http.client.methods.HttpPost;
import jirasync.org.apache.http.client.methods.HttpPut;
import jirasync.org.apache.http.client.methods.HttpRequestBase;
import jirasync.org.apache.http.client.methods.HttpTrace;
import jirasync.org.apache.http.config.Registry;
import jirasync.org.apache.http.config.RegistryBuilder;
import jirasync.org.apache.http.conn.ssl.SSLContextBuilder;
import jirasync.org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import jirasync.org.apache.http.conn.ssl.X509HostnameVerifier;
import jirasync.org.apache.http.impl.client.ProxyAuthenticationStrategy;
import jirasync.org.apache.http.impl.client.cache.CacheConfig;
import jirasync.org.apache.http.impl.client.cache.CachingHttpAsyncClient;
import jirasync.org.apache.http.impl.conn.DefaultSchemePortResolver;
import jirasync.org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import jirasync.org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import jirasync.org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import jirasync.org.apache.http.impl.nio.client.HttpAsyncClients;
import jirasync.org.apache.http.impl.nio.conn.ManagedNHttpClientConnectionFactory;
import jirasync.org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import jirasync.org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import jirasync.org.apache.http.impl.nio.reactor.IOReactorConfig;
import jirasync.org.apache.http.nio.client.HttpAsyncClient;
import jirasync.org.apache.http.nio.conn.NoopIOSessionStrategy;
import jirasync.org.apache.http.nio.conn.SchemeIOSessionStrategy;
import jirasync.org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import jirasync.org.apache.http.nio.reactor.IOReactorException;
import jirasync.org.apache.http.nio.reactor.IOReactorExceptionHandler;
import jirasync.org.apache.http.protocol.BasicHttpContext;
import jirasync.org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public final class ApacheAsyncHttpClient<C>
extends AbstractHttpClient
implements HttpClient,
DisposableBean {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final Supplier<String> httpClientVersion = Suppliers.memoize(() -> MavenUtils.getVersion("jirasync.com.atlassian.httpclient", "atlassian-httpclient-api"));
    private final Function<Object, Void> eventConsumer;
    private final Supplier<String> applicationName;
    private final ThreadLocalContextManager<C> threadLocalContextManager;
    private final ExecutorService callbackExecutor;
    private final HttpClientOptions httpClientOptions;
    private final CachingHttpAsyncClient httpClient;
    private final CloseableHttpAsyncClient nonCachingHttpClient;
    private final FlushableHttpCacheStorage httpCacheStorage;

    public ApacheAsyncHttpClient(EventPublisher eventConsumer, ApplicationProperties applicationProperties, ThreadLocalContextManager<C> threadLocalContextManager) {
        this(eventConsumer, applicationProperties, threadLocalContextManager, new HttpClientOptions());
    }

    public ApacheAsyncHttpClient(EventPublisher eventConsumer, ApplicationProperties applicationProperties, ThreadLocalContextManager<C> threadLocalContextManager, HttpClientOptions options) {
        this(new DefaultApplicationNameSupplier(applicationProperties), new EventConsumerFunction(eventConsumer), threadLocalContextManager, options);
    }

    public ApacheAsyncHttpClient(String applicationName) {
        this(applicationName, new HttpClientOptions());
    }

    public ApacheAsyncHttpClient(String applicationName, HttpClientOptions options) {
        this(Suppliers.ofInstance(applicationName), (Object input) -> null, new NoOpThreadLocalContextManager(), options);
    }

    public ApacheAsyncHttpClient(Supplier<String> applicationName, Function<Object, Void> eventConsumer, ThreadLocalContextManager<C> threadLocalContextManager, HttpClientOptions options) {
        this.eventConsumer = Objects.requireNonNull(eventConsumer, "eventConsumer can't be null");
        this.applicationName = Objects.requireNonNull(applicationName, "applicationName can't be null");
        this.threadLocalContextManager = Objects.requireNonNull(threadLocalContextManager, "threadLocalContextManager can't be null");
        this.httpClientOptions = Objects.requireNonNull(options, "options can't be null");
        try {
            IOReactorConfig reactorConfig = IOReactorConfig.custom().setIoThreadCount(options.getIoThreadCount()).setSelectInterval(options.getIoSelectInterval()).setInterestOpQueued(true).build();
            DefaultConnectingIOReactor ioReactor = new DefaultConnectingIOReactor(reactorConfig);
            ioReactor.setExceptionHandler(new IOReactorExceptionHandler(){

                @Override
                public boolean handle(IOException e) {
                    ApacheAsyncHttpClient.this.log.error("IO exception in reactor ", (Throwable)e);
                    return false;
                }

                @Override
                public boolean handle(RuntimeException e) {
                    ApacheAsyncHttpClient.this.log.error("Fatal runtime error", (Throwable)e);
                    return false;
                }
            });
            List<String> bannedAddresses = options.getBlacklistedAddresses();
            HostResolver resolver = bannedAddresses.isEmpty() ? DefaultHostResolver.INSTANCE : new BannedHostResolver(bannedAddresses);
            PoolingNHttpClientConnectionManager connectionManager = new PoolingNHttpClientConnectionManager(ioReactor, ManagedNHttpClientConnectionFactory.INSTANCE, this.getRegistry(options), DefaultSchemePortResolver.INSTANCE, resolver::resolve, options.getConnectionPoolTimeToLive(), TimeUnit.MILLISECONDS){

                @Override
                protected void finalize() {
                }
            };
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout((int)options.getConnectionTimeout()).setConnectionRequestTimeout((int)options.getLeaseTimeout()).setCookieSpec(options.getIgnoreCookies() ? "ignoreCookies" : "default").setSocketTimeout((int)options.getSocketTimeout()).build();
            connectionManager.setDefaultMaxPerRoute(options.getMaxConnectionsPerHost());
            connectionManager.setMaxTotal(options.getMaxTotalConnections());
            HttpAsyncClientBuilder clientBuilder = HttpAsyncClients.custom().setThreadFactory(ThreadFactories.namedThreadFactory(options.getThreadPrefix() + "-io", ThreadFactories.Type.DAEMON)).setDefaultIOReactorConfig(reactorConfig).setConnectionManager(connectionManager).setRedirectStrategy(new RedirectStrategy()).setUserAgent(this.getUserAgent(options)).setDefaultRequestConfig(requestConfig);
            ProxyConfigFactory.getProxyConfig(options).forEach(proxyConfig -> {
                clientBuilder.setRoutePlanner(new SystemDefaultRoutePlanner(DefaultSchemePortResolver.INSTANCE, proxyConfig.toProxySelector()));
                ProxyCredentialsProvider.build(options).forEach(credsProvider -> {
                    clientBuilder.setProxyAuthenticationStrategy(ProxyAuthenticationStrategy.INSTANCE);
                    clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
                });
            });
            this.nonCachingHttpClient = new BoundedHttpAsyncClient(clientBuilder.build(), Ints.saturatedCast((long)options.getMaxEntitySize()));
            CacheConfig cacheConfig = CacheConfig.custom().setMaxCacheEntries(options.getMaxCacheEntries()).setSharedCache(false).setNeverCacheHTTP10ResponsesWithQueryString(false).setMaxObjectSize(options.getMaxCacheObjectSize()).build();
            this.httpCacheStorage = new LoggingHttpCacheStorage(new FlushableHttpCacheStorageImpl(cacheConfig));
            this.httpClient = new CachingHttpAsyncClient((HttpAsyncClient)this.nonCachingHttpClient, this.httpCacheStorage, cacheConfig);
            this.callbackExecutor = options.getCallbackExecutor();
            this.nonCachingHttpClient.start();
        }
        catch (IOReactorException e) {
            throw new RuntimeException("Reactor " + options.getThreadPrefix() + "not set up correctly", e);
        }
    }

    private Registry<SchemeIOSessionStrategy> getRegistry(HttpClientOptions options) {
        try {
            TrustSelfSignedStrategy strategy = options.trustSelfSignedCertificates() ? new TrustSelfSignedStrategy() : null;
            SSLContext sslContext = new SSLContextBuilder().useTLS().loadTrustMaterial(null, strategy).build();
            SSLIOSessionStrategy sslioSessionStrategy = new SSLIOSessionStrategy(sslContext, ApacheAsyncHttpClient.split(System.getProperty("https.protocols")), ApacheAsyncHttpClient.split(System.getProperty("https.cipherSuites")), options.trustSelfSignedCertificates() ? this.getSelfSignedVerifier() : SSLIOSessionStrategy.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
            return RegistryBuilder.create().register("http", NoopIOSessionStrategy.INSTANCE).register("https", (NoopIOSessionStrategy)((Object)sslioSessionStrategy)).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            return this.getFallbackRegistry(e);
        }
    }

    private X509HostnameVerifier getSelfSignedVerifier() {
        return new X509HostnameVerifier(){

            @Override
            public void verify(String host, SSLSocket ssl) {
                ApacheAsyncHttpClient.this.log.debug("Verification for certificates from {0} disabled", (Object)host);
            }

            @Override
            public void verify(String host, X509Certificate cert) {
                ApacheAsyncHttpClient.this.log.debug("Verification for certificates from {0} disabled", (Object)host);
            }

            @Override
            public void verify(String host, String[] cns, String[] subjectAlts) {
                ApacheAsyncHttpClient.this.log.debug("Verification for certificates from {0} disabled", (Object)host);
            }

            @Override
            public boolean verify(String host, SSLSession sslSession) {
                ApacheAsyncHttpClient.this.log.debug("Verification for certificates from {0} disabled", (Object)host);
                return true;
            }
        };
    }

    private Registry<SchemeIOSessionStrategy> getFallbackRegistry(GeneralSecurityException e) {
        this.log.error("Error when creating scheme session strategy registry", (Throwable)e);
        return RegistryBuilder.create().register("http", NoopIOSessionStrategy.INSTANCE).register("https", (NoopIOSessionStrategy)((Object)SSLIOSessionStrategy.getDefaultStrategy())).build();
    }

    private String getUserAgent(HttpClientOptions options) {
        return String.format("Atlassian HttpClient %s / %s / %s", httpClientVersion.get(), this.applicationName.get(), options.getUserAgent());
    }

    @Override
    public final ResponsePromise execute(Request request) {
        try {
            return this.doExecute(request);
        }
        catch (Throwable t) {
            return ResponsePromises.toResponsePromise(Promises.rejected(t));
        }
    }

    private ResponsePromise doExecute(Request request) {
        HttpRequestBase op;
        this.httpClientOptions.getRequestPreparer().accept(request);
        long start = System.currentTimeMillis();
        String uri = request.getUri().toString();
        Request.Method method = request.getMethod();
        switch (method) {
            case GET: {
                op = new HttpGet(uri);
                break;
            }
            case POST: {
                op = new HttpPost(uri);
                break;
            }
            case PUT: {
                op = new HttpPut(uri);
                break;
            }
            case DELETE: {
                op = new HttpDelete(uri);
                break;
            }
            case OPTIONS: {
                op = new HttpOptions(uri);
                break;
            }
            case HEAD: {
                op = new HttpHead(uri);
                break;
            }
            case TRACE: {
                op = new HttpTrace(uri);
                break;
            }
            default: {
                throw new UnsupportedOperationException(method.toString());
            }
        }
        if (request.hasEntity()) {
            new RequestEntityEffect(request).apply(op);
        }
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            op.setHeader(entry.getKey(), entry.getValue());
        }
        PromiseHttpAsyncClient asyncClient = this.getPromiseHttpAsyncClient(request);
        return ResponsePromises.toResponsePromise(asyncClient.execute(op, new BasicHttpContext()).fold(ex -> {
            long requestDuration = System.currentTimeMillis() - start;
            Throwable exception = this.maybeTranslate((Throwable)ex);
            this.publishEvent(request, requestDuration, exception);
            Throwables.throwIfUnchecked((Throwable)exception);
            throw new RuntimeException(exception);
        }, httpResponse -> {
            long requestDuration = System.currentTimeMillis() - start;
            this.publishEvent(request, requestDuration, httpResponse.getStatusLine().getStatusCode());
            try {
                return this.translate((HttpResponse)httpResponse);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }));
    }

    private void publishEvent(Request request, long requestDuration, int statusCode) {
        if (HttpStatus.OK.code <= statusCode && statusCode < HttpStatus.MULTIPLE_CHOICES.code) {
            this.eventConsumer.apply(new HttpRequestCompletedEvent(request.getUri().toString(), request.getMethod().name(), statusCode, requestDuration, request.getAttributes()));
        } else {
            this.eventConsumer.apply(new HttpRequestFailedEvent(request.getUri().toString(), request.getMethod().name(), statusCode, requestDuration, request.getAttributes()));
        }
    }

    private void publishEvent(Request request, long requestDuration, Throwable ex) {
        this.eventConsumer.apply(new HttpRequestFailedEvent(request.getUri().toString(), request.getMethod().name(), ex.toString(), requestDuration, request.getAttributes()));
    }

    private PromiseHttpAsyncClient getPromiseHttpAsyncClient(Request request) {
        return new SettableFuturePromiseHttpPromiseAsyncClient<C>(request.isCacheDisabled() ? this.nonCachingHttpClient : this.httpClient, this.threadLocalContextManager, this.callbackExecutor);
    }

    private Throwable maybeTranslate(Throwable ex) {
        if (ex instanceof EntityTooLargeException) {
            EntityTooLargeException tooLarge = (EntityTooLargeException)ex;
            try {
                return new ResponseTooLargeException(this.translate(tooLarge.getResponse()), ex.getMessage());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return ex;
    }

    private Response translate(HttpResponse httpResponse) throws IOException {
        Header[] httpHeaders;
        StatusLine status = httpResponse.getStatusLine();
        DefaultResponse.DefaultResponseBuilder responseBuilder = DefaultResponse.builder().setMaxEntitySize(this.httpClientOptions.getMaxEntitySize()).setStatusCode(status.getStatusCode()).setStatusText(status.getReasonPhrase());
        for (Header httpHeader : httpHeaders = httpResponse.getAllHeaders()) {
            responseBuilder.setHeader(httpHeader.getName(), httpHeader.getValue());
        }
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            responseBuilder.setEntityStream(entity.getContent());
        }
        return (Response)responseBuilder.build();
    }

    public void destroy() throws Exception {
        this.callbackExecutor.shutdown();
        this.nonCachingHttpClient.close();
    }

    @Override
    public void flushCacheByUriPattern(Pattern urlPattern) {
        this.httpCacheStorage.flushByUriPattern(urlPattern);
    }

    private static String[] split(String s) {
        if (TextUtils.isBlank(s)) {
            return null;
        }
        return s.split(" *, *");
    }

    private static class EventConsumerFunction
    implements Function<Object, Void> {
        private final EventPublisher eventPublisher;

        EventConsumerFunction(EventPublisher eventPublisher) {
            this.eventPublisher = eventPublisher;
        }

        @Override
        public Void apply(Object event) {
            this.eventPublisher.publish(event);
            return null;
        }
    }

    private static final class DefaultApplicationNameSupplier
    implements Supplier<String> {
        private final ApplicationProperties applicationProperties;

        DefaultApplicationNameSupplier(ApplicationProperties applicationProperties) {
            this.applicationProperties = Objects.requireNonNull(applicationProperties);
        }

        @Override
        public String get() {
            return String.format("%s-%s (%s)", this.applicationProperties.getDisplayName(), this.applicationProperties.getVersion(), this.applicationProperties.getBuildNumber());
        }
    }

    private static final class NoOpThreadLocalContextManager<C>
    implements ThreadLocalContextManager<C> {
        private NoOpThreadLocalContextManager() {
        }

        @Override
        public C getThreadLocalContext() {
            return null;
        }

        @Override
        public void setThreadLocalContext(C context) {
        }

        @Override
        public void clearThreadLocalContext() {
        }
    }
}

