/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.internal;

import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.RedmineFormatException;
import com.taskadapter.redmineapi.RedmineInternalError;
import com.taskadapter.redmineapi.RedmineManager;
import com.taskadapter.redmineapi.bean.IssueCategory;
import com.taskadapter.redmineapi.bean.Membership;
import com.taskadapter.redmineapi.bean.Project;
import com.taskadapter.redmineapi.internal.RedmineJSONBuilder;
import com.taskadapter.redmineapi.internal.RedmineJSONParser;
import com.taskadapter.redmineapi.internal.comm.BaseCommunicator;
import com.taskadapter.redmineapi.internal.comm.BasicHttpResponse;
import com.taskadapter.redmineapi.internal.comm.Communicator;
import com.taskadapter.redmineapi.internal.comm.Communicators;
import com.taskadapter.redmineapi.internal.comm.SimpleCommunicator;
import com.taskadapter.redmineapi.internal.comm.redmine.RedmineAuthenticator;
import com.taskadapter.redmineapi.internal.comm.redmine.RedmineErrorHandler;
import com.taskadapter.redmineapi.internal.json.JsonInput;
import com.taskadapter.redmineapi.internal.json.JsonObjectParser;
import com.taskadapter.redmineapi.internal.json.JsonObjectWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.HttpResponse;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.NameValuePair;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.client.methods.HttpGet;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.message.BasicNameValuePair;
import org.squashtest.tm.plugin.bugtracker.redmine3.json.JSONException;
import org.squashtest.tm.plugin.bugtracker.redmine3.json.JSONObject;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.bean.ExtendedCustomField;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.bean.ExtendedRole;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.bean.ExtendedTracker;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.internal.ExtendedRedmine3JsonParser;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.internal.ExtendedURIConfigurator;
import org.squashtest.tm.plugin.bugtracker.redmine3.utils.BaseCommunicatorFactory;

public class ExtendedTransport {
    private static final Map<Class<?>, EntityConfig<?>> OBJECT_CONFIGS = new HashMap();
    private static final int DEFAULT_OBJECTS_PER_PAGE = 25;
    private static final String KEY_TOTAL_COUNT = "total_count";
    private static final Logger logger = LoggerFactory.getLogger(RedmineManager.class);
    private final SimpleCommunicator<String> communicator;
    private final Communicator<BasicHttpResponse> errorCheckingCommunicator;
    private final BaseCommunicator baseCommunicator;
    private final RedmineAuthenticator<HttpResponse> authenticator;
    private final ExtendedURIConfigurator configurator;
    private String login;
    private String password;
    private int objectsPerPage = 25;
    private static final String CHARSET = "UTF-8";

    static {
        OBJECT_CONFIGS.put(ExtendedCustomField.class, ExtendedTransport.config("custom_field", "custom_fields", null, ExtendedRedmine3JsonParser.CUSTOM_FIELD_PARSER));
        OBJECT_CONFIGS.put(ExtendedTracker.class, ExtendedTransport.config("tracker", "trackers", null, ExtendedRedmine3JsonParser.TRACKER_PARSER));
        OBJECT_CONFIGS.put(ExtendedRole.class, ExtendedTransport.config("role", "roles", null, ExtendedRedmine3JsonParser.ROLE_PARSER));
        OBJECT_CONFIGS.put(IssueCategory.class, ExtendedTransport.config("issue_category", "issue_categories", null, RedmineJSONParser.CATEGORY_PARSER));
        OBJECT_CONFIGS.put(Project.class, ExtendedTransport.config("project", "projects", null, RedmineJSONParser.PROJECT_PARSER));
        OBJECT_CONFIGS.put(Membership.class, ExtendedTransport.config("membership", "memberships", RedmineJSONBuilder.MEMBERSHIP_WRITER, RedmineJSONParser.MEMBERSHIP_PARSER));
    }

    public ExtendedTransport(ExtendedURIConfigurator extendedURIConfigurator, BaseCommunicatorFactory baseCommunicatorFactory) {
        this.configurator = extendedURIConfigurator;
        this.baseCommunicator = baseCommunicatorFactory.initializeBaseCommunicator();
        this.authenticator = new RedmineAuthenticator<HttpResponse>(this.baseCommunicator, CHARSET);
        RedmineErrorHandler errorProcessor = new RedmineErrorHandler();
        this.errorCheckingCommunicator = Communicators.fmap(this.authenticator, Communicators.compose(errorProcessor, Communicators.transportDecoder()));
        Communicator<String> coreCommunicator = Communicators.fmap(this.errorCheckingCommunicator, Communicators.contentReader());
        this.communicator = Communicators.simplify(coreCommunicator, Communicators.identityHandler());
    }

    public <T> List<T> getObjectsList(Class<T> objectClass, NameValuePair ... params) throws RedmineException {
        return this.getObjectsList(objectClass, Arrays.asList(params));
    }

    public <T> List<T> getObjectsList(Class<T> objectClass, Collection<? extends NameValuePair> params) throws RedmineException {
        int totalObjectsFoundOnServer;
        List foundItems;
        EntityConfig<T> config = this.getConfig(objectClass);
        ArrayList result = new ArrayList();
        ArrayList<? extends NameValuePair> newParams = new ArrayList<NameValuePair>(params);
        newParams.add(new BasicNameValuePair("limit", String.valueOf(this.objectsPerPage)));
        int offset = 0;
        do {
            ArrayList<? extends NameValuePair> paramsList = new ArrayList<NameValuePair>(newParams);
            paramsList.add(new BasicNameValuePair("offset", String.valueOf(offset)));
            URI uri = this.getURIConfigurator().getObjectsURI(objectClass, paramsList);
            logger.debug(uri.toString());
            HttpGet http = new HttpGet(uri);
            String response = this.getCommunicator().sendRequest(http);
            logger.debug("received: " + response);
            try {
                JSONObject responseObject = RedmineJSONParser.getResponse(response);
                logger.debug(responseObject.toString());
                foundItems = JsonInput.getListOrNull(responseObject, config.multiObjectName, config.parser);
                result.addAll(foundItems);
                if (!responseObject.has(KEY_TOTAL_COUNT)) break;
                totalObjectsFoundOnServer = JsonInput.getInt(responseObject, KEY_TOTAL_COUNT);
            }
            catch (JSONException e) {
                throw new RedmineFormatException(e);
            }
        } while (!foundItems.isEmpty() && (offset += foundItems.size()) < totalObjectsFoundOnServer);
        return result;
    }

    public int getObjectsPerPage() {
        return this.objectsPerPage;
    }

    public void setObjectsPerPage(int pageSize) {
        if (pageSize <= 0) {
            throw new IllegalArgumentException("Page size must be >= 0. You provided: " + pageSize);
        }
        this.objectsPerPage = pageSize;
    }

    private SimpleCommunicator<String> getCommunicator() throws RedmineException {
        return this.communicator;
    }

    private <T> EntityConfig<T> getConfig(Class<?> class1) {
        EntityConfig<?> guess = OBJECT_CONFIGS.get(class1);
        if (guess == null) {
            throw new RedmineInternalError("Unsupported class " + String.valueOf(class1));
        }
        return guess;
    }

    private ExtendedURIConfigurator getURIConfigurator() {
        return this.configurator;
    }

    private static <T> EntityConfig<T> config(String objectField, String urlPrefix, JsonObjectWriter<T> writer, JsonObjectParser<T> parser) {
        return new EntityConfig<T>(objectField, urlPrefix, writer, parser);
    }

    public void setCredentials(String login, String password) {
        this.login = login;
        this.password = password;
        this.authenticator.setCredentials(login, password);
    }

    public void setPassword(String password) {
        this.setCredentials(this.login, password);
    }

    public void setLogin(String login) {
        this.setCredentials(login, this.password);
    }

    public <T> T getObject(Class<T> classs, String key, NameValuePair ... args) throws RedmineException {
        EntityConfig<T> config = this.getConfig(classs);
        URI uri = this.getURIConfigurator().getObjectURI(classs, key, args);
        HttpGet http = new HttpGet(uri);
        String response = this.getCommunicator().sendRequest(http);
        logger.debug(response);
        return ExtendedTransport.parseResponse(response, config.singleObjectName, config.parser);
    }

    private static <T> T parseResponse(String response, String tag, JsonObjectParser<T> parser) throws RedmineFormatException {
        try {
            return parser.parse(RedmineJSONParser.getResponseSingleObject(response, tag));
        }
        catch (JSONException e) {
            throw new RedmineFormatException(e);
        }
    }

    public <T> T getObject(Class<T> classs, Integer key, NameValuePair ... args) throws RedmineException {
        return this.getObject(classs, key.toString(), args);
    }

    public <T> List<T> getChildEntries(Class<?> parentClass, String parentId, Class<T> classs) throws RedmineException {
        int totalObjectsFoundOnServer;
        List foundItems;
        EntityConfig<T> config = this.getConfig(classs);
        ArrayList result = new ArrayList();
        int offset = 0;
        do {
            URI uri = this.getURIConfigurator().getChildObjectsURI(parentClass, parentId, classs, new BasicNameValuePair("limit", String.valueOf(this.objectsPerPage)), new BasicNameValuePair("offset", String.valueOf(offset)));
            logger.debug(uri.toString());
            HttpGet http = new HttpGet(uri);
            String response = this.getCommunicator().sendRequest(http);
            logger.debug("received: " + response);
            try {
                JSONObject responseObject = RedmineJSONParser.getResponse(response);
                logger.debug(responseObject.toString());
                foundItems = JsonInput.getListOrNull(responseObject, config.multiObjectName, config.parser);
                result.addAll(foundItems);
                totalObjectsFoundOnServer = JsonInput.getInt(responseObject, KEY_TOTAL_COUNT);
            }
            catch (JSONException e) {
                throw new RedmineFormatException(e);
            }
        } while (!foundItems.isEmpty() && (offset += foundItems.size()) < totalObjectsFoundOnServer);
        return result;
    }

    static class EntityConfig<T> {
        private final String singleObjectName;
        private final String multiObjectName;
        private final JsonObjectWriter<T> writer;
        private final JsonObjectParser<T> parser;

        public EntityConfig(String objectField, String urlPrefix, JsonObjectWriter<T> writer, JsonObjectParser<T> parser) {
            this.singleObjectName = objectField;
            this.multiObjectName = urlPrefix;
            this.writer = writer;
            this.parser = parser;
        }
    }
}

