/*
 * Decompiled with CFR 0.152.
 */
package workflowautomjira.org.apache.http.protocol;

import java.io.IOException;
import workflowautomjira.org.apache.http.HttpEntityEnclosingRequest;
import workflowautomjira.org.apache.http.HttpException;
import workflowautomjira.org.apache.http.HttpRequest;
import workflowautomjira.org.apache.http.HttpRequestInterceptor;
import workflowautomjira.org.apache.http.annotation.Contract;
import workflowautomjira.org.apache.http.annotation.ThreadingBehavior;
import workflowautomjira.org.apache.http.protocol.HttpContext;
import workflowautomjira.org.apache.http.protocol.HttpDateGenerator;
import workflowautomjira.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

