/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.campaignassessment.data;

import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import jakarta.persistence.EntityManager;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.jooq.DSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.squashtest.tm.api.report.criteria.Criteria;
import org.squashtest.tm.api.report.exception.PerimeterNotAvailableException;
import org.squashtest.tm.api.utils.AttachmentImageHelper;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.plugin.report.campaignassessment.data.AbstractReportDataBuilder;
import org.squashtest.tm.plugin.report.campaignassessment.dto.AbstractTupleTemplate;
import org.squashtest.tm.plugin.report.campaignassessment.dto.CampaignInfo;
import org.squashtest.tm.plugin.report.campaignassessment.dto.CampaignTupleTemplate;
import org.squashtest.tm.plugin.report.campaignassessment.dto.I18nHelper;
import org.squashtest.tm.plugin.report.campaignassessment.dto.IterationInfo;
import org.squashtest.tm.plugin.report.campaignassessment.dto.Queries;
import org.squashtest.tm.plugin.report.campaignassessment.form.CampaignFormParameter;
import org.squashtest.tm.service.bugtracker.BugTrackersLocalService;
import org.squashtest.tm.service.bugtracker.BugTrackersService;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.AbstractDefaultLocalKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.CampaignKnownIssueFinder;
import org.squashtest.tm.service.internal.repository.display.EntityPathHeaderDao;
import org.squashtest.tm.service.project.CustomProjectFinder;

@Component
public class CampaignReportDataBuilder
extends AbstractReportDataBuilder {
    private static final Logger LOGGER;
    private static final String CAMPAIGN_FILE_NAME_I18N_KEY = "report.campaignassessment.file.name";
    private static final String CAMPAIGNS = "campaigns";
    private final CampaignKnownIssueFinder campaignKnownIssueFinder;
    private List<Long> readableProjectIds;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    public CampaignReportDataBuilder(I18nHelper i18nHelper, EntityManager entityManager, EntityPathHeaderDao entityPathHeaderDao, BugTrackersLocalService bugTrackersLocalService, BugTrackersService bugTrackersService, AttachmentImageHelper attachmentImageHelper, DSLContext dslContext, CustomProjectFinder customProjectFinder, CampaignKnownIssueFinder campaignKnownIssueFinder) {
        super(i18nHelper, entityManager, entityPathHeaderDao, bugTrackersLocalService, bugTrackersService, attachmentImageHelper, dslContext, customProjectFinder);
        CampaignKnownIssueFinder campaignKnownIssueFinder2;
        CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class);
        this.readableProjectIds = IndyInterface.bootstrap("cast", "()", 0, callSite);
        this.campaignKnownIssueFinder = campaignKnownIssueFinder2 = campaignKnownIssueFinder;
    }

    @Override
    public Map<String, Object> build(Map<String, Criteria> formParameters, Map<String, Object> results) {
        IndyInterface.bootstrap("invoke", "debug", 0, LOGGER, "Starting campaign report data generation.");
        CallSite campaigns = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "fetchCampaignsInfo", 2, this, formParameters));
        IndyInterface.bootstrap("invoke", "debug", 0, LOGGER, "Readable campaign count: {}", IndyInterface.bootstrap("invoke", "size", 0, campaigns));
        CallSite reportData = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "buildCampaignDataMap", 2, this, formParameters, campaigns, results));
        IndyInterface.bootstrap("invoke", "addCommonReportMetadata", 2, this, formParameters, reportData, CAMPAIGN_FILE_NAME_I18N_KEY, IndyInterface.bootstrap("invoke", "getKey", 0, IndyInterface.bootstrap("getProperty", "TEMPLATE_FILE_NAME", 0, CampaignFormParameter.class)));
        IndyInterface.bootstrap("invoke", "debug", 0, LOGGER, "Campaign report data generation completed.");
        return reportData;
    }

    private List<CampaignInfo> fetchCampaignsInfo(Map<String, Object> formParameters) {
        CallSite campaigns = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "fetchCampaignsFromDb", 2, this, formParameters));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, campaigns)) != false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, PerimeterNotAvailableException.class));
        }
        return campaigns;
    }

    private List<CampaignInfo> fetchCampaignsFromDb(Map<String, Object> formParameters) {
        CallSite campaignIds = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "extractCampaignIds", 0, CampaignReportDataBuilder.class, formParameters));
        CallSite callSite = IndyInterface.bootstrap("invoke", "findReadableProjectIdsOnCampaignLibrary", 0, IndyInterface.bootstrap("getProperty", "customProjectFinder", 12, this));
        this.readableProjectIds = IndyInterface.bootstrap("cast", "()", 0, callSite);
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "fetchInto", 0, IndyInterface.bootstrap("invoke", "where", 0, IndyInterface.bootstrap("invoke", "on", 0, IndyInterface.bootstrap("invoke", "join", 0, IndyInterface.bootstrap("invoke", "on", 0, IndyInterface.bootstrap("invoke", "join", 0, IndyInterface.bootstrap("invoke", "from", 0, IndyInterface.bootstrap("invoke", "select", 0, IndyInterface.bootstrap("getProperty", "dslContext", 12, this), IndyInterface.bootstrap("getProperty", "CLN_ID", 0, IndyInterface.bootstrap("getProperty", "CAMPAIGN", 0, Tables.class)), IndyInterface.bootstrap("getProperty", "REFERENCE", 0, IndyInterface.bootstrap("getProperty", "CAMPAIGN", 0, Tables.class)), IndyInterface.bootstrap("getProperty", "NAME", 0, IndyInterface.bootstrap("getProperty", "CAMPAIGN_LIBRARY_NODE", 0, Tables.class)), IndyInterface.bootstrap("getProperty", "DESCRIPTION", 0, IndyInterface.bootstrap("getProperty", "CAMPAIGN_LIBRARY_NODE", 0, Tables.class)), IndyInterface.bootstrap("getProperty", "SCHEDULED_START_DATE", 0, IndyInterface.bootstrap("getProperty", "CAMPAIGN", 0, Tables.class)), IndyInterface.bootstrap("getProperty", "SCHEDULED_END_DATE", 0, IndyInterface.bootstrap("getProperty", "CAMPAIGN", 0, Tables.class)), IndyInterface.bootstrap("getProperty", "ACTUAL_START_DATE", 0, IndyInterface.bootstrap("getProperty", "CAMPAIGN", 0, Tables.class)), IndyInterface.bootstrap("getProperty", "ACTUAL_END_DATE", 0, IndyInterface.bootstrap("getProperty", "CAMPAIGN", 0, Tables.class)), IndyInterface.bootstrap("getProperty", "PROJECT_ID", 0, IndyInterface.bootstrap("getProperty", "PROJECT", 0, Tables.class)), IndyInterface.bootstrap("getProperty", "NAME", 0, IndyInterface.bootstrap("getProperty", "PROJECT", 0, Tables.class)), IndyInterface.bootstrap("getProperty", "BUGTRACKER_ID", 0, IndyInterface.bootstrap("getProperty", "PROJECT", 0, Tables.class))), IndyInterface.bootstrap("getProperty", "CAMPAIGN", 0, Tables.class)), IndyInterface.bootstrap("getProperty", "CAMPAIGN_LIBRARY_NODE", 0, Tables.class)), IndyInterface.bootstrap("invoke", "eq", 0, IndyInterface.bootstrap("getProperty", "CLN_ID", 0, IndyInterface.bootstrap("getProperty", "CAMPAIGN", 0, Tables.class)), IndyInterface.bootstrap("getProperty", "CLN_ID", 0, IndyInterface.bootstrap("getProperty", "CAMPAIGN_LIBRARY_NODE", 0, Tables.class)))), IndyInterface.bootstrap("getProperty", "PROJECT", 0, Tables.class)), IndyInterface.bootstrap("invoke", "eq", 0, IndyInterface.bootstrap("getProperty", "PROJECT_ID", 0, IndyInterface.bootstrap("getProperty", "CAMPAIGN_LIBRARY_NODE", 0, Tables.class)), IndyInterface.bootstrap("getProperty", "PROJECT_ID", 0, IndyInterface.bootstrap("getProperty", "PROJECT", 0, Tables.class)))), IndyInterface.bootstrap("invoke", "and", 0, IndyInterface.bootstrap("invoke", "in", 0, IndyInterface.bootstrap("getProperty", "CLN_ID", 0, IndyInterface.bootstrap("getProperty", "CAMPAIGN", 0, Tables.class)), campaignIds), IndyInterface.bootstrap("invoke", "in", 0, IndyInterface.bootstrap("getProperty", "PROJECT_ID", 0, IndyInterface.bootstrap("getProperty", "PROJECT", 0, Tables.class)), this.readableProjectIds))), CampaignInfo.class));
    }

    private static List<Long> extractCampaignIds(Map<String, Object> formParameters) {
        Criteria param = (Criteria)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "get", 0, formParameters, IndyInterface.bootstrap("invoke", "getKey", 0, IndyInterface.bootstrap("getProperty", "CAMPAIGN_IDS", 0, CampaignFormParameter.class))), Criteria.class);
        if (!(IndyInterface.bootstrap("invoke", "getValue", 1, param) instanceof Map)) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, "Invalid campaign parameter format"));
        }
        Map idsData = (Map)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getValue", 0, param), Map.class));
        List idList = (List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "get", 0, idsData, CAMPAIGNS), List.class));
        public final class _extractCampaignIds_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _extractCampaignIds_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "toLong", 0, IndyInterface.bootstrap("invoke", "toString", 0, it));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _extractCampaignIds_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, idList, new _extractCampaignIds_closure1(CampaignReportDataBuilder.class, CampaignReportDataBuilder.class)));
    }

    private Map<String, Object> buildCampaignDataMap(Map<String, Criteria> formParameters, List<CampaignInfo> campaigns, Map<String, Object> results) {
        CallSite campaignDataMap = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashMap.class));
        CallSite campaignIterations = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "fetchCampaignIterations", 2, this, campaigns));
        CallSite campaignList = IndyInterface.bootstrap("invoke", "buildTemplateFriendlyCampaignData", 2, this, campaigns, results, campaignIterations);
        IndyInterface.bootstrap("invoke", "put", 0, campaignDataMap, CAMPAIGNS, campaignList);
        IndyInterface.bootstrap("invoke", "addLegacyCampaignFields", 0, CampaignReportDataBuilder.class, IndyInterface.bootstrap("invoke", "get", 0, campaignList, false), campaignDataMap);
        boolean includeAnnex = DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "getValue", 0, IndyInterface.bootstrap("invoke", "get", 0, formParameters, IndyInterface.bootstrap("invoke", "getKey", 0, IndyInterface.bootstrap("getProperty", "INCLUDE_ANNEX", 0, CampaignFormParameter.class)))));
        boolean includeIterationDetail = DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "getValue", 0, IndyInterface.bootstrap("invoke", "get", 0, formParameters, IndyInterface.bootstrap("invoke", "getKey", 0, IndyInterface.bootstrap("getProperty", "INCLUDE_ITERATION_DETAILS", 0, CampaignFormParameter.class)))));
        IndyInterface.bootstrap("invoke", "put", 0, campaignDataMap, "includeAnnex", includeAnnex);
        IndyInterface.bootstrap("invoke", "put", 0, campaignDataMap, "includeIterationDetails", includeIterationDetail);
        IndyInterface.bootstrap("invoke", "putAll", 0, campaignDataMap, IndyInterface.bootstrap("invoke", "getComputedData", 2, this, campaignList, includeAnnex, includeIterationDetail));
        IndyInterface.bootstrap("invoke", "putAll", 0, campaignDataMap, IndyInterface.bootstrap("invoke", "getIssuesData", 2, this, formParameters, campaignList));
        return campaignDataMap;
    }

    private Map<Long, List<IterationInfo>> fetchCampaignIterations(List<CampaignInfo> campaigns) {
        public final class _fetchCampaignIterations_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _fetchCampaignIterations_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("getProperty", "id", 0, it);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _fetchCampaignIterations_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite campaignIds = IndyInterface.bootstrap("invoke", "collect", 0, campaigns, new _fetchCampaignIterations_closure2(this, this));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "fetchGroups", 0, IndyInterface.bootstrap("invoke", "where", 0, IndyInterface.bootstrap("invoke", "buildBaseIterationQuery", 2, this), IndyInterface.bootstrap("invoke", "and", 0, IndyInterface.bootstrap("invoke", "in", 0, IndyInterface.bootstrap("getProperty", "CAMPAIGN_ID", 0, IndyInterface.bootstrap("getProperty", "CAMPAIGN_ITERATION", 0, Tables.class)), campaignIds), IndyInterface.bootstrap("invoke", "in", 0, IndyInterface.bootstrap("getProperty", "PROJECT_ID", 0, IndyInterface.bootstrap("getProperty", "PROJECT", 0, Tables.class)), this.readableProjectIds))), IndyInterface.bootstrap("getProperty", "CAMPAIGN_ID", 0, IndyInterface.bootstrap("getProperty", "CAMPAIGN_ITERATION", 0, Tables.class)), IterationInfo.class));
    }

    /*
     * WARNING - void declaration
     */
    private List<Map<String, Object>> buildTemplateFriendlyCampaignData(List<CampaignInfo> campaigns, Map<String, Object> results, Map<Long, List<IterationInfo>> campaignIterations) {
        void var3_3;
        Reference results2 = new Reference(results);
        Reference campaignIterations2 = new Reference((Object)var3_3);
        public final class _buildTemplateFriendlyCampaignData_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _buildTemplateFriendlyCampaignData_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("getProperty", "id", 0, it);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildTemplateFriendlyCampaignData_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        Reference campaignParentPathMap = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getCampaignBreadcrumbNodes", 0, IndyInterface.bootstrap("getProperty", "entityPathHeaderDao", 12, this), IndyInterface.bootstrap("invoke", "unique", 0, IndyInterface.bootstrap("invoke", "collect", 0, campaigns, new _buildTemplateFriendlyCampaignData_closure3(this, this))), true)));
        public final class _buildTemplateFriendlyCampaignData_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference campaignParentPathMap;
            private /* synthetic */ Reference results;
            private /* synthetic */ Reference campaignIterations;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _buildTemplateFriendlyCampaignData_closure4(Object _outerInstance, Object _thisObject, Reference campaignParentPathMap, Reference results, Reference campaignIterations) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.campaignParentPathMap = reference3 = campaignParentPathMap;
                this.results = reference2 = results;
                this.campaignIterations = reference = campaignIterations;
            }

            public Object doCall(List coll, CampaignInfo campaign) {
                CallSite campaignValues = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashMap.class));
                IndyInterface.bootstrap("invoke", "put", 0, campaignValues, "id", IndyInterface.bootstrap("invoke", "getId", 0, campaign));
                CallSite parentPath = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "buildParentPath", 2, this, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("cast", "()", 0, this.campaignParentPathMap.get()), IndyInterface.bootstrap("invoke", "getId", 0, campaign))));
                IndyInterface.bootstrap("invoke", "put", 0, campaignValues, "parentPath", parentPath);
                CallSite fullName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "buildFullName", 2, this, IndyInterface.bootstrap("invoke", "getReference", 0, campaign), IndyInterface.bootstrap("invoke", "getName", 0, campaign)));
                CallSite path = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "buildEntityPath", 2, this, parentPath, fullName));
                IndyInterface.bootstrap("invoke", "put", 0, campaignValues, "path", path);
                CallSite description = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, StringUtils.class, IndyInterface.bootstrap("invoke", "getDescription", 0, campaign))) != false ? IndyInterface.bootstrap("getProperty", "EMPTY", 0, StringUtils.class) : IndyInterface.bootstrap("invoke", "getDescription", 0, campaign));
                IndyInterface.bootstrap("invoke", "put", 0, campaignValues, "noDescription", IndyInterface.bootstrap("invoke", "hasNoDescription", 2, this, description));
                IndyInterface.bootstrap("invoke", "put", 0, campaignValues, "description", IndyInterface.bootstrap("invoke", "richTextReplace", 2, this, description, IndyInterface.bootstrap("cast", "()", 0, this.results.get())));
                IndyInterface.bootstrap("invoke", "put", 0, campaignValues, "reference", IndyInterface.bootstrap("invoke", "getReference", 0, campaign));
                IndyInterface.bootstrap("invoke", "put", 0, campaignValues, "name", IndyInterface.bootstrap("invoke", "getName", 0, campaign));
                IndyInterface.bootstrap("invoke", "put", 0, campaignValues, "fullName", fullName);
                IndyInterface.bootstrap("invoke", "put", 0, campaignValues, "nameWithProject", IndyInterface.bootstrap("invoke", "buildEntityNameWithProjectName", 2, this, IndyInterface.bootstrap("invoke", "getProjectName", 0, campaign), IndyInterface.bootstrap("invoke", "getName", 0, campaign)));
                IndyInterface.bootstrap("invoke", "put", 0, campaignValues, "projectId", IndyInterface.bootstrap("invoke", "getProjectId", 0, campaign));
                IndyInterface.bootstrap("invoke", "put", 0, campaignValues, "projectName", IndyInterface.bootstrap("invoke", "getProjectName", 0, campaign));
                IndyInterface.bootstrap("invoke", "put", 0, campaignValues, "bugtrackerId", IndyInterface.bootstrap("invoke", "getBugtrackerId", 0, campaign));
                IndyInterface.bootstrap("invoke", "put", 0, campaignValues, "estimatedStartDate", IndyInterface.bootstrap("invoke", "translateDateShort", 0, IndyInterface.bootstrap("getProperty", "i18nHelper", 8, this), IndyInterface.bootstrap("invoke", "getScheduledStartDate", 0, campaign)));
                IndyInterface.bootstrap("invoke", "put", 0, campaignValues, "estimatedEndDate", IndyInterface.bootstrap("invoke", "translateDateShort", 0, IndyInterface.bootstrap("getProperty", "i18nHelper", 8, this), IndyInterface.bootstrap("invoke", "getScheduledEndDate", 0, campaign)));
                IndyInterface.bootstrap("invoke", "put", 0, campaignValues, "realizedStartDate", IndyInterface.bootstrap("invoke", "translateDateShort", 0, IndyInterface.bootstrap("getProperty", "i18nHelper", 8, this), IndyInterface.bootstrap("invoke", "getActualStartDate", 0, campaign)));
                IndyInterface.bootstrap("invoke", "put", 0, campaignValues, "realizedEndDate", IndyInterface.bootstrap("invoke", "translateDateShort", 0, IndyInterface.bootstrap("getProperty", "i18nHelper", 8, this), IndyInterface.bootstrap("invoke", "getActualEndDate", 0, campaign)));
                IndyInterface.bootstrap("invoke", "put", 0, campaignValues, "noEstimatedStartDate", ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getScheduledStartDate", 0, campaign), null));
                IndyInterface.bootstrap("invoke", "put", 0, campaignValues, "noEstimatedEndDate", ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getScheduledEndDate", 0, campaign), null));
                IndyInterface.bootstrap("invoke", "put", 0, campaignValues, "noRealizedStartDate", ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getActualStartDate", 0, campaign), null));
                IndyInterface.bootstrap("invoke", "put", 0, campaignValues, "noRealizedEndDate", ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getActualEndDate", 0, campaign), null));
                IndyInterface.bootstrap("invoke", "put", 0, campaignValues, "iterations", IndyInterface.bootstrap("invoke", "buildCampaignIterations", 2, this, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("cast", "()", 0, this.campaignIterations.get()), IndyInterface.bootstrap("invoke", "getId", 0, campaign)), IndyInterface.bootstrap("cast", "()", 0, this.results.get()), path));
                IndyInterface.bootstrap("invoke", "add", 0, coll, campaignValues);
                return coll;
            }

            @Generated
            public Object call(List coll, CampaignInfo campaign) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, coll, campaign);
            }

            @Generated
            public Map getCampaignParentPathMap() {
                return IndyInterface.bootstrap("cast", "()", 0, this.campaignParentPathMap.get());
            }

            @Generated
            public Map getResults() {
                return IndyInterface.bootstrap("cast", "()", 0, this.results.get());
            }

            @Generated
            public Map getCampaignIterations() {
                return IndyInterface.bootstrap("cast", "()", 0, this.campaignIterations.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildTemplateFriendlyCampaignData_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite result = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "inject", 0, campaigns, ScriptBytecodeAdapter.createList((Object[])new Object[0]), new _buildTemplateFriendlyCampaignData_closure4(this, this, campaignParentPathMap, results2, campaignIterations2)));
        public final class _buildTemplateFriendlyCampaignData_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _buildTemplateFriendlyCampaignData_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return (String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getAt", 0, it, "path"), String.class));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildTemplateFriendlyCampaignData_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "sort", 0, result, new _buildTemplateFriendlyCampaignData_closure5(this, this));
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private List<Map<String, Object>> buildCampaignIterations(List<IterationInfo> iterations, Map<String, Object> results, String campaignPath) {
        void var3_3;
        Reference results2 = new Reference(results);
        Reference campaignPath2 = new Reference((Object)var3_3);
        public final class _buildCampaignIterations_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference campaignPath;
            private /* synthetic */ Reference results;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _buildCampaignIterations_closure6(Object _outerInstance, Object _thisObject, Reference campaignPath, Reference results) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.campaignPath = reference2 = campaignPath;
                this.results = reference = results;
            }

            public Object doCall(List coll, IterationInfo iteration) {
                CallSite iterationValues = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashMap.class));
                IndyInterface.bootstrap("invoke", "put", 0, iterationValues, "id", IndyInterface.bootstrap("invoke", "getId", 0, iteration));
                IndyInterface.bootstrap("invoke", "put", 0, iterationValues, "name", IndyInterface.bootstrap("invoke", "getName", 0, iteration));
                IndyInterface.bootstrap("invoke", "put", 0, iterationValues, "fullName", IndyInterface.bootstrap("invoke", "buildFullName", 2, this, IndyInterface.bootstrap("invoke", "getReference", 0, iteration), IndyInterface.bootstrap("invoke", "getName", 0, iteration)));
                IndyInterface.bootstrap("invoke", "put", 0, iterationValues, "parentPath", IndyInterface.bootstrap("cast", "()", 0, this.campaignPath.get()));
                CallSite description = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, StringUtils.class, IndyInterface.bootstrap("invoke", "getDescription", 0, iteration))) != false ? IndyInterface.bootstrap("getProperty", "EMPTY", 0, StringUtils.class) : IndyInterface.bootstrap("invoke", "getDescription", 0, iteration));
                IndyInterface.bootstrap("invoke", "put", 0, iterationValues, "noDescription", IndyInterface.bootstrap("invoke", "hasNoDescription", 2, this, description));
                IndyInterface.bootstrap("invoke", "put", 0, iterationValues, "description", IndyInterface.bootstrap("invoke", "richTextReplace", 2, this, description, IndyInterface.bootstrap("cast", "()", 0, this.results.get())));
                IndyInterface.bootstrap("invoke", "put", 0, iterationValues, "reference", IndyInterface.bootstrap("invoke", "getReference", 0, iteration));
                IndyInterface.bootstrap("invoke", "put", 0, iterationValues, "estimatedStartDate", IndyInterface.bootstrap("invoke", "translateDateShort", 0, IndyInterface.bootstrap("getProperty", "i18nHelper", 8, this), IndyInterface.bootstrap("invoke", "getScheduledStartDate", 0, iteration)));
                IndyInterface.bootstrap("invoke", "put", 0, iterationValues, "estimatedEndDate", IndyInterface.bootstrap("invoke", "translateDateShort", 0, IndyInterface.bootstrap("getProperty", "i18nHelper", 8, this), IndyInterface.bootstrap("invoke", "getScheduledEndDate", 0, iteration)));
                IndyInterface.bootstrap("invoke", "put", 0, iterationValues, "realizedStartDate", IndyInterface.bootstrap("invoke", "translateDateShort", 0, IndyInterface.bootstrap("getProperty", "i18nHelper", 8, this), IndyInterface.bootstrap("invoke", "getActualStartDate", 0, iteration)));
                IndyInterface.bootstrap("invoke", "put", 0, iterationValues, "realizedEndDate", IndyInterface.bootstrap("invoke", "translateDateShort", 0, IndyInterface.bootstrap("getProperty", "i18nHelper", 8, this), IndyInterface.bootstrap("invoke", "getActualEndDate", 0, iteration)));
                IndyInterface.bootstrap("invoke", "put", 0, iterationValues, "noEstimatedStartDate", ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "scheduledStartDate", 0, iteration), null));
                IndyInterface.bootstrap("invoke", "put", 0, iterationValues, "noEstimatedEndDate", ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "scheduledEndDate", 0, iteration), null));
                IndyInterface.bootstrap("invoke", "put", 0, iterationValues, "noRealizedStartDate", ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "actualStartDate", 0, iteration), null));
                IndyInterface.bootstrap("invoke", "put", 0, iterationValues, "noRealizedEndDate", ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "actualEndDate", 0, iteration), null));
                IndyInterface.bootstrap("invoke", "add", 0, coll, iterationValues);
                return coll;
            }

            @Generated
            public Object call(List coll, IterationInfo iteration) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, coll, iteration);
            }

            @Generated
            public String getCampaignPath() {
                return IndyInterface.bootstrap("cast", "()", 0, this.campaignPath.get());
            }

            @Generated
            public Map getResults() {
                return IndyInterface.bootstrap("cast", "()", 0, this.results.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildCampaignIterations_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite result = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "inject", 0, iterations, ScriptBytecodeAdapter.createList((Object[])new Object[0]), new _buildCampaignIterations_closure6(this, this, campaignPath2, results2)));
        return result;
    }

    private static void addLegacyCampaignFields(Map<String, Object> campaign, Map<String, Object> campaignDataMap) {
        IndyInterface.bootstrap("invoke", "put", 0, campaignDataMap, "campaignName", IndyInterface.bootstrap("invoke", "get", 0, campaign, "name"));
        IndyInterface.bootstrap("invoke", "put", 0, campaignDataMap, "campaignDescription", IndyInterface.bootstrap("invoke", "get", 0, campaign, "description"));
        IndyInterface.bootstrap("invoke", "put", 0, campaignDataMap, "campaignReference", IndyInterface.bootstrap("invoke", "get", 0, campaign, "reference"));
        IndyInterface.bootstrap("invoke", "put", 0, campaignDataMap, "campaignEstimatedStartDate", IndyInterface.bootstrap("invoke", "get", 0, campaign, "estimatedStartDate"));
        IndyInterface.bootstrap("invoke", "put", 0, campaignDataMap, "campaignEstimatedEndDate", IndyInterface.bootstrap("invoke", "get", 0, campaign, "estimatedEndDate"));
        IndyInterface.bootstrap("invoke", "put", 0, campaignDataMap, "campaignRealizedStartDate", IndyInterface.bootstrap("invoke", "get", 0, campaign, "realizedStartDate"));
        IndyInterface.bootstrap("invoke", "put", 0, campaignDataMap, "campaignRealizedEndDate", IndyInterface.bootstrap("invoke", "get", 0, campaign, "realizedEndDate"));
        IndyInterface.bootstrap("invoke", "put", 0, campaignDataMap, "noCampaignEstimatedStartDate", IndyInterface.bootstrap("invoke", "get", 0, campaign, "noEstimatedStartDate"));
        IndyInterface.bootstrap("invoke", "put", 0, campaignDataMap, "noCampaignEstimatedEndDate", IndyInterface.bootstrap("invoke", "get", 0, campaign, "noEstimatedEndDate"));
        IndyInterface.bootstrap("invoke", "put", 0, campaignDataMap, "noCampaignRealizedStartDate", IndyInterface.bootstrap("invoke", "get", 0, campaign, "noRealizedStartDate"));
        IndyInterface.bootstrap("invoke", "put", 0, campaignDataMap, "noCampaignRealizedEndDate", IndyInterface.bootstrap("invoke", "get", 0, campaign, "noRealizedEndDate"));
        IndyInterface.bootstrap("invoke", "put", 0, campaignDataMap, "iterations", IndyInterface.bootstrap("invoke", "get", 0, campaign, "iterations"));
    }

    public Map<String, Object> getComputedData(List<Map<String, Object>> campaignList, boolean includeAnnex, boolean includeIterationDetail) {
        CallSite result = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashMap.class));
        public final class _getComputedData_closure7
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getComputedData_closure7(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("getProperty", "iterations", 0, it) instanceof Collection;
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getComputedData_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        public final class _getComputedData_closure8
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getComputedData_closure8(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return (List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "iterations", 0, it), List.class));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getComputedData_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite allIterations = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collectMany", 0, IndyInterface.bootstrap("invoke", "findAll", 0, campaignList, new _getComputedData_closure7(this, this)), new _getComputedData_closure8(this, this)));
        public final class _getComputedData_closure9
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getComputedData_closure9(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("getProperty", "iterations", 0, it) instanceof Collection && ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "id", 0, it), null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getComputedData_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        public final class _getComputedData_closure10
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getComputedData_closure10(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object campaign) {
                return ScriptBytecodeAdapter.createList((Object[])new Object[]{(Long)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "id", 0, campaign), Long.class)), (List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "iterations", 0, campaign), List.class))});
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getComputedData_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite campaignIdToIterations = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collectEntries", 0, IndyInterface.bootstrap("invoke", "findAll", 0, campaignList, new _getComputedData_closure9(this, this)), new _getComputedData_closure10(this, this)));
        public final class _getComputedData_closure11
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getComputedData_closure11(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return (Long)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "id", 0, it), Long.class));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getComputedData_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite iterationIds = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, allIterations, new _getComputedData_closure11(this, this)));
        CallSite rawData = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getRawData", 2, this, iterationIds));
        public final class _getComputedData_closure12
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getComputedData_closure12(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object tuple) {
                return IndyInterface.bootstrap("invoke", "getItpiId", 0, tuple);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getComputedData_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite dedupRawData = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "unique", 0, rawData, false, new _getComputedData_closure12(this, this)));
        CallSite executionStatusData = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "calculateItExecutionStatusData", 2, this, campaignIdToIterations, dedupRawData));
        IndyInterface.bootstrap("invoke", "put", 0, result, "iterationsExecutionStatusData", executionStatusData);
        IndyInterface.bootstrap("invoke", "put", 0, result, "iterationExecutionStatusData", IndyInterface.bootstrap("invoke", "getLegacyExecutionStatusData", 0, CampaignReportDataBuilder.class, executionStatusData));
        IndyInterface.bootstrap("invoke", "putAll", 0, result, IndyInterface.bootstrap("invoke", "calculateTcExecutionByImportance", 2, this, dedupRawData));
        if (includeAnnex || includeIterationDetail) {
            IndyInterface.bootstrap("invoke", "put", 0, result, "iterationReqDatas", IndyInterface.bootstrap("invoke", "calculateRequirementRates", 2, this, allIterations, rawData));
        }
        if (includeAnnex) {
            IndyInterface.bootstrap("invoke", "put", 0, result, "iterationTcDatas", IndyInterface.bootstrap("invoke", "calculateTcRates", 2, this, allIterations, dedupRawData));
        }
        CallSite lastExecData = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findTuplesForLastExec", 2, this, rawData));
        IndyInterface.bootstrap("invoke", "put", 0, result, "lastExecData", IndyInterface.bootstrap("invoke", "doAllExecutionStatusCount", 2, this, lastExecData));
        IndyInterface.bootstrap("invoke", "put", 0, result, "lastExecRequirementData", IndyInterface.bootstrap("invoke", "calculateLastExecutionRequirementRate", 2, this, rawData));
        return result;
    }

    private static List<Map<String, Object>> getLegacyExecutionStatusData(Map<String, Object> executionStatusData) {
        List result = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        CallSite groupedRows = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, executionStatusData, CAMPAIGNS));
        if (DefaultTypeTransformation.booleanUnbox((Object)groupedRows) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, groupedRows)) == false) {
            CallSite firstEntry = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, groupedRows, false));
            CallSite rows = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, firstEntry, "iterations"));
            IndyInterface.bootstrap("invoke", "addAll", 0, result, rows);
        }
        IndyInterface.bootstrap("invoke", "add", 0, result, ScriptBytecodeAdapter.createPojoWrapper((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, executionStatusData, "total")), Map.class));
        return result;
    }

    public List<Map<String, Object>> calculateRequirementRates(List<Map<String, Object>> iterationList, List<AbstractTupleTemplate> rawData) {
        CallSite requirementRates = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class));
        Reference iteration = new Reference(null);
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, iterationList));
        if (callSite != null) {
            while (callSite.hasNext()) {
                iteration.set((Object)IndyInterface.bootstrap("cast", "()", 0, callSite.next()));
                public final class _calculateRequirementRates_closure13
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference iteration;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _calculateRequirementRates_closure13(Object _outerInstance, Object _thisObject, Reference iteration) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.iteration = reference = iteration;
                    }

                    public Object doCall(Object it) {
                        return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getIterationId", 0, it), (Object)IndyInterface.bootstrap("getProperty", "id", 0, IndyInterface.bootstrap("cast", "()", 0, this.iteration.get())));
                    }

                    @Generated
                    public Map getIteration() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.iteration.get());
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _calculateRequirementRates_closure13.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite rawDataForOneIt = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 0, rawData, new _calculateRequirementRates_closure13(this, this, iteration)));
                CallSite rate = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "calculateRequirementRatesForOneIt", 2, this, rawDataForOneIt, (Map)iteration.get()));
                IndyInterface.bootstrap("invoke", "add", 0, requirementRates, rate);
            }
        }
        return requirementRates;
    }

    public Map<String, Object> calculateItExecutionStatusData(Map<Long, List<Map<String, Object>>> campaignIdToIterations, List<CampaignTupleTemplate> rawData) {
        Reference rawData2 = new Reference(rawData);
        public final class _calculateItExecutionStatusData_closure14
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference rawData;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _calculateItExecutionStatusData_closure14(Object _outerInstance, Object _thisObject, Reference rawData) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.rawData = reference = rawData;
            }

            public Object doCall(Long campaignId, List<Map<String, Object>> iterations) {
                Reference campaignId2 = new Reference((Object)campaignId);
                public final class _closure18
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference rawData;
                    private /* synthetic */ Reference campaignId;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure18(Object _outerInstance, Object _thisObject, Reference rawData, Reference campaignId) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        this.rawData = reference2 = rawData;
                        this.campaignId = reference = campaignId;
                    }

                    public Object doCall(Map<String, Object> iteration) {
                        Reference iteration2 = new Reference(iteration);
                        public final class _closure19
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference campaignId;
                            private /* synthetic */ Reference iteration;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure19(Object _outerInstance, Object _thisObject, Reference campaignId, Reference iteration) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                Reference reference2;
                                this.campaignId = reference2 = campaignId;
                                this.iteration = reference = iteration;
                            }

                            public Object doCall(Object it) {
                                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getCampaignId", 0, it), (Object)IndyInterface.bootstrap("cast", "()", 0, this.campaignId.get())) && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getIterationId", 0, it), (Object)IndyInterface.bootstrap("getProperty", "id", 0, IndyInterface.bootstrap("cast", "()", 0, this.iteration.get())));
                            }

                            @Generated
                            public Long getCampaignId() {
                                return IndyInterface.bootstrap("cast", "()", 0, this.campaignId.get());
                            }

                            @Generated
                            public Map getIteration() {
                                return IndyInterface.bootstrap("cast", "()", 0, this.iteration.get());
                            }

                            @Generated
                            public Object doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure19.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }
                        }
                        CallSite rawDataForOneIt = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 0, IndyInterface.bootstrap("cast", "()", 0, this.rawData.get()), new _closure19((Object)this, this.getThisObject(), this.campaignId, iteration2)));
                        return IndyInterface.bootstrap("invoke", "computeOneIterationExecutionStatus", 2, this, rawDataForOneIt, (Map)iteration2.get(), ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "parentPath", 0, (Map)iteration2.get()), String.class))), String.class));
                    }

                    @Generated
                    public Object call(Map<String, Object> iteration) {
                        Reference iteration2 = new Reference(iteration);
                        return IndyInterface.bootstrap("invoke", "doCall", 2, this, (Map)iteration2.get());
                    }

                    @Generated
                    public List getRawData() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.rawData.get());
                    }

                    @Generated
                    public Long getCampaignId() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.campaignId.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure18.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite enrichedIterations = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, iterations, new _closure18((Object)this, this.getThisObject(), this.rawData, campaignId2)));
                CallSite callSite = IndyInterface.bootstrap("getProperty", "parentPath", 1, IndyInterface.bootstrap("invoke", "first", 0, iterations));
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : "", "iterations", enrichedIterations});
            }

            @Generated
            public Object call(Long campaignId, List<Map<String, Object>> iterations) {
                Reference campaignId2 = new Reference((Object)campaignId);
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, (Long)campaignId2.get(), iterations);
            }

            @Generated
            public List getRawData() {
                return IndyInterface.bootstrap("cast", "()", 0, this.rawData.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _calculateItExecutionStatusData_closure14.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite campaigns = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, campaignIdToIterations, new _calculateItExecutionStatusData_closure14(this, this, rawData2)));
        CallSite allIterations = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "flatten", 0, ScriptBytecodeAdapter.getPropertySpreadSafe(CampaignReportDataBuilder.class, (Object)campaigns, (String)"iterations")));
        CallSite totalLine = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "calculateSummaryExecutionStatusData", 2, this, allIterations));
        return ScriptBytecodeAdapter.createMap((Object[])new Object[]{CAMPAIGNS, campaigns, "total", totalLine});
    }

    public Map<String, Object> calculateSummaryExecutionStatusData(List<Map<String, Object>> computedDatas) {
        Map initialValues = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", IndyInterface.bootstrap("invoke", "translate", 0, IndyInterface.bootstrap("getProperty", "i18nHelper", 12, this), "report.campaignassessment.label.sum"), IndyInterface.bootstrap("getProperty", "STATUS_READY", 0, AbstractReportDataBuilder.class), 0, IndyInterface.bootstrap("getProperty", "STATUS_RUNNING", 0, AbstractReportDataBuilder.class), 0, IndyInterface.bootstrap("getProperty", "STATUS_SUCCESS", 0, AbstractReportDataBuilder.class), 0, IndyInterface.bootstrap("getProperty", "STATUS_SETTLED", 0, AbstractReportDataBuilder.class), 0, IndyInterface.bootstrap("getProperty", "STATUS_FAILURE", 0, AbstractReportDataBuilder.class), 0, IndyInterface.bootstrap("getProperty", "STATUS_BLOCKED", 0, AbstractReportDataBuilder.class), 0, IndyInterface.bootstrap("getProperty", "STATUS_UNTESTABLE", 0, AbstractReportDataBuilder.class), 0, "sum", 0, "executed", 0, "executedPercent", 0});
        public final class _calculateSummaryExecutionStatusData_closure15
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _calculateSummaryExecutionStatusData_closure15(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            /*
             * WARNING - void declaration
             */
            public Object doCall(Map<String, Object> acc, Map<String, Object> row) {
                void var2_2;
                Reference acc2 = new Reference(acc);
                Reference row2 = new Reference((Object)var2_2);
                CallSite keys = IndyInterface.bootstrap("invoke", "plus", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{"sum", "executed"}), IndyInterface.bootstrap("getProperty", "ALL_EXECUTION_STATUS", 0, AbstractReportDataBuilder.class));
                public final class _closure20
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference acc;
                    private /* synthetic */ Reference row;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure20(Object _outerInstance, Object _thisObject, Reference acc, Reference row) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        this.acc = reference2 = acc;
                        this.row = reference = row;
                    }

                    public Object doCall(Object key) {
                        CallSite callSite = IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.acc.get()), key);
                        Object object = IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : Integer.valueOf(0);
                        CallSite callSite2 = IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.row.get()), key);
                        CallSite callSite3 = IndyInterface.bootstrap("invoke", "plus", 0, object, IndyInterface.bootstrap("cast", "()", 0, callSite2) != false ? callSite2 : Integer.valueOf(0));
                        IndyInterface.bootstrap("invoke", "putAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.acc.get()), key, callSite3);
                        return callSite3;
                    }

                    @Generated
                    public Map getAcc() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.acc.get());
                    }

                    @Generated
                    public Map getRow() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.row.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure20.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "each", 0, keys, new _closure20((Object)this, this.getThisObject(), acc2, row2));
                return (Map)acc2.get();
            }

            /*
             * WARNING - void declaration
             */
            @Generated
            public Object call(Map<String, Object> acc, Map<String, Object> row) {
                void var2_2;
                Reference acc2 = new Reference(acc);
                Reference row2 = new Reference((Object)var2_2);
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, (Map)acc2.get(), (Map)row2.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _calculateSummaryExecutionStatusData_closure15.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite total = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "inject", 0, computedDatas, ScriptBytecodeAdapter.createPojoWrapper((Object)((Map)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "clone", 0, initialValues), Map.class))), Map.class), new _calculateSummaryExecutionStatusData_closure15(this, this)));
        CallSite callSite = IndyInterface.bootstrap("invoke", "convertToStringPercent", 2, this, IndyInterface.bootstrap("invoke", "get", 0, total, "executed"), IndyInterface.bootstrap("invoke", "get", 0, total, "sum"));
        IndyInterface.bootstrap("invoke", "putAt", 0, total, "executedPercent", callSite);
        return total;
    }

    public List<Map<String, Object>> calculateTcRates(List<Map<String, Object>> iterations, List<CampaignTupleTemplate> rawData) {
        Reference rawData2 = new Reference(rawData);
        public final class _calculateTcRates_closure16
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference rawData;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _calculateTcRates_closure16(Object _outerInstance, Object _thisObject, Reference rawData) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.rawData = reference = rawData;
            }

            public Object doCall(List coll, Map<String, Object> iteration) {
                Reference iteration2 = new Reference(iteration);
                public final class _closure21
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference iteration;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure21(Object _outerInstance, Object _thisObject, Reference iteration) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.iteration = reference = iteration;
                    }

                    public Object doCall(Object it) {
                        return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getIterationId", 0, it), (Object)IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("cast", "()", 0, this.iteration.get()), "id"));
                    }

                    @Generated
                    public Map getIteration() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.iteration.get());
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure21.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite rawDataForOneIt = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 0, IndyInterface.bootstrap("cast", "()", 0, this.rawData.get()), new _closure21((Object)this, this.getThisObject(), iteration2)));
                IndyInterface.bootstrap("invoke", "add", 0, coll, IndyInterface.bootstrap("invoke", "calculateTestCaseRatesForOneIt", 2, this, rawDataForOneIt, (Map)iteration2.get()));
                return coll;
            }

            @Generated
            public Object call(List coll, Map<String, Object> iteration) {
                Reference iteration2 = new Reference(iteration);
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, coll, (Map)iteration2.get());
            }

            @Generated
            public List getRawData() {
                return IndyInterface.bootstrap("cast", "()", 0, this.rawData.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _calculateTcRates_closure16.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite tcRates = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "inject", 0, iterations, ScriptBytecodeAdapter.createList((Object[])new Object[0]), new _calculateTcRates_closure16(this, this, rawData2)));
        return tcRates;
    }

    public Map<String, Object> computeOneIterationExecutionStatus(List<CampaignTupleTemplate> rawData, Map<String, Object> iteration, String campaignPath) {
        CallSite result = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashMap.class));
        IndyInterface.bootstrap("invoke", "putAll", 0, result, IndyInterface.bootstrap("invoke", "doAllExecutionStatusCount", 2, this, rawData));
        CallSite iterationFullName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, iteration, "reference"));
        iterationFullName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isBlank", 0, StringUtils.class, iterationFullName)) != false ? IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, iteration, "name")) : IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "plus", 0, iterationFullName, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("getProperty", "FULL_NAME_SEPARATOR", 0, Iteration.class), IndyInterface.bootstrap("invoke", "get", 0, iteration, "name"))));
        IndyInterface.bootstrap("invoke", "put", 0, result, "name", iterationFullName);
        return result;
    }

    public List<CampaignTupleTemplate> getRawData(List<Long> iterationsIds) {
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, iterationsIds)) != false) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "EMPTY_LIST", 0, ListUtils.class));
        }
        CallSite q = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createNativeQuery", 0, IndyInterface.bootstrap("getProperty", "em", 12, this), IndyInterface.bootstrap("getProperty", "REQUEST_CAMPAIGN_ITPI_REQUIREMENT", 0, Queries.class)));
        IndyInterface.bootstrap("invoke", "setParameter", 0, q, "iterationIds", iterationsIds);
        CallSite result = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getResultList", 0, q));
        public final class _getRawData_closure17
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getRawData_closure17(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite template = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, CampaignTupleTemplate.class));
                IndyInterface.bootstrap("invoke", "setCampaignId", 0, template, ScriptBytecodeAdapter.createPojoWrapper((Object)((Long)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getAt", 0, it, false), Long.class))), Long.class));
                IndyInterface.bootstrap("invoke", "setIterationId", 0, template, ScriptBytecodeAdapter.createPojoWrapper((Object)((Long)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getAt", 0, it, true), Long.class))), Long.class));
                IndyInterface.bootstrap("invoke", "setIterationName", 0, template, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "getAt", 0, it, 2)));
                IndyInterface.bootstrap("invoke", "setItpiId", 0, template, ScriptBytecodeAdapter.createPojoWrapper((Object)((Long)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getAt", 0, it, 3), Long.class))), Long.class));
                IndyInterface.bootstrap("invoke", "setExecutionStatus", 0, template, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "getAt", 0, it, 4)));
                IndyInterface.bootstrap("invoke", "setExecutionDate", 0, template, ScriptBytecodeAdapter.createPojoWrapper((Object)((Date)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getAt", 0, it, 5), Date.class))), Date.class));
                IndyInterface.bootstrap("invoke", "setDatasetId", 0, template, ScriptBytecodeAdapter.createPojoWrapper((Object)((Long)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getAt", 0, it, 6), Long.class))), Long.class));
                IndyInterface.bootstrap("invoke", "setTcId", 0, template, ScriptBytecodeAdapter.createPojoWrapper((Object)((Long)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getAt", 0, it, 7), Long.class))), Long.class));
                IndyInterface.bootstrap("invoke", "setTcName", 0, template, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "getAt", 0, it, 8)));
                IndyInterface.bootstrap("invoke", "setTcImportance", 0, template, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "getAt", 0, it, 9)));
                IndyInterface.bootstrap("invoke", "setTcReference", 0, template, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "getAt", 0, it, 10)));
                IndyInterface.bootstrap("invoke", "setCovId", 0, template, ScriptBytecodeAdapter.createPojoWrapper((Object)((Long)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getAt", 0, it, 11), Long.class))), Long.class));
                IndyInterface.bootstrap("invoke", "setReqVersionId", 0, template, ScriptBytecodeAdapter.createPojoWrapper((Object)((Long)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getAt", 0, it, 12), Long.class))), Long.class));
                IndyInterface.bootstrap("invoke", "setReqVersionName", 0, template, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "getAt", 0, it, 13)));
                IndyInterface.bootstrap("invoke", "setReqVersionCriticality", 0, template, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "getAt", 0, it, 14)));
                IndyInterface.bootstrap("invoke", "setReqVersionReference", 0, template, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "getAt", 0, it, 15)));
                return template;
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getRawData_closure17.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, result, new _getRawData_closure17(this, this)));
    }

    @Override
    public AbstractDefaultLocalKnownIssueFinder getKnownIssueFinder() {
        return this.campaignKnownIssueFinder;
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != CampaignReportDataBuilder.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, CampaignReportDataBuilder.class);
        LOGGER = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }
}

